/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Typeface;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import info.appdev.charting.components.Legend;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.data.Entry;
import info.appdev.charting.formatter.IValueFormatter;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.utils.ColorTemplate;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b1\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010J\u001a\u00020KJ\u0016\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000bJ\u0010\u0010U\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020\u000bH\u0016J\u0014\u0010f\u001a\u00020K2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0012\u0010f\u001a\u00020K2\n\u0010S\u001a\u00020g\"\u00020\u000bJ\u0016\u0010f\u001a\u00020K2\u0006\u0010S\u001a\u00020g2\u0006\u0010h\u001a\u00020iJ\u000e\u0010j\u001a\u00020K2\u0006\u0010M\u001a\u00020\u000bJ\u0016\u0010f\u001a\u00020K2\u0006\u0010S\u001a\u00020g2\u0006\u0010N\u001a\u00020\u000bJ\u0006\u0010k\u001a\u00020KJ\b\u0010w\u001a\u00020\u001bH\u0016J\u0010\u0010|\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0016J\u0012\u0010\u008e\u0001\u001a\u00020\u000b2\u0007\u0010\u008f\u0001\u001a\u00020\u000bH\u0016J\t\u0010\u0090\u0001\u001a\u00020\u001bH\u0016J\t\u0010\u0091\u0001\u001a\u00020\u001bH\u0016J\u0012\u0010\u0092\u0001\u001a\u00020\u001b2\u0007\u0010\u0093\u0001\u001a\u00020/H\u0016J\u0011\u0010\u0094\u0001\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020\u000bH\u0016J\u0018\u0010\u0095\u0001\u001a\u00020\u001b2\u0007\u0010\u0096\u0001\u001a\u00028\u0000H\u0016\u00a2\u0006\u0003\u0010\u0097\u0001J\u0016\u0010\u0098\u0001\u001a\u00020K2\u000b\u0010\u0099\u0001\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004R$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001d\"\u0004\b8\u0010\u001fR\u001a\u00109\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001d\"\u0004\b;\u0010\u001fR\u001a\u0010<\u001a\u00020=X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020/X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u001d\"\u0004\bI\u0010\u001fR$\u0010M\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010Q\"\u0004\bL\u0010RR\u001a\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010\rR(\u0010W\u001a\u0004\u0018\u0001022\b\u0010O\u001a\u0004\u0018\u0001028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R$\u0010\\\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\\\u0010\u001d\"\u0004\b]\u0010\u001fR$\u0010^\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010\u001d\"\u0004\b_\u0010\u001fR$\u0010`\u001a\u00020=2\u0006\u0010O\u001a\u00020=8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\ba\u0010?\"\u0004\bb\u0010AR$\u0010c\u001a\u00020/2\u0006\u0010O\u001a\u00020/8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bd\u0010D\"\u0004\be\u0010FR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010m\"\u0004\bn\u0010\bR$\u0010o\u001a\u00020\u00152\u0006\u0010O\u001a\u00020\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bp\u0010\u0017\"\u0004\bq\u0010\u0019R$\u0010r\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\br\u0010\u001d\"\u0004\bs\u0010\u001fR$\u0010t\u001a\u00020!2\u0006\u0010O\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bu\u0010#\"\u0004\bv\u0010%R0\u0010x\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\by\u0010\r\"\u0004\bz\u0010\u000fR$\u0010{\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b|\u0010Q\"\u0004\b}\u0010RR)\u0010~\u001a\u0004\u0018\u00010'2\b\u0010O\u001a\u0004\u0018\u00010'8V@VX\u0096\u000e\u00a2\u0006\r\u001a\u0004\b\u007f\u0010)\"\u0005\b\u0080\u0001\u0010+R'\u0010\u0081\u0001\u001a\u00020/2\u0006\u0010O\u001a\u00020/8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0082\u0001\u0010D\"\u0005\b\u0083\u0001\u0010FR)\u0010\u0084\u0001\u001a\u00020-2\u0006\u0010O\u001a\u00020-8V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R'\u0010\u0089\u0001\u001a\u00020/2\u0006\u0010O\u001a\u00020/8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u008a\u0001\u0010D\"\u0005\b\u008b\u0001\u0010FR'\u0010\u008c\u0001\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u008c\u0001\u0010\u001d\"\u0005\b\u008d\u0001\u0010\u001f\u00a8\u0006\u009a\u0001"}, d2={"Linfo/appdev/charting/data/BaseDataSet;", "T", "Linfo/appdev/charting/data/Entry;", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "<init>", "()V", "label", "", "(Ljava/lang/String;)V", "mColors", "", "", "getMColors", "()Ljava/util/List;", "setMColors", "(Ljava/util/List;)V", "mValueColors", "getMValueColors", "setMValueColors", "mLabel", "mAxisDependency", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "getMAxisDependency", "()Linfo/appdev/charting/components/YAxis$AxisDependency;", "setMAxisDependency", "(Linfo/appdev/charting/components/YAxis$AxisDependency;)V", "mHighlightEnabled", "", "getMHighlightEnabled", "()Z", "setMHighlightEnabled", "(Z)V", "mValueFormatter", "Linfo/appdev/charting/formatter/IValueFormatter;", "getMValueFormatter", "()Linfo/appdev/charting/formatter/IValueFormatter;", "setMValueFormatter", "(Linfo/appdev/charting/formatter/IValueFormatter;)V", "mValueTypeface", "Landroid/graphics/Typeface;", "getMValueTypeface", "()Landroid/graphics/Typeface;", "setMValueTypeface", "(Landroid/graphics/Typeface;)V", "mForm", "Linfo/appdev/charting/components/Legend$LegendForm;", "mFormSize", "", "mFormLineWidth", "mFormLineDashEffect", "Landroid/graphics/DashPathEffect;", "mIsVisible", "mIsDrawValues", "mIsDrawIcons", "mDrawValues", "getMDrawValues", "setMDrawValues", "mDrawIcons", "getMDrawIcons", "setMDrawIcons", "mIconsOffset", "Linfo/appdev/charting/utils/PointF;", "getMIconsOffset", "()Linfo/appdev/charting/utils/PointF;", "setMIconsOffset", "(Linfo/appdev/charting/utils/PointF;)V", "mValueTextSize", "getMValueTextSize", "()F", "setMValueTextSize", "(F)V", "mVisible", "getMVisible", "setMVisible", "notifyDataSetChanged", "", "setColor", "color", "alpha", "value", "getColor", "()I", "(I)V", "colors", "getColors", "getColorByIndex", "index", "formLineDashEffect", "getFormLineDashEffect", "()Landroid/graphics/DashPathEffect;", "setFormLineDashEffect", "(Landroid/graphics/DashPathEffect;)V", "isDrawValues", "setDrawValues", "isDrawIcons", "setDrawIcons", "iconsOffset", "getIconsOffset", "setIconsOffset", "formLineWidth", "getFormLineWidth", "setFormLineWidth", "setColors", "", "context", "Landroid/content/Context;", "addColor", "resetColors", "getLabel", "()Ljava/lang/String;", "setLabel", "axisDependency", "getAxisDependency", "setAxisDependency", "isHighlightEnabled", "setHighlightEnabled", "valueFormatter", "getValueFormatter", "setValueFormatter", "needsFormatter", "valueTextColors", "getValueTextColors", "setValueTextColors", "valueTextColor", "getValueTextColor", "setValueTextColor", "valueTypeface", "getValueTypeface", "setValueTypeface", "valueTextSize", "getValueTextSize", "setValueTextSize", "form", "getForm", "()Linfo/appdev/charting/components/Legend$LegendForm;", "setForm", "(Linfo/appdev/charting/components/Legend$LegendForm;)V", "formSize", "getFormSize", "setFormSize", "isVisible", "setVisible", "getIndexInEntries", "xIndex", "removeFirst", "removeLast", "removeEntryByXValue", "xValue", "removeEntry", "contains", "entry", "(Linfo/appdev/charting/data/Entry;)Z", "copy", "baseDataSet", "chartLib_release"})
public abstract class BaseDataSet<T extends Entry>
implements IDataSet<T> {
    @ColorInt
    @NotNull
    private List<Integer> mColors;
    @ColorInt
    @NotNull
    private List<Integer> mValueColors;
    @NotNull
    private String mLabel;
    @NotNull
    private YAxis.AxisDependency mAxisDependency;
    private boolean mHighlightEnabled;
    @Nullable
    private transient IValueFormatter mValueFormatter;
    @Nullable
    private Typeface mValueTypeface;
    @NotNull
    private Legend.LegendForm mForm;
    private float mFormSize;
    private float mFormLineWidth;
    @Nullable
    private DashPathEffect mFormLineDashEffect;
    private boolean mIsVisible;
    private boolean mIsDrawValues;
    private boolean mIsDrawIcons;
    private boolean mDrawValues;
    private boolean mDrawIcons;
    @NotNull
    private PointF mIconsOffset;
    private float mValueTextSize;
    private boolean mVisible;

    public BaseDataSet() {
        this.mLabel = "DataSet";
        this.mAxisDependency = YAxis.AxisDependency.LEFT;
        this.mHighlightEnabled = true;
        this.mForm = Legend.LegendForm.DEFAULT;
        this.mFormSize = Float.NaN;
        this.mFormLineWidth = Float.NaN;
        this.mIsVisible = true;
        this.mIsDrawValues = true;
        this.mIsDrawIcons = true;
        this.mDrawValues = true;
        this.mDrawIcons = true;
        this.mIconsOffset = new PointF();
        this.mValueTextSize = 17.0f;
        this.mVisible = true;
        this.mColors = new ArrayList();
        this.mValueColors = new ArrayList();
        this.mColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.mValueColors.add(-16777216);
    }

    @NotNull
    protected final List<Integer> getMColors() {
        return this.mColors;
    }

    protected final void setMColors(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mColors = list;
    }

    @NotNull
    protected final List<Integer> getMValueColors() {
        return this.mValueColors;
    }

    protected final void setMValueColors(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mValueColors = list;
    }

    @NotNull
    protected final YAxis.AxisDependency getMAxisDependency() {
        return this.mAxisDependency;
    }

    protected final void setMAxisDependency(@NotNull YAxis.AxisDependency axisDependency) {
        Intrinsics.checkNotNullParameter((Object)((Object)axisDependency), (String)"<set-?>");
        this.mAxisDependency = axisDependency;
    }

    protected final boolean getMHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    protected final void setMHighlightEnabled(boolean bl) {
        this.mHighlightEnabled = bl;
    }

    @Nullable
    protected final IValueFormatter getMValueFormatter() {
        return this.mValueFormatter;
    }

    protected final void setMValueFormatter(@Nullable IValueFormatter iValueFormatter) {
        this.mValueFormatter = iValueFormatter;
    }

    @Nullable
    protected final Typeface getMValueTypeface() {
        return this.mValueTypeface;
    }

    protected final void setMValueTypeface(@Nullable Typeface typeface) {
        this.mValueTypeface = typeface;
    }

    protected final boolean getMDrawValues() {
        return this.mDrawValues;
    }

    protected final void setMDrawValues(boolean bl) {
        this.mDrawValues = bl;
    }

    protected final boolean getMDrawIcons() {
        return this.mDrawIcons;
    }

    protected final void setMDrawIcons(boolean bl) {
        this.mDrawIcons = bl;
    }

    @NotNull
    protected final PointF getMIconsOffset() {
        return this.mIconsOffset;
    }

    protected final void setMIconsOffset(@NotNull PointF pointF) {
        Intrinsics.checkNotNullParameter((Object)pointF, (String)"<set-?>");
        this.mIconsOffset = pointF;
    }

    protected final float getMValueTextSize() {
        return this.mValueTextSize;
    }

    protected final void setMValueTextSize(float f) {
        this.mValueTextSize = f;
    }

    protected final boolean getMVisible() {
        return this.mVisible;
    }

    protected final void setMVisible(boolean bl) {
        this.mVisible = bl;
    }

    public BaseDataSet(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this();
        this.mLabel = label;
    }

    public final void notifyDataSetChanged() {
        this.calcMinMax();
    }

    public final void setColor(int color, int alpha) {
        this.mColors.clear();
        this.mColors.add(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
    }

    @Override
    public int getColor() {
        return ((Number)this.mColors.get(0)).intValue();
    }

    @Override
    public void setColor(int value) {
        this.mColors.clear();
        this.mColors.add(value);
    }

    @Override
    @NotNull
    public List<Integer> getColors() {
        return this.mColors;
    }

    @Override
    public int getColorByIndex(int index) {
        return ((Number)this.mColors.get(index % this.mColors.size())).intValue();
    }

    @Override
    @Nullable
    public DashPathEffect getFormLineDashEffect() {
        return this.mFormLineDashEffect;
    }

    public void setFormLineDashEffect(@Nullable DashPathEffect value) {
        this.mFormLineDashEffect = value;
    }

    @Override
    public boolean isDrawValues() {
        return this.mIsDrawValues;
    }

    @Override
    public void setDrawValues(boolean value) {
        this.mIsDrawValues = value;
    }

    @Override
    public boolean isDrawIcons() {
        return this.mIsDrawIcons;
    }

    @Override
    public void setDrawIcons(boolean value) {
        this.mIsDrawIcons = value;
    }

    @Override
    @NotNull
    public PointF getIconsOffset() {
        return this.mIconsOffset;
    }

    @Override
    public void setIconsOffset(@NotNull PointF value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mIconsOffset = value;
    }

    @Override
    public float getFormLineWidth() {
        return this.mFormLineWidth;
    }

    @Override
    public void setFormLineWidth(float value) {
        this.mFormLineWidth = value;
    }

    public final void setColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.mColors = colors;
    }

    public final void setColors(int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.mColors = ColorTemplate.INSTANCE.createColors(colors);
    }

    public final void setColors(@NotNull int[] colors, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mColors.clear();
        for (int color : colors) {
            this.mColors.add(ContextCompat.getColor((Context)context, (int)color));
        }
    }

    public final void addColor(int color) {
        this.mColors.add(color);
    }

    public final void setColors(@NotNull int[] colors, int alpha) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.resetColors();
        for (int color : colors) {
            this.addColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
        }
    }

    public final void resetColors() {
        this.mColors.clear();
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void setLabel(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mLabel = value;
    }

    @Override
    @NotNull
    public YAxis.AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    @Override
    public void setAxisDependency(@NotNull YAxis.AxisDependency value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.mAxisDependency = value;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    @Override
    public void setHighlightEnabled(boolean value) {
        this.mHighlightEnabled = value;
    }

    @Override
    @NotNull
    public IValueFormatter getValueFormatter() {
        IValueFormatter iValueFormatter;
        if (this.needsFormatter()) {
            iValueFormatter = Utils.INSTANCE.getDefaultValueFormatter();
        } else {
            IValueFormatter iValueFormatter2 = this.mValueFormatter;
            iValueFormatter = iValueFormatter2;
            Intrinsics.checkNotNull((Object)iValueFormatter2);
        }
        return iValueFormatter;
    }

    @Override
    public void setValueFormatter(@NotNull IValueFormatter value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mValueFormatter = value;
    }

    @Override
    public boolean needsFormatter() {
        return this.mValueFormatter == null;
    }

    @Override
    @NotNull
    public List<Integer> getValueTextColors() {
        return this.mValueColors;
    }

    @Override
    public void setValueTextColors(@NotNull List<Integer> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.mValueColors = value;
    }

    @Override
    public int getValueTextColor() {
        return this.mValueColors.isEmpty() ? 0 : ((Number)this.mValueColors.get(0)).intValue();
    }

    @Override
    public void setValueTextColor(int value) {
        this.mValueColors.clear();
        this.mValueColors.add(value);
    }

    @Override
    public int getValueTextColor(int value) {
        return ((Number)this.mValueColors.get(value % this.mValueColors.size())).intValue();
    }

    @Override
    @Nullable
    public Typeface getValueTypeface() {
        return this.mValueTypeface;
    }

    @Override
    public void setValueTypeface(@Nullable Typeface value) {
        this.mValueTypeface = value;
    }

    @Override
    public float getValueTextSize() {
        return this.mValueTextSize;
    }

    @Override
    public void setValueTextSize(float value) {
        this.mValueTextSize = NumberUtilsKt.convertDpToPixel(value);
    }

    @Override
    @NotNull
    public Legend.LegendForm getForm() {
        return this.mForm;
    }

    public void setForm(@NotNull Legend.LegendForm value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.mForm = value;
    }

    @Override
    public float getFormSize() {
        return this.mFormSize;
    }

    public void setFormSize(float value) {
        this.mFormSize = value;
    }

    @Override
    public boolean isVisible() {
        return this.mIsVisible;
    }

    @Override
    public void setVisible(boolean value) {
        this.mIsVisible = value;
    }

    @Override
    public int getIndexInEntries(int xIndex) {
        int n = this.getEntryCount();
        for (int i = 0; i < n; ++i) {
            float f = xIndex;
            Object t = this.getEntryForIndex(i);
            Intrinsics.checkNotNull(t);
            if (!(f == ((Entry)t).getX())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean removeFirst() {
        if (this.getEntryCount() > 0) {
            Object entry;
            Object t = entry = this.getEntryForIndex(0);
            return t != null ? this.removeEntry(t) : false;
        }
        return false;
    }

    @Override
    public boolean removeLast() {
        if (this.getEntryCount() > 0) {
            Object entry;
            Object t = entry = this.getEntryForIndex(this.getEntryCount() - 1);
            return t != null ? this.removeEntry(t) : false;
        }
        return false;
    }

    @Override
    public boolean removeEntryByXValue(float xValue) {
        Object entry;
        Object t = entry = this.getEntryForXValue(xValue, Float.NaN);
        return t != null ? this.removeEntry(t) : false;
    }

    @Override
    public boolean removeEntry(int index) {
        Object entry;
        Object t = entry = this.getEntryForIndex(index);
        return t != null ? this.removeEntry(t) : false;
    }

    @Override
    public boolean contains(@NotNull T entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        int n = this.getEntryCount();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual(this.getEntryForIndex(i), entry)) continue;
            return true;
        }
        return false;
    }

    protected final void copy(@NotNull BaseDataSet<?> baseDataSet) {
        Intrinsics.checkNotNullParameter(baseDataSet, (String)"baseDataSet");
        baseDataSet.mAxisDependency = this.mAxisDependency;
        baseDataSet.mColors = this.mColors;
        baseDataSet.mDrawIcons = this.mDrawIcons;
        baseDataSet.mDrawValues = this.mDrawValues;
        baseDataSet.mForm = this.mForm;
        baseDataSet.mFormLineDashEffect = this.mFormLineDashEffect;
        baseDataSet.setFormLineWidth(this.getFormLineWidth());
        baseDataSet.mFormSize = this.mFormSize;
        baseDataSet.mHighlightEnabled = this.mHighlightEnabled;
        baseDataSet.mIconsOffset = this.mIconsOffset;
        baseDataSet.mValueColors = this.mValueColors;
        baseDataSet.mValueFormatter = this.mValueFormatter;
        baseDataSet.mValueTextSize = this.mValueTextSize;
        baseDataSet.mVisible = this.mVisible;
    }
}

