/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer.scatter;

import android.graphics.Canvas;
import android.graphics.Paint;
import info.appdev.charting.interfaces.datasets.IScatterDataSet;
import info.appdev.charting.renderer.scatter.IShapeRenderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Linfo/appdev/charting/renderer/scatter/CircleShapeRenderer;", "Linfo/appdev/charting/renderer/scatter/IShapeRenderer;", "<init>", "()V", "renderShape", "", "canvas", "Landroid/graphics/Canvas;", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IScatterDataSet;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "posX", "", "posY", "renderPaint", "Landroid/graphics/Paint;", "chartLib_release"})
public final class CircleShapeRenderer
implements IShapeRenderer {
    @Override
    public void renderShape(@NotNull Canvas canvas, @NotNull IScatterDataSet dataSet, @Nullable ViewPortHandler viewPortHandler, float posX, float posY, @NotNull Paint renderPaint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Intrinsics.checkNotNullParameter((Object)renderPaint, (String)"renderPaint");
        float shapeSize = NumberUtilsKt.convertDpToPixel(dataSet.getScatterShapeSize());
        float shapeHalf = shapeSize / 2.0f;
        float shapeHoleSizeHalf = NumberUtilsKt.convertDpToPixel(dataSet.getScatterShapeHoleRadius());
        float shapeHoleSize = shapeHoleSizeHalf * 2.0f;
        float shapeStrokeSize = (shapeSize - shapeHoleSize) / 2.0f;
        float shapeStrokeSizeHalf = shapeStrokeSize / 2.0f;
        int shapeHoleColor = dataSet.getScatterShapeHoleColor();
        if ((double)shapeSize > 0.0) {
            renderPaint.setStyle(Paint.Style.STROKE);
            renderPaint.setStrokeWidth(shapeStrokeSize);
            canvas.drawCircle(posX, posY, shapeHoleSizeHalf + shapeStrokeSizeHalf, renderPaint);
            if (shapeHoleColor != 0x112233) {
                renderPaint.setStyle(Paint.Style.FILL);
                renderPaint.setColor(shapeHoleColor);
                canvas.drawCircle(posX, posY, shapeHoleSizeHalf, renderPaint);
            }
        } else {
            renderPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(posX, posY, shapeHalf, renderPaint);
        }
    }
}

