/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import android.graphics.Color;
import info.appdev.charting.data.BarEntry;
import info.appdev.charting.data.BarLineScatterCandleBubbleDataSet;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.utils.Fill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000H\u0004J\u0012\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u000bH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\u0016\u0010)\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0007J\u0016\u0010+\u001a\u00020\u001e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0002J\u0016\u0010,\u001a\u00020\u001e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0002J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0002H\u0014J\u0010\u0010G\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00160\u00058\u0007@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00160\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0019\"\u0004\b\"\u0010\u001bR$\u0010/\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u00102R\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00105R$\u00106\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0014\"\u0004\b8\u00102R$\u00109\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010\u0014\"\u0004\b;\u00102R$\u0010<\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R$\u0010A\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010\u0014\"\u0004\bC\u00102R0\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010\u0019\"\u0004\bF\u0010\u001b\u00a8\u0006H"}, d2={"Linfo/appdev/charting/data/BarDataSet;", "Linfo/appdev/charting/data/BarLineScatterCandleBubbleDataSet;", "Linfo/appdev/charting/data/BarEntry;", "Linfo/appdev/charting/interfaces/datasets/IBarDataSet;", "yVals", "", "label", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "mStackSize", "", "mBarShadowColor", "mBarBorderWidth", "", "mBarBorderColor", "mHighLightAlpha", "value", "entryCountStacks", "getEntryCountStacks", "()I", "mStackLabels", "Linfo/appdev/charting/utils/Fill;", "gradients", "getGradients", "()Ljava/util/List;", "setGradients", "(Ljava/util/List;)V", "copy", "Linfo/appdev/charting/data/DataSet;", "", "barDataSet", "fills", "getFills", "setFills", "getFill", "index", "getGradient", "setGradientColor", "startColor", "endColor", "setGradientColors", "gradientColors", "calcEntryCountIncludingStacks", "calcStackSize", "calcMinMax", "entry", "stackSize", "getStackSize", "setStackSize", "(I)V", "isStacked", "", "()Z", "barShadowColor", "getBarShadowColor", "setBarShadowColor", "barBorderColor", "getBarBorderColor", "setBarBorderColor", "barBorderWidth", "getBarBorderWidth", "()F", "setBarBorderWidth", "(F)V", "highLightAlpha", "getHighLightAlpha", "setHighLightAlpha", "stackLabels", "getStackLabels", "setStackLabels", "getEntryIndex", "chartLib_release"})
public class BarDataSet
extends BarLineScatterCandleBubbleDataSet<BarEntry>
implements IBarDataSet {
    private int mStackSize;
    private int mBarShadowColor;
    private float mBarBorderWidth;
    private int mBarBorderColor;
    private int mHighLightAlpha;
    private int entryCountStacks;
    @NotNull
    private List<String> mStackLabels;
    @NotNull
    private List<Fill> gradients;

    public BarDataSet(@NotNull List<BarEntry> yVals, @NotNull String label) {
        Intrinsics.checkNotNullParameter(yVals, (String)"yVals");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(yVals, label);
        this.mStackSize = 1;
        this.mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
        this.mBarBorderColor = -16777216;
        this.mHighLightAlpha = 120;
        this.mStackLabels = new ArrayList();
        this.gradients = new ArrayList();
        this.setHighLightColor(Color.rgb((int)0, (int)0, (int)0));
        this.calcStackSize(yVals);
        this.calcEntryCountIncludingStacks(yVals);
    }

    public final int getEntryCountStacks() {
        return this.entryCountStacks;
    }

    @Deprecated(message="Use getFills() instead")
    @NotNull
    public final List<Fill> getGradients() {
        return this.gradients;
    }

    protected final void setGradients(@NotNull List<Fill> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.gradients = list;
    }

    @Override
    @Nullable
    public DataSet<BarEntry> copy() {
        List entries = new ArrayList();
        List list = this.getMEntries();
        if (list != null) {
            List it = list;
            boolean bl = false;
            int n = ((Collection)it).size();
            for (int i = 0; i < n; ++i) {
                entries.add(((BarEntry)it.get(i)).copy());
            }
        }
        BarDataSet copied = new BarDataSet(entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected final void copy(@NotNull BarDataSet barDataSet) {
        Intrinsics.checkNotNullParameter((Object)barDataSet, (String)"barDataSet");
        super.copy(barDataSet);
        barDataSet.mStackSize = this.mStackSize;
        barDataSet.mBarShadowColor = this.mBarShadowColor;
        barDataSet.mBarBorderWidth = this.mBarBorderWidth;
        barDataSet.mStackLabels = this.mStackLabels;
        barDataSet.mHighLightAlpha = this.mHighLightAlpha;
    }

    @Override
    @NotNull
    public List<Fill> getFills() {
        return this.gradients;
    }

    @Override
    public void setFills(@NotNull List<Fill> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.gradients = value;
    }

    @Override
    @Nullable
    public Fill getFill(int index) {
        return this.gradients.get(index % this.gradients.size());
    }

    @Deprecated(message="Use getFill(...) instead")
    @Nullable
    public final Fill getGradient(int index) {
        return this.getFill(index);
    }

    public final void setGradientColor(int startColor, int endColor) {
        this.gradients.clear();
        this.gradients.add(new Fill(startColor, endColor));
    }

    @Deprecated(message="Use setFills(...) instead")
    public final void setGradientColors(@NotNull List<Fill> gradientColors) {
        Intrinsics.checkNotNullParameter(gradientColors, (String)"gradientColors");
        this.gradients = gradientColors;
    }

    private final void calcEntryCountIncludingStacks(List<BarEntry> yVals) {
        this.entryCountStacks = 0;
        int n = ((Collection)yVals).size();
        for (int i = 0; i < n; ++i) {
            float[] vals = yVals.get(i).getYVals();
            if (vals == null) {
                int n2 = this.entryCountStacks;
                this.entryCountStacks = n2 + 1;
                continue;
            }
            this.entryCountStacks += vals.length;
        }
    }

    private final void calcStackSize(List<BarEntry> yVals) {
        int n = ((Collection)yVals).size();
        for (int i = 0; i < n; ++i) {
            float[] vals = yVals.get(i).getYVals();
            if (vals == null || vals.length <= this.mStackSize) continue;
            this.mStackSize = vals.length;
        }
    }

    @Override
    protected void calcMinMax(@NotNull BarEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (!Float.isNaN(entry.getY())) {
            if (entry.getYVals() == null) {
                if (entry.getY() < this.getYMin()) {
                    this.setYMin(entry.getY());
                }
                if (entry.getY() > this.getYMax()) {
                    this.setYMax(entry.getY());
                }
            } else {
                if (-entry.getNegativeSum() < this.getYMin()) {
                    this.setYMin(-entry.getNegativeSum());
                }
                if (entry.getPositiveSum() > this.getYMax()) {
                    this.setYMax(entry.getPositiveSum());
                }
            }
            this.calcMinMaxX((Entry)entry);
        }
    }

    @Override
    public int getStackSize() {
        return this.mStackSize;
    }

    @Override
    public void setStackSize(int value) {
        this.mStackSize = value;
    }

    @Override
    public boolean isStacked() {
        return this.mStackSize > 1;
    }

    @Override
    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    @Override
    public void setBarShadowColor(int value) {
        this.mBarShadowColor = value;
    }

    @Override
    public int getBarBorderColor() {
        return this.mBarBorderColor;
    }

    @Override
    public void setBarBorderColor(int value) {
        this.mBarBorderColor = value;
    }

    @Override
    public float getBarBorderWidth() {
        return this.mBarBorderWidth;
    }

    @Override
    public void setBarBorderWidth(float value) {
        this.mBarBorderWidth = value;
    }

    @Override
    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    @Override
    public void setHighLightAlpha(int value) {
        this.mHighLightAlpha = value;
    }

    @Override
    @NotNull
    public List<String> getStackLabels() {
        return this.mStackLabels;
    }

    @Override
    public void setStackLabels(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.mStackLabels = value;
    }

    @Override
    public int getEntryIndex(@NotNull BarEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return this.getEntryIndex(entry);
    }
}

