/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.animation;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import androidx.annotation.RequiresApi;
import info.appdev.charting.animation.Easing;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0003J\u001a\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0007J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0007J\"\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J,\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u0016H\u0007J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0007J\u001a\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR$\u0010\"\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\rR$\u0010%\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\r\u00a8\u0006("}, d2={"Linfo/appdev/charting/animation/ChartAnimator;", "", "<init>", "()V", "listener", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "(Landroid/animation/ValueAnimator$AnimatorUpdateListener;)V", "animatorUpdateListener", "mPhaseY", "", "getMPhaseY", "()F", "setMPhaseY", "(F)V", "mPhaseX", "getMPhaseX", "setMPhaseX", "xAnimator", "Landroid/animation/ObjectAnimator;", "duration", "", "easing", "Linfo/appdev/charting/animation/Easing$EasingFunction;", "yAnimator", "animateX", "", "durationMillis", "animateXY", "durationMillisX", "durationMillisY", "easingX", "easingY", "animateY", "phase", "phaseY", "getPhaseY", "setPhaseY", "phaseX", "getPhaseX", "setPhaseX", "chartLib_release"})
public final class ChartAnimator {
    @Nullable
    private ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
    private float mPhaseY = 1.0f;
    private float mPhaseX = 1.0f;

    protected final float getMPhaseY() {
        return this.mPhaseY;
    }

    protected final void setMPhaseY(float f) {
        this.mPhaseY = f;
    }

    protected final float getMPhaseX() {
        return this.mPhaseX;
    }

    protected final void setMPhaseX(float f) {
        this.mPhaseX = f;
    }

    public ChartAnimator() {
    }

    @RequiresApi(value=11)
    public ChartAnimator(@Nullable ValueAnimator.AnimatorUpdateListener listener) {
        this.animatorUpdateListener = listener;
    }

    @RequiresApi(value=11)
    private final ObjectAnimator xAnimator(int duration, Easing.EasingFunction easing) {
        float[] fArray = new float[]{0.0f, 1.0f};
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])fArray);
        animatorX.setInterpolator((TimeInterpolator)easing);
        animatorX.setDuration((long)duration);
        Intrinsics.checkNotNull((Object)animatorX);
        return animatorX;
    }

    @RequiresApi(value=11)
    private final ObjectAnimator yAnimator(int duration, Easing.EasingFunction easing) {
        float[] fArray = new float[]{0.0f, 1.0f};
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])fArray);
        animatorY.setInterpolator((TimeInterpolator)easing);
        animatorY.setDuration((long)duration);
        Intrinsics.checkNotNull((Object)animatorY);
        return animatorY;
    }

    @RequiresApi(value=11)
    public final void animateX(int durationMillis) {
        this.animateX(durationMillis, Easing.INSTANCE.getLinear());
    }

    @RequiresApi(value=11)
    public final void animateX(int durationMillis, @Nullable Easing.EasingFunction easing) {
        ObjectAnimator animatorX = this.xAnimator(durationMillis, easing);
        animatorX.addUpdateListener(this.animatorUpdateListener);
        animatorX.start();
    }

    @RequiresApi(value=11)
    public final void animateXY(int durationMillisX, int durationMillisY) {
        this.animateXY(durationMillisX, durationMillisY, Easing.INSTANCE.getLinear(), Easing.INSTANCE.getLinear());
    }

    @RequiresApi(value=11)
    public final void animateXY(int durationMillisX, int durationMillisY, @Nullable Easing.EasingFunction easing) {
        ObjectAnimator xAnimator = this.xAnimator(durationMillisX, easing);
        ObjectAnimator yAnimator = this.yAnimator(durationMillisY, easing);
        if (durationMillisX > durationMillisY) {
            xAnimator.addUpdateListener(this.animatorUpdateListener);
        } else {
            yAnimator.addUpdateListener(this.animatorUpdateListener);
        }
        xAnimator.start();
        yAnimator.start();
    }

    @RequiresApi(value=11)
    public final void animateXY(int durationMillisX, int durationMillisY, @Nullable Easing.EasingFunction easingX, @Nullable Easing.EasingFunction easingY) {
        ObjectAnimator xAnimator = this.xAnimator(durationMillisX, easingX);
        ObjectAnimator yAnimator = this.yAnimator(durationMillisY, easingY);
        if (durationMillisX > durationMillisY) {
            xAnimator.addUpdateListener(this.animatorUpdateListener);
        } else {
            yAnimator.addUpdateListener(this.animatorUpdateListener);
        }
        xAnimator.start();
        yAnimator.start();
    }

    @RequiresApi(value=11)
    public final void animateY(int durationMillis) {
        this.animateY(durationMillis, Easing.INSTANCE.getLinear());
    }

    @RequiresApi(value=11)
    public final void animateY(int durationMillis, @Nullable Easing.EasingFunction easing) {
        ObjectAnimator animatorY = this.yAnimator(durationMillis, easing);
        animatorY.addUpdateListener(this.animatorUpdateListener);
        animatorY.start();
    }

    public final float getPhaseY() {
        return this.mPhaseY;
    }

    public final void setPhaseY(float phase) {
        float phase2 = phase;
        if (phase2 > 1.0f) {
            phase2 = 1.0f;
        } else if (phase2 < 0.0f) {
            phase2 = 0.0f;
        }
        this.mPhaseY = phase2;
    }

    public final float getPhaseX() {
        return this.mPhaseX;
    }

    public final void setPhaseX(float phase) {
        float phase2 = phase;
        if (phase2 > 1.0f) {
            phase2 = 1.0f;
        } else if (phase2 < 0.0f) {
            phase2 = 0.0f;
        }
        this.mPhaseX = phase2;
    }
}

