/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.data.CandleData;
import info.appdev.charting.data.CandleEntry;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.dataprovider.CandleDataProvider;
import info.appdev.charting.interfaces.datasets.ICandleDataSet;
import info.appdev.charting.renderer.LineScatterCandleRadarRenderer;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.Utils;
import info.appdev.charting.utils.UtilsKtKt;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J#\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Linfo/appdev/charting/renderer/CandleStickChartRenderer;", "Linfo/appdev/charting/renderer/LineScatterCandleRadarRenderer;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/CandleDataProvider;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/CandleDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getDataProvider", "()Linfo/appdev/charting/interfaces/dataprovider/CandleDataProvider;", "setDataProvider", "(Linfo/appdev/charting/interfaces/dataprovider/CandleDataProvider;)V", "shadowBuffers", "", "bodyBuffers", "rangeBuffers", "openBuffers", "closeBuffers", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "drawDataSet", "dataSet", "Linfo/appdev/charting/interfaces/datasets/ICandleDataSet;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nCandleStickChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandleStickChartRenderer.kt\ninfo/appdev/charting/renderer/CandleStickChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,318:1\n1915#2,2:319\n*S KotlinDebug\n*F\n+ 1 CandleStickChartRenderer.kt\ninfo/appdev/charting/renderer/CandleStickChartRenderer\n*L\n30#1:319,2\n*E\n"})
public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    @NotNull
    private CandleDataProvider dataProvider;
    @NotNull
    private final float[] shadowBuffers;
    @NotNull
    private final float[] bodyBuffers;
    @NotNull
    private final float[] rangeBuffers;
    @NotNull
    private final float[] openBuffers;
    @NotNull
    private final float[] closeBuffers;

    public CandleStickChartRenderer(@NotNull CandleDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.shadowBuffers = new float[8];
        this.bodyBuffers = new float[4];
        this.rangeBuffers = new float[4];
        this.openBuffers = new float[4];
        this.closeBuffers = new float[4];
    }

    @NotNull
    public final CandleDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public final void setDataProvider(@NotNull CandleDataProvider candleDataProvider) {
        Intrinsics.checkNotNullParameter((Object)candleDataProvider, (String)"<set-?>");
        this.dataProvider = candleDataProvider;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CandleData candleData = this.dataProvider.getCandleData();
            Object object = candleData;
            if (object == null || (object = ((ChartData)object).getDataSets()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ICandleDataSet set = (ICandleDataSet)element$iv;
                boolean bl = false;
                if (!set.isVisible()) continue;
                this.drawDataSet(canvas, set);
            }
        }
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull ICandleDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.getAnimator().getPhaseY();
        float barSpace = dataSet.getBarSpace();
        boolean showCandleBar = dataSet.getShowCandleBar();
        this.getXBounds();
        this.getXBounds().set(this.dataProvider, dataSet);
        this.getPaintRender().setStrokeWidth(dataSet.getShadowWidth());
        int j = this.getXBounds().getMin();
        int n = this.getXBounds().getRange() + this.getXBounds().getMin();
        if (j <= n) {
            while (true) {
                if ((CandleEntry)dataSet.getEntryForIndex(j) != null) {
                    CandleEntry e;
                    float xPos = e.getX();
                    float open = e.getOpen();
                    float close = e.getClose();
                    float high = e.getHigh();
                    float low = e.getLow();
                    if (showCandleBar) {
                        this.shadowBuffers[0] = xPos;
                        this.shadowBuffers[2] = xPos;
                        this.shadowBuffers[4] = xPos;
                        this.shadowBuffers[6] = xPos;
                        if (open > close) {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = open * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = close * phaseY;
                        } else if (open < close) {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = close * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = open * phaseY;
                        } else {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = open * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = this.shadowBuffers[3];
                        }
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.pointValuesToPixel(this.shadowBuffers);
                        if (dataSet.getShadowColorSameAsCandle()) {
                            if (open > close) {
                                this.getPaintRender().setColor(dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getDecreasingColor());
                            } else if (open < close) {
                                this.getPaintRender().setColor(dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getIncreasingColor());
                            } else {
                                this.getPaintRender().setColor(dataSet.getNeutralColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getNeutralColor());
                            }
                        } else {
                            this.getPaintRender().setColor(dataSet.getShadowColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getShadowColor());
                        }
                        this.getPaintRender().setStyle(Paint.Style.STROKE);
                        canvas.drawLines(this.shadowBuffers, this.getPaintRender());
                        this.bodyBuffers[0] = xPos - 0.5f + barSpace;
                        this.bodyBuffers[1] = close * phaseY;
                        this.bodyBuffers[2] = xPos + 0.5f - barSpace;
                        this.bodyBuffers[3] = open * phaseY;
                        trans.pointValuesToPixel(this.bodyBuffers);
                        if (open > close) {
                            if (dataSet.getDecreasingColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getDecreasingColor());
                            }
                            this.getPaintRender().setStyle(dataSet.getDecreasingPaintStyle());
                            canvas.drawRect(this.bodyBuffers[0], this.bodyBuffers[3], this.bodyBuffers[2], this.bodyBuffers[1], this.getPaintRender());
                        } else if (open < close) {
                            if (dataSet.getIncreasingColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getIncreasingColor());
                            }
                            this.getPaintRender().setStyle(dataSet.getIncreasingPaintStyle());
                            canvas.drawRect(this.bodyBuffers[0], this.bodyBuffers[1], this.bodyBuffers[2], this.bodyBuffers[3], this.getPaintRender());
                        } else {
                            if (dataSet.getNeutralColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getNeutralColor());
                            }
                            canvas.drawLine(this.bodyBuffers[0], this.bodyBuffers[1], this.bodyBuffers[2], this.bodyBuffers[3], this.getPaintRender());
                        }
                    } else {
                        this.rangeBuffers[0] = xPos;
                        this.rangeBuffers[1] = high * phaseY;
                        this.rangeBuffers[2] = xPos;
                        this.rangeBuffers[3] = low * phaseY;
                        this.openBuffers[0] = xPos - 0.5f + barSpace;
                        this.openBuffers[1] = open * phaseY;
                        this.openBuffers[2] = xPos;
                        this.openBuffers[3] = open * phaseY;
                        this.closeBuffers[0] = xPos + 0.5f - barSpace;
                        this.closeBuffers[1] = close * phaseY;
                        this.closeBuffers[2] = xPos;
                        this.closeBuffers[3] = close * phaseY;
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.pointValuesToPixel(this.rangeBuffers);
                        trans.pointValuesToPixel(this.openBuffers);
                        trans.pointValuesToPixel(this.closeBuffers);
                        int barColor = open > close ? (dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getDecreasingColor()) : (open < close ? (dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getIncreasingColor()) : (dataSet.getNeutralColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getNeutralColor()));
                        this.getPaintRender().setColor(barColor);
                        canvas.drawLine(this.rangeBuffers[0], this.rangeBuffers[1], this.rangeBuffers[2], this.rangeBuffers[3], this.getPaintRender());
                        canvas.drawLine(this.openBuffers[0], this.openBuffers[1], this.openBuffers[2], this.openBuffers[3], this.getPaintRender());
                        canvas.drawLine(this.closeBuffers[0], this.closeBuffers[1], this.closeBuffers[2], this.closeBuffers[3], this.getPaintRender());
                    }
                }
                if (j == n) break;
                ++j;
            }
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block8;
            CandleData candleData = this.dataProvider.getCandleData();
            if (candleData != null) {
                CandleData it = candleData;
                boolean bl = false;
                List list = it.getDataSets();
                if (list != null) {
                    List it1 = list;
                    boolean bl2 = false;
                    int n = ((Collection)it1).size();
                    for (int i = 0; i < n; ++i) {
                        List list2 = it.getDataSets();
                        Intrinsics.checkNotNull(list2);
                        ICandleDataSet dataSet = (ICandleDataSet)list2.get(i);
                        if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                        this.applyValueTextStyle(dataSet);
                        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                        this.getXBounds().set(this.dataProvider, dataSet);
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        float[] positions = transformer.generateTransformedValuesCandle(dataSet, this.getAnimator().getPhaseX(), this.getAnimator().getPhaseY(), this.getXBounds().getMin(), this.getXBounds().getMax());
                        float yOffset = UtilsKtKt.convertDpToPixel(5.0f);
                        PointF iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
                        iconsOffset.setX(UtilsKtKt.convertDpToPixel(iconsOffset.getX()));
                        iconsOffset.setY(UtilsKtKt.convertDpToPixel(iconsOffset.getY()));
                        int j = 0;
                        while (j < positions.length) {
                            float x = positions[j];
                            float y = positions[j + 1];
                            if (!this.getViewPortHandler().isInBoundsRight(x)) break;
                            if (!this.getViewPortHandler().isInBoundsLeft(x) || !this.getViewPortHandler().isInBoundsY(y)) {
                                j += 2;
                                continue;
                            }
                            Object t = dataSet.getEntryForIndex(j / 2 + this.getXBounds().getMin());
                            Intrinsics.checkNotNull(t);
                            CandleEntry entry = (CandleEntry)t;
                            if (dataSet.isDrawValues()) {
                                this.drawValue(canvas, dataSet.getValueFormatter(), entry.getHigh(), entry, i, x, y - yOffset, dataSet.getValueTextColor(j / 2));
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIcons()) {
                                Drawable icon = entry.getIcon();
                                if (icon != null) {
                                    Drawable ico;
                                    boolean bl3 = false;
                                    Utils.INSTANCE.drawImage(canvas, ico, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                                }
                            }
                            j += 2;
                        }
                        PointF.Companion.recycleInstance(iconsOffset);
                    }
                }
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        CandleData candleData = this.dataProvider.getCandleData();
        for (Highlight high : indices) {
            CandleEntry it;
            ICandleDataSet set;
            CandleData candleData2 = candleData;
            ICandleDataSet iCandleDataSet = set = candleData2 != null ? (ICandleDataSet)candleData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlightEnabled()) continue;
            CandleEntry candleEntry = (CandleEntry)set.getEntryForXValue(high.getX(), high.getY());
            if (candleEntry == null) continue;
            boolean bl = false;
            if (!this.isInBoundsX((Entry)candleEntry, set)) continue;
            float lowValue = it.getLow() * this.getAnimator().getPhaseY();
            float highValue = it.getHigh() * this.getAnimator().getPhaseY();
            float y = (lowValue + highValue) / 2.0f;
            Transformer transformer = this.dataProvider.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            PointD pix = transformer.getPixelForValues(it.getX(), y);
            high.setDraw((float)pix.getX(), (float)pix.getY());
            this.drawHighlightLines(canvas, (float)pix.getX(), (float)pix.getY(), set);
        }
    }
}

