/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration;
import com.github.mikephil.charting.utils.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0007*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0013*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0013*\u00020\u0013\u001a\u0006\u0010\u0017\u001a\u00020\u0007\u001a\u0012\u0010\u0016\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0013\u001a$\u0010\u0019\u001a\u00020\u001a*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\"\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006 "}, d2={"metrics", "Landroid/util/DisplayMetrics;", "getMetrics", "()Landroid/util/DisplayMetrics;", "setMetrics", "(Landroid/util/DisplayMetrics;)V", "minimumFlingVelocity", "", "getMinimumFlingVelocity", "()I", "setMinimumFlingVelocity", "(I)V", "maximumFlingVelocity", "getMaximumFlingVelocity", "setMaximumFlingVelocity", "initUtils", "", "Landroid/content/Context;", "getDecimals", "", "roundToNextSignificant", "", "convertDpToPixel", "getSDKInt", "dp", "formatNumber", "", "digitCount", "separateThousands", "", "separateChar", "", "MPChartLib_release"})
public final class UtilsKtKt {
    @Nullable
    private static DisplayMetrics metrics;
    private static int minimumFlingVelocity;
    private static int maximumFlingVelocity;

    @Nullable
    public static final DisplayMetrics getMetrics() {
        return metrics;
    }

    public static final void setMetrics(@Nullable DisplayMetrics displayMetrics) {
        metrics = displayMetrics;
    }

    public static final int getMinimumFlingVelocity() {
        return minimumFlingVelocity;
    }

    public static final void setMinimumFlingVelocity(int n) {
        minimumFlingVelocity = n;
    }

    public static final int getMaximumFlingVelocity() {
        return maximumFlingVelocity;
    }

    public static final void setMaximumFlingVelocity(int n) {
        maximumFlingVelocity = n;
    }

    public static final void initUtils(@NotNull Context $this$initUtils) {
        Intrinsics.checkNotNullParameter((Object)$this$initUtils, (String)"<this>");
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)$this$initUtils);
        minimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        maximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        metrics = $this$initUtils.getResources().getDisplayMetrics();
    }

    public static final int getDecimals(float $this$getDecimals) {
        float i = UtilsKtKt.roundToNextSignificant($this$getDecimals);
        if (Float.isInfinite(i)) {
            return 0;
        }
        return (int)Math.ceil(-Math.log10(i)) + 2;
    }

    public static final float roundToNextSignificant(double $this$roundToNextSignificant) {
        if (Double.isInfinite($this$roundToNextSignificant) || Double.isNaN($this$roundToNextSignificant) || $this$roundToNextSignificant == 0.0) {
            return 0.0f;
        }
        float d = (float)Math.ceil((float)Math.log10($this$roundToNextSignificant < 0.0 ? -$this$roundToNextSignificant : $this$roundToNextSignificant));
        int pw = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, pw);
        int shifted = MathKt.roundToInt((double)($this$roundToNextSignificant * (double)magnitude));
        return (float)shifted / magnitude;
    }

    public static final float convertDpToPixel(float $this$convertDpToPixel) {
        if (metrics == null) {
            Timber.Forest.e("Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertDpToPixel(...). Otherwise conversion does not take place.", new Object[0]);
            return $this$convertDpToPixel;
        }
        DisplayMetrics displayMetrics = metrics;
        Intrinsics.checkNotNull((Object)displayMetrics);
        return $this$convertDpToPixel * displayMetrics.density;
    }

    public static final int getSDKInt() {
        return Build.VERSION.SDK_INT;
    }

    public static final float convertDpToPixel(@NotNull Context $this$convertDpToPixel, float dp) {
        Intrinsics.checkNotNullParameter((Object)$this$convertDpToPixel, (String)"<this>");
        return dp * $this$convertDpToPixel.getResources().getDisplayMetrics().density;
    }

    @NotNull
    public static final String formatNumber(float $this$formatNumber, int digitCount, boolean separateThousands, char separateChar) {
        boolean zero;
        float number = $this$formatNumber;
        int digitCount2 = digitCount;
        char[] out = new char[35];
        boolean neg = false;
        if (number == 0.0f) {
            return "0";
        }
        boolean bl = zero = number < 1.0f && number > -1.0f;
        if (number < 0.0f) {
            neg = true;
            number = -number;
        }
        if (digitCount2 > Utils.INSTANCE.getPOW_10().length) {
            digitCount2 = Utils.INSTANCE.getPOW_10().length - 1;
        }
        int ind = out.length - 1;
        int charCount = 0;
        boolean decimalPointAdded = false;
        for (long lval = (long)Math.round(number *= (float)Utils.INSTANCE.getPOW_10()[digitCount2]); lval != 0L || charCount < digitCount2 + 1; lval /= (long)10) {
            int digit = (int)(lval % (long)10);
            out[ind--] = (char)(digit + 48);
            if (++charCount != digitCount2) continue;
            out[ind--] = 44;
            ++charCount;
            decimalPointAdded = true;
        }
        if (zero) {
            out[ind--] = 48;
            ++charCount;
        }
        if (neg) {
            out[ind--] = 45;
            ++charCount;
        }
        int start = out.length - charCount;
        return new String(out, start, out.length - start);
    }

    public static /* synthetic */ String formatNumber$default(float f, int n, boolean bl, char c, int n2, Object object) {
        if ((n2 & 4) != 0) {
            c = (char)46;
        }
        return UtilsKtKt.formatNumber(f, n, bl, c);
    }
}

