/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0014J \u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u00103\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010 \u001a\u00020\u001e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010,\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\r\"\u0004\b.\u0010\u000fR\u001a\u0010/\u001a\u00020\u001eX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\"\"\u0004\b1\u00102\u00a8\u00064"}, d2={"Lcom/github/mikephil/charting/renderer/YAxisRendererHorizontalBarChart;", "Lcom/github/mikephil/charting/renderer/YAxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "yAxis", "Lcom/github/mikephil/charting/components/YAxis;", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/YAxis;Lcom/github/mikephil/charting/utils/Transformer;)V", "drawZeroLinePathBuffer", "Landroid/graphics/Path;", "getDrawZeroLinePathBuffer", "()Landroid/graphics/Path;", "setDrawZeroLinePathBuffer", "(Landroid/graphics/Path;)V", "computeAxis", "", "min", "", "max", "inverted", "", "renderAxisLabels", "canvas", "Landroid/graphics/Canvas;", "renderAxisLine", "drawYLabels", "fixedPosition", "positions", "", "offset", "transformedPositions", "getTransformedPositions", "()[F", "gridClippingRect", "Landroid/graphics/RectF;", "getGridClippingRect", "()Landroid/graphics/RectF;", "linePath", "p", "i", "", "drawZeroLine", "mRenderLimitLinesPathBuffer", "getMRenderLimitLinesPathBuffer", "setMRenderLimitLinesPathBuffer", "renderLimitLinesBuffer", "getRenderLimitLinesBuffer", "setRenderLimitLinesBuffer", "([F)V", "renderLimitLines", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nYAxisRendererHorizontalBarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAxisRendererHorizontalBarChart.kt\ncom/github/mikephil/charting/renderer/YAxisRendererHorizontalBarChart\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,310:1\n27#2,7:311\n27#2,7:318\n*S KotlinDebug\n*F\n+ 1 YAxisRendererHorizontalBarChart.kt\ncom/github/mikephil/charting/renderer/YAxisRendererHorizontalBarChart\n*L\n189#1:311,7\n244#1:318,7\n*E\n"})
public class YAxisRendererHorizontalBarChart
extends YAxisRenderer {
    @NotNull
    private Path drawZeroLinePathBuffer;
    @NotNull
    private Path mRenderLimitLinesPathBuffer;
    @NotNull
    private float[] renderLimitLinesBuffer;

    public YAxisRendererHorizontalBarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull YAxis yAxis, @Nullable Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)yAxis, (String)"yAxis");
        super(viewPortHandler, yAxis, trans);
        this.drawZeroLinePathBuffer = new Path();
        this.mRenderLimitLinesPathBuffer = new Path();
        this.renderLimitLinesBuffer = new float[4];
        this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
    }

    @NotNull
    protected final Path getDrawZeroLinePathBuffer() {
        return this.drawZeroLinePathBuffer;
    }

    protected final void setDrawZeroLinePathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.drawZeroLinePathBuffer = path;
    }

    @Override
    public void computeAxis(float min, float max, boolean inverted) {
        float yMin = min;
        float yMax = max;
        if (this.viewPortHandler.contentHeight() > 10.0f && !this.viewPortHandler.isFullyZoomedOutX()) {
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD p1 = transformer.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop());
            Transformer transformer2 = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer2);
            MPPointD p2 = transformer2.getValuesByTouchPoint(this.viewPortHandler.contentRight(), this.viewPortHandler.contentTop());
            if (!inverted) {
                yMin = (float)p1.getX();
                yMax = (float)p2.getX();
            } else {
                yMin = (float)p2.getX();
                yMax = (float)p1.getX();
            }
            MPPointD.Companion.recycleInstance(p1);
            MPPointD.Companion.recycleInstance(p2);
        }
        this.computeAxisValues(yMin, yMax);
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.yAxis.isEnabled() || !this.yAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] positions = this.getTransformedPositions();
        this.getPaintAxisLabels().setTypeface(this.yAxis.getTypeface());
        this.getPaintAxisLabels().setTextSize(this.yAxis.getTextSize());
        this.getPaintAxisLabels().setColor(this.yAxis.getTextColor());
        this.getPaintAxisLabels().setTextAlign(Paint.Align.CENTER);
        float baseYOffset = UtilsKtKt.convertDpToPixel(2.5f);
        float textHeight = Utils.INSTANCE.calcTextHeight(this.getPaintAxisLabels(), "Q");
        YAxis.AxisDependency dependency = this.yAxis.getAxisDependency();
        YAxis.YAxisLabelPosition labelPosition = this.yAxis.getLabelPosition();
        float yPos = dependency == YAxis.AxisDependency.LEFT ? (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? this.viewPortHandler.contentTop() - baseYOffset : this.viewPortHandler.contentTop() - baseYOffset) : (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? this.viewPortHandler.contentBottom() + textHeight + baseYOffset : this.viewPortHandler.contentBottom() + textHeight + baseYOffset);
        this.drawYLabels(canvas, yPos, positions, this.yAxis.getYOffset());
    }

    @Override
    public void renderAxisLine(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.yAxis.isEnabled() || !this.yAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.getPaintAxisLine().setColor(this.yAxis.getAxisLineColor());
        this.getPaintAxisLine().setStrokeWidth(this.yAxis.getAxisLineWidth());
        if (this.yAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            canvas.drawLine(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop(), this.viewPortHandler.contentRight(), this.viewPortHandler.contentTop(), this.getPaintAxisLine());
        } else {
            canvas.drawLine(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentBottom(), this.viewPortHandler.contentRight(), this.viewPortHandler.contentBottom(), this.getPaintAxisLine());
        }
    }

    @Override
    protected void drawYLabels(@NotNull Canvas canvas, float fixedPosition, @NotNull float[] positions, float offset) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        this.getPaintAxisLabels().setTypeface(this.yAxis.getTypeface());
        this.getPaintAxisLabels().setTextSize(this.yAxis.getTextSize());
        this.getPaintAxisLabels().setColor(this.yAxis.getTextColor());
        int from = this.yAxis.isDrawBottomYLabelEntryEnabled() ? 0 : 1;
        int to = this.yAxis.isDrawTopYLabelEntryEnabled() ? this.yAxis.entryCount : this.yAxis.entryCount - 1;
        float xOffset = this.yAxis.getLabelXOffset();
        for (int i = from; i < to; ++i) {
            String it;
            String text = this.yAxis.getFormattedLabel(i);
            if (text == null) continue;
            boolean bl = false;
            canvas.drawText(it, positions[i * 2], fixedPosition - offset + xOffset, this.getPaintAxisLabels());
        }
    }

    @Override
    @NotNull
    protected float[] getTransformedPositions() {
        if (this.mGetTransformedPositionsBuffer.length != this.yAxis.entryCount * 2) {
            this.mGetTransformedPositionsBuffer = new float[this.yAxis.entryCount * 2];
        }
        float[] positions = this.mGetTransformedPositionsBuffer;
        for (int i = 0; i < positions.length; i += 2) {
            positions[i] = this.yAxis.getEntries()[i / 2];
        }
        Transformer transformer = this.getTransformer();
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(positions);
        return positions;
    }

    @Override
    @NotNull
    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.viewPortHandler.getContentRect());
        this.mGridClippingRect.inset(-this.axis.getGridLineWidth(), 0.0f);
        return this.mGridClippingRect;
    }

    @Override
    @NotNull
    protected Path linePath(@NotNull Path p, int i, @NotNull float[] positions) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        p.moveTo(positions[i], this.viewPortHandler.contentTop());
        p.lineTo(positions[i], this.viewPortHandler.contentBottom());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawZeroLine(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawZeroLine_u24lambda_u240 = $this$withSave$iv;
            boolean bl = false;
            this.zeroLineClippingRect.set(this.viewPortHandler.getContentRect());
            this.zeroLineClippingRect.inset(-this.yAxis.getZeroLineWidth(), 0.0f);
            canvas.clipRect(this.limitLineClippingRect);
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD pos = transformer.getPixelForValues(0.0f, 0.0f);
            this.zeroLinePaint.setColor(this.yAxis.getZeroLineColor());
            this.zeroLinePaint.setStrokeWidth(this.yAxis.getZeroLineWidth());
            Path zeroLinePath = this.drawZeroLinePathBuffer;
            zeroLinePath.reset();
            zeroLinePath.moveTo((float)pos.getX() - 1.0f, this.viewPortHandler.contentTop());
            zeroLinePath.lineTo((float)pos.getX() - 1.0f, this.viewPortHandler.contentBottom());
            canvas.drawPath(zeroLinePath, this.zeroLinePaint);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    @NotNull
    protected final Path getMRenderLimitLinesPathBuffer() {
        return this.mRenderLimitLinesPathBuffer;
    }

    protected final void setMRenderLimitLinesPathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mRenderLimitLinesPathBuffer = path;
    }

    @Override
    @NotNull
    protected float[] getRenderLimitLinesBuffer() {
        return this.renderLimitLinesBuffer;
    }

    @Override
    protected void setRenderLimitLinesBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.renderLimitLinesBuffer = fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        List<LimitLine> limitLines = this.yAxis.getLimitLines();
        if (limitLines.isEmpty()) {
            return;
        }
        float[] pts = this.getRenderLimitLinesBuffer();
        pts[0] = 0.0f;
        pts[1] = 0.0f;
        pts[2] = 0.0f;
        pts[3] = 0.0f;
        Path limitLinePath = this.mRenderLimitLinesPathBuffer;
        limitLinePath.reset();
        int n = ((Collection)limitLines).size();
        for (int i = 0; i < n; ++i) {
            LimitLine limitLine = limitLines.get(i);
            if (!limitLine.isEnabled()) continue;
            Canvas $this$withSave$iv = canvas;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                LimitLine.LimitLabelPosition position;
                Canvas $this$renderLimitLines_u24lambda_u240 = $this$withSave$iv;
                boolean bl = false;
                this.limitLineClippingRect.set(this.viewPortHandler.getContentRect());
                this.limitLineClippingRect.inset(-limitLine.getLineWidth(), 0.0f);
                canvas.clipRect(this.limitLineClippingRect);
                pts[0] = limitLine.getLimit();
                pts[2] = limitLine.getLimit();
                Transformer transformer = this.getTransformer();
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(pts);
                pts[1] = this.viewPortHandler.contentTop();
                pts[3] = this.viewPortHandler.contentBottom();
                limitLinePath.moveTo(pts[0], pts[1]);
                limitLinePath.lineTo(pts[2], pts[3]);
                this.limitLinePaint.setStyle(Paint.Style.STROKE);
                this.limitLinePaint.setColor(limitLine.getLineColor());
                this.limitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
                this.limitLinePaint.setStrokeWidth(limitLine.getLineWidth());
                canvas.drawPath(limitLinePath, this.limitLinePaint);
                limitLinePath.reset();
                String label = limitLine.getLabel();
                if (label == null || Intrinsics.areEqual((Object)label, (Object)"")) continue;
                this.limitLinePaint.setStyle(limitLine.getTextStyle());
                this.limitLinePaint.setPathEffect(null);
                this.limitLinePaint.setColor(limitLine.getTextColor());
                this.limitLinePaint.setTypeface(limitLine.getTypeface());
                this.limitLinePaint.setStrokeWidth(0.5f);
                this.limitLinePaint.setTextSize(limitLine.getTextSize());
                float xOffset = limitLine.getLineWidth() + limitLine.getXOffset();
                float yOffset = UtilsKtKt.convertDpToPixel(2.0f) + limitLine.getYOffset();
                LimitLine.LimitLabelPosition limitLabelPosition = position = limitLine.getLabelPosition();
                switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[limitLabelPosition.ordinal()]) {
                    case 1: {
                        float labelLineHeight = Utils.INSTANCE.calcTextHeight(this.limitLinePaint, label);
                        this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(label, pts[0] + xOffset, this.viewPortHandler.contentTop() + yOffset + labelLineHeight, this.limitLinePaint);
                        break;
                    }
                    case 2: {
                        this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(label, pts[0] + xOffset, this.viewPortHandler.contentBottom() - yOffset, this.limitLinePaint);
                        break;
                    }
                    case 3: {
                        this.limitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        float labelLineHeight = Utils.INSTANCE.calcTextHeight(this.limitLinePaint, label);
                        canvas.drawText(label, pts[0] - xOffset, this.viewPortHandler.contentTop() + yOffset + labelLineHeight, this.limitLinePaint);
                        break;
                    }
                    default: {
                        this.limitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(label, pts[0] - xOffset, this.viewPortHandler.contentBottom() - yOffset, this.limitLinePaint);
                    }
                }
                continue;
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LimitLine.LimitLabelPosition.values().length];
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.LEFT_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

