/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.RadarHighlighter;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LegendRenderer;
import com.github.mikephil.charting.renderer.RadarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererRadarChart;
import com.github.mikephil.charting.renderer.YAxisRendererRadarChart;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB%\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\b\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020/H\u0014J\b\u00101\u001a\u00020/H\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0014J\u0010\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000eH\u0016J\u000e\u0010N\u001a\u00020/2\u0006\u0010O\u001a\u00020\u001cR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0011\u00105\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b9\u00107R\u0011\u0010:\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R0\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0011\u0010C\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER$\u0010G\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u00107\"\u0004\bI\u0010JR$\u0010K\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bL\u00107\"\u0004\bM\u0010JR$\u0010Q\u001a\u00020\u000b2\u0006\u0010P\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010\u0012\"\u0004\bS\u0010\u0014R\u0014\u0010T\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u00107R\u0014\u0010V\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u00107R\u0014\u0010X\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u00107R\u0014\u0010Z\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u00107R\u0014\u0010\\\u001a\u00020]8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u0014\u0010`\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u00107R\u0011\u0010b\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bc\u00107\u00a8\u0006d"}, d2={"Lcom/github/mikephil/charting/charts/RadarChart;", "Lcom/github/mikephil/charting/charts/PieRadarChartBase;", "Lcom/github/mikephil/charting/data/RadarData;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mWebLineWidth", "", "mInnerWebLineWidth", "webColor", "getWebColor", "()I", "setWebColor", "(I)V", "webColorInner", "getWebColorInner", "setWebColorInner", "webAlpha", "getWebAlpha", "setWebAlpha", "mDrawWeb", "", "mSkipWebLineCount", "mYAxis", "Lcom/github/mikephil/charting/components/YAxis;", "colorList", "", "mYAxisRenderer", "Lcom/github/mikephil/charting/renderer/YAxisRendererRadarChart;", "getMYAxisRenderer", "()Lcom/github/mikephil/charting/renderer/YAxisRendererRadarChart;", "setMYAxisRenderer", "(Lcom/github/mikephil/charting/renderer/YAxisRendererRadarChart;)V", "mXAxisRenderer", "Lcom/github/mikephil/charting/renderer/XAxisRendererRadarChart;", "getMXAxisRenderer", "()Lcom/github/mikephil/charting/renderer/XAxisRendererRadarChart;", "setMXAxisRenderer", "(Lcom/github/mikephil/charting/renderer/XAxisRendererRadarChart;)V", "init", "", "calcMinMax", "notifyDataSetChanged", "onDraw", "canvas", "Landroid/graphics/Canvas;", "factor", "getFactor", "()F", "sliceAngle", "getSliceAngle", "isCustomLayerColorEnable", "()Z", "layerColorList", "getLayerColorList", "()Ljava/util/List;", "setLayerColorList", "(Ljava/util/List;)V", "getIndexForAngle", "angle", "yAxis", "getYAxis", "()Lcom/github/mikephil/charting/components/YAxis;", "width", "webLineWidth", "getWebLineWidth", "setWebLineWidth", "(F)V", "webLineWidthInner", "getWebLineWidthInner", "setWebLineWidthInner", "setDrawWeb", "enabled", "count", "skipWebLineCount", "getSkipWebLineCount", "setSkipWebLineCount", "requiredLegendOffset", "getRequiredLegendOffset", "requiredBaseOffset", "getRequiredBaseOffset", "radius", "getRadius", "yChartMax", "getYChartMax", "accessibilityDescription", "", "getAccessibilityDescription", "()Ljava/lang/String;", "yChartMin", "getYChartMin", "yRange", "getYRange", "MPChartLib_release"})
public final class RadarChart
extends PieRadarChartBase<RadarData> {
    private float mWebLineWidth = 2.5f;
    private float mInnerWebLineWidth = 1.5f;
    private int webColor = Color.rgb((int)122, (int)122, (int)122);
    private int webColorInner = Color.rgb((int)122, (int)122, (int)122);
    private int webAlpha = 150;
    private boolean mDrawWeb = true;
    private int mSkipWebLineCount;
    @Nullable
    private YAxis mYAxis;
    @NotNull
    private List<Integer> colorList = new ArrayList();
    @Nullable
    private YAxisRendererRadarChart mYAxisRenderer;
    @Nullable
    private XAxisRendererRadarChart mXAxisRenderer;

    public final int getWebColor() {
        return this.webColor;
    }

    public final void setWebColor(int n) {
        this.webColor = n;
    }

    public final int getWebColorInner() {
        return this.webColorInner;
    }

    public final void setWebColorInner(int n) {
        this.webColorInner = n;
    }

    public final int getWebAlpha() {
        return this.webAlpha;
    }

    public final void setWebAlpha(int n) {
        this.webAlpha = n;
    }

    @Nullable
    protected final YAxisRendererRadarChart getMYAxisRenderer() {
        return this.mYAxisRenderer;
    }

    protected final void setMYAxisRenderer(@Nullable YAxisRendererRadarChart yAxisRendererRadarChart) {
        this.mYAxisRenderer = yAxisRendererRadarChart;
    }

    @Nullable
    protected final XAxisRendererRadarChart getMXAxisRenderer() {
        return this.mXAxisRenderer;
    }

    protected final void setMXAxisRenderer(@Nullable XAxisRendererRadarChart xAxisRendererRadarChart) {
        this.mXAxisRenderer = xAxisRendererRadarChart;
    }

    public RadarChart(@Nullable Context context) {
        super(context);
    }

    public RadarChart(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RadarChart(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        YAxis yAxis = this.mYAxis = new YAxis(YAxis.AxisDependency.LEFT);
        Intrinsics.checkNotNull((Object)yAxis);
        yAxis.setLabelXOffset(10.0f);
        this.mWebLineWidth = UtilsKtKt.convertDpToPixel(1.5f);
        this.mInnerWebLineWidth = UtilsKtKt.convertDpToPixel(0.75f);
        this.mRenderer = new RadarChartRenderer(this, this.getMAnimator(), this.getViewPortHandler());
        ViewPortHandler viewPortHandler = this.getViewPortHandler();
        YAxis yAxis2 = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis2);
        this.mYAxisRenderer = new YAxisRendererRadarChart(viewPortHandler, yAxis2, this);
        this.mXAxisRenderer = new XAxisRendererRadarChart(this.getViewPortHandler(), this.mXAxis, this);
        this.setHighlighter(new RadarHighlighter(this));
    }

    @Override
    protected void calcMinMax() {
        block0: {
            super.calcMinMax();
            RadarData radarData = (RadarData)this.mData;
            if (radarData == null) break block0;
            RadarData data = radarData;
            boolean bl = false;
            YAxis yAxis = this.mYAxis;
            Intrinsics.checkNotNull((Object)yAxis);
            yAxis.calculate(data.getYMin(YAxis.AxisDependency.LEFT), data.getYMax(YAxis.AxisDependency.LEFT));
            Object t = data.getMaxEntryCountSet();
            Intrinsics.checkNotNull(t);
            this.mXAxis.calculate(0.0f, ((IRadarDataSet)t).getEntryCount());
        }
    }

    @Override
    public void notifyDataSetChanged() {
        block3: {
            RadarData radarData = (RadarData)this.mData;
            if (radarData == null) break block3;
            RadarData data = radarData;
            boolean bl = false;
            this.calcMinMax();
            YAxisRendererRadarChart yAxisRendererRadarChart = this.mYAxisRenderer;
            Intrinsics.checkNotNull((Object)yAxisRendererRadarChart);
            YAxis yAxis = this.mYAxis;
            Intrinsics.checkNotNull((Object)yAxis);
            float f = yAxis.mAxisMinimum;
            YAxis yAxis2 = this.mYAxis;
            Intrinsics.checkNotNull((Object)yAxis2);
            float f2 = yAxis2.mAxisMaximum;
            YAxis yAxis3 = this.mYAxis;
            Intrinsics.checkNotNull((Object)yAxis3);
            yAxisRendererRadarChart.computeAxis(f, f2, yAxis3.isInverted());
            XAxisRendererRadarChart xAxisRendererRadarChart = this.mXAxisRenderer;
            Intrinsics.checkNotNull((Object)xAxisRendererRadarChart);
            xAxisRendererRadarChart.computeAxis(this.mXAxis.mAxisMinimum, this.mXAxis.mAxisMaximum, false);
            if (this.getLegend() != null) {
                Legend legend = this.getLegend();
                Intrinsics.checkNotNull((Object)legend);
                if (!legend.isLegendCustom()) {
                    LegendRenderer legendRenderer = this.getLegendRenderer();
                    if (legendRenderer != null) {
                        legendRenderer.computeLegend(data);
                    }
                }
            }
            this.calculateOffsets();
        }
    }

    @Override
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.mData == null) {
            return;
        }
        if (this.mXAxis.isEnabled()) {
            XAxisRendererRadarChart xAxisRendererRadarChart = this.mXAxisRenderer;
            Intrinsics.checkNotNull((Object)xAxisRendererRadarChart);
            xAxisRendererRadarChart.computeAxis(this.mXAxis.mAxisMinimum, this.mXAxis.mAxisMaximum, false);
        }
        XAxisRendererRadarChart xAxisRendererRadarChart = this.mXAxisRenderer;
        Intrinsics.checkNotNull((Object)xAxisRendererRadarChart);
        xAxisRendererRadarChart.renderAxisLabels(canvas);
        if (this.mDrawWeb) {
            DataRenderer dataRenderer = this.mRenderer;
            if (dataRenderer != null) {
                dataRenderer.drawExtras(canvas);
            }
        }
        YAxis yAxis = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis);
        if (yAxis.isEnabled()) {
            YAxis yAxis2 = this.mYAxis;
            Intrinsics.checkNotNull((Object)yAxis2);
            if (yAxis2.isDrawLimitLinesBehindDataEnabled()) {
                YAxisRendererRadarChart yAxisRendererRadarChart = this.mYAxisRenderer;
                Intrinsics.checkNotNull((Object)yAxisRendererRadarChart);
                yAxisRendererRadarChart.renderLimitLines(canvas);
            }
        }
        DataRenderer dataRenderer = this.mRenderer;
        if (dataRenderer != null) {
            dataRenderer.drawData(canvas);
        }
        if (this.valuesToHighlight()) {
            DataRenderer dataRenderer2 = this.mRenderer;
            if (dataRenderer2 != null) {
                Highlight[] highlightArray = this.getHighlighted();
                Intrinsics.checkNotNull((Object)highlightArray);
                dataRenderer2.drawHighlighted(canvas, highlightArray);
            }
        }
        YAxis yAxis3 = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis3);
        if (yAxis3.isEnabled()) {
            YAxis yAxis4 = this.mYAxis;
            Intrinsics.checkNotNull((Object)yAxis4);
            if (!yAxis4.isDrawLimitLinesBehindDataEnabled()) {
                YAxisRendererRadarChart yAxisRendererRadarChart = this.mYAxisRenderer;
                Intrinsics.checkNotNull((Object)yAxisRendererRadarChart);
                yAxisRendererRadarChart.renderLimitLines(canvas);
            }
        }
        YAxisRendererRadarChart yAxisRendererRadarChart = this.mYAxisRenderer;
        Intrinsics.checkNotNull((Object)yAxisRendererRadarChart);
        yAxisRendererRadarChart.renderAxisLabels(canvas);
        DataRenderer dataRenderer3 = this.mRenderer;
        if (dataRenderer3 != null) {
            dataRenderer3.drawValues(canvas);
        }
        LegendRenderer legendRenderer = this.getLegendRenderer();
        if (legendRenderer != null) {
            legendRenderer.renderLegend(canvas);
        }
        this.drawDescription(canvas);
        this.drawMarkers(canvas);
    }

    public final float getFactor() {
        RectF content = this.getViewPortHandler().getContentRect();
        float f = Math.min(content.width() / 2.0f, content.height() / 2.0f);
        YAxis yAxis = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis);
        return f / yAxis.mAxisRange;
    }

    public final float getSliceAngle() {
        RadarData radarData = (RadarData)this.mData;
        IRadarDataSet iRadarDataSet = radarData != null ? (IRadarDataSet)radarData.getMaxEntryCountSet() : null;
        Intrinsics.checkNotNull((Object)iRadarDataSet);
        return 360.0f / (float)iRadarDataSet.getEntryCount();
    }

    public final boolean isCustomLayerColorEnable() {
        if (this.mData == null) {
            return false;
        }
        return this.colorList.size() == this.getYAxis().entryCount;
    }

    @NotNull
    public final List<Integer> getLayerColorList() {
        return this.colorList;
    }

    public final void setLayerColorList(@NotNull List<Integer> colorList) {
        Intrinsics.checkNotNullParameter(colorList, (String)"colorList");
        if (colorList.isEmpty()) {
            return;
        }
        this.colorList = colorList;
    }

    @Override
    public int getIndexForAngle(float angle) {
        float a = Utils.INSTANCE.getNormalizedAngle(angle - this.getRotationAngle());
        float sliceangle = this.getSliceAngle();
        RadarData radarData = (RadarData)this.mData;
        IRadarDataSet iRadarDataSet = radarData != null ? (IRadarDataSet)radarData.getMaxEntryCountSet() : null;
        Intrinsics.checkNotNull((Object)iRadarDataSet);
        int max = iRadarDataSet.getEntryCount();
        int index = 0;
        for (int i = 0; i < max; ++i) {
            float referenceAngle = sliceangle * (float)(i + 1) - sliceangle / 2.0f;
            if (!(referenceAngle > a)) continue;
            index = i;
            break;
        }
        return index;
    }

    @NotNull
    public final YAxis getYAxis() {
        YAxis yAxis = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis);
        return yAxis;
    }

    public final float getWebLineWidth() {
        return this.mWebLineWidth;
    }

    public final void setWebLineWidth(float width) {
        this.mWebLineWidth = UtilsKtKt.convertDpToPixel(width);
    }

    public final float getWebLineWidthInner() {
        return this.mInnerWebLineWidth;
    }

    public final void setWebLineWidthInner(float width) {
        this.mInnerWebLineWidth = UtilsKtKt.convertDpToPixel(width);
    }

    public final void setDrawWeb(boolean enabled) {
        this.mDrawWeb = enabled;
    }

    public final int getSkipWebLineCount() {
        return this.mSkipWebLineCount;
    }

    public final void setSkipWebLineCount(int count) {
        this.mSkipWebLineCount = Math.max(0, count);
    }

    @Override
    protected float getRequiredLegendOffset() {
        LegendRenderer legendRenderer = this.getLegendRenderer();
        if (legendRenderer != null) {
            LegendRenderer it = legendRenderer;
            boolean bl = false;
            return it.getLabelPaint().getTextSize() * 4.0f;
        }
        return 0.0f;
    }

    @Override
    protected float getRequiredBaseOffset() {
        return this.mXAxis.isEnabled() && this.mXAxis.isDrawLabelsEnabled() ? (float)this.mXAxis.mLabelWidth : UtilsKtKt.convertDpToPixel(10.0f);
    }

    @Override
    public float getRadius() {
        RectF content = this.getViewPortHandler().getContentRect();
        return Math.min(content.width() / 2.0f, content.height() / 2.0f);
    }

    @Override
    public float getYChartMax() {
        YAxis yAxis = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis);
        return yAxis.mAxisMaximum;
    }

    @Override
    @NotNull
    public String getAccessibilityDescription() {
        return "This is a Radar chart";
    }

    @Override
    public float getYChartMin() {
        YAxis yAxis = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis);
        return yAxis.mAxisMinimum;
    }

    public final float getYRange() {
        YAxis yAxis = this.mYAxis;
        Intrinsics.checkNotNull((Object)yAxis);
        return yAxis.mAxisRange;
    }
}

