/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0004J \u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0013\u001a\u00020\u000bH\u0014J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J>\u0010\u001c\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\u000eH\u0004J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010:\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010;\u001a\u00020#H\u0014J\u001e\u0010<\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020)J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010A\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020)2\u0006\u0010B\u001a\u00020\u000eR\u0012\u0010\u0004\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0012\u0010/\u001a\u0002008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\u0004\u0018\u0001008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u00020)8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u0002008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010+\"\u0004\b8\u0010-R\u000e\u00109\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/github/mikephil/charting/renderer/XAxisRenderer;", "Lcom/github/mikephil/charting/renderer/AxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "xAxis", "Lcom/github/mikephil/charting/components/XAxis;", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/XAxis;Lcom/github/mikephil/charting/utils/Transformer;)V", "setupGridPaint", "", "computeAxis", "min", "", "max", "inverted", "", "computeAxisValues", "computeSize", "renderAxisLabels", "c", "Landroid/graphics/Canvas;", "renderAxisLine", "drawLabels", "pos", "anchor", "Lcom/github/mikephil/charting/utils/MPPointF;", "drawLabel", "formattedLabel", "", "x", "y", "angleDegrees", "mRenderGridLinesPath", "Landroid/graphics/Path;", "getMRenderGridLinesPath", "()Landroid/graphics/Path;", "setMRenderGridLinesPath", "(Landroid/graphics/Path;)V", "mRenderGridLinesBuffer", "", "getMRenderGridLinesBuffer", "()[F", "setMRenderGridLinesBuffer", "([F)V", "renderGridLines", "mGridClippingRect", "Landroid/graphics/RectF;", "gridClippingRect", "getGridClippingRect", "()Landroid/graphics/RectF;", "mRenderLimitLinesBuffer", "mLimitLineClippingRect", "limitLineSegmentsBuffer", "getLimitLineSegmentsBuffer", "setLimitLineSegmentsBuffer", "mLimitLinePath", "drawGridLine", "gridLinePath", "renderLimitLineLine", "limitLine", "Lcom/github/mikephil/charting/components/LimitLine;", "position", "renderLimitLines", "renderLimitLineLabel", "yOffset", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nXAxisRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XAxisRenderer.kt\ncom/github/mikephil/charting/renderer/XAxisRenderer\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,415:1\n135#2,8:416\n27#2,7:424\n*S KotlinDebug\n*F\n+ 1 XAxisRenderer.kt\ncom/github/mikephil/charting/renderer/XAxisRenderer\n*L\n231#1:416,8\n353#1:424,7\n*E\n"})
public class XAxisRenderer
extends AxisRenderer {
    @JvmField
    @NotNull
    protected XAxis xAxis;
    @NotNull
    private Path mRenderGridLinesPath;
    @NotNull
    private float[] mRenderGridLinesBuffer;
    @JvmField
    @NotNull
    protected RectF mGridClippingRect;
    @JvmField
    @NotNull
    protected float[] mRenderLimitLinesBuffer;
    @JvmField
    @NotNull
    protected RectF mLimitLineClippingRect;
    @NotNull
    private float[] limitLineSegmentsBuffer;
    @NotNull
    private final Path mLimitLinePath;

    public XAxisRenderer(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @Nullable Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        super(viewPortHandler, trans, xAxis);
        this.xAxis = xAxis;
        this.mRenderGridLinesPath = new Path();
        this.mRenderGridLinesBuffer = new float[2];
        this.mGridClippingRect = new RectF();
        this.mRenderLimitLinesBuffer = new float[2];
        this.mLimitLineClippingRect = new RectF();
        this.limitLineSegmentsBuffer = new float[4];
        this.mLimitLinePath = new Path();
        this.getPaintAxisLabels().setColor(-16777216);
        this.getPaintAxisLabels().setTextAlign(Paint.Align.CENTER);
        this.getPaintAxisLabels().setTextSize(Utils.convertDpToPixel(10.0f));
    }

    protected final void setupGridPaint() {
        this.getPaintGrid().setColor(this.xAxis.getGridColor());
        this.getPaintGrid().setStrokeWidth(this.xAxis.getGridLineWidth());
        this.getPaintGrid().setPathEffect((PathEffect)this.xAxis.getGridDashPathEffect());
    }

    @Override
    public void computeAxis(float min, float max, boolean inverted) {
        float minLocal = min;
        float maxLocal = max;
        if (this.viewPortHandler.contentWidth() > 10.0f && !this.viewPortHandler.isFullyZoomedOutX()) {
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD p1 = transformer.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop());
            Transformer transformer2 = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer2);
            MPPointD p2 = transformer2.getValuesByTouchPoint(this.viewPortHandler.contentRight(), this.viewPortHandler.contentTop());
            if (inverted) {
                minLocal = (float)p2.x;
                maxLocal = (float)p1.x;
            } else {
                minLocal = (float)p1.x;
                maxLocal = (float)p2.x;
            }
            MPPointD.recycleInstance(p1);
            MPPointD.recycleInstance(p2);
        }
        this.computeAxisValues(minLocal, maxLocal);
    }

    @Override
    protected void computeAxisValues(float min, float max) {
        super.computeAxisValues(min, max);
        this.computeSize();
    }

    protected void computeSize() {
        String longest = this.xAxis.getLongestLabel();
        this.getPaintAxisLabels().setTypeface(this.xAxis.getTypeface());
        this.getPaintAxisLabels().setTextSize(this.xAxis.getTextSize());
        FSize labelSize = Utils.calcTextSize(this.getPaintAxisLabels(), longest);
        float labelWidth = labelSize.width;
        float labelHeight = Utils.calcTextHeight(this.getPaintAxisLabels(), "Q");
        FSize labelRotatedSize = Utils.getSizeOfRotatedRectangleByDegrees(labelWidth, labelHeight, this.xAxis.getLabelRotationAngle());
        this.xAxis.mLabelWidth = Math.round(labelRotatedSize.width);
        this.xAxis.mLabelHeight = Math.round(labelRotatedSize.height);
        FSize.recycleInstance(labelRotatedSize);
        FSize.recycleInstance(labelSize);
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.xAxis.isEnabled() || !this.xAxis.isDrawLabelsEnabled()) {
            return;
        }
        float yoffset = this.xAxis.getYOffset();
        this.getPaintAxisLabels().setColor(this.xAxis.getTextColor());
        MPPointF pointF = MPPointF.getInstance(0.0f, 0.0f);
        XAxis.XAxisPosition xAxisPosition = this.xAxis.getPosition();
        switch (xAxisPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[xAxisPosition.ordinal()]) {
            case 1: {
                pointF.x = 0.5f;
                pointF.y = 1.0f;
                this.drawLabels(c, this.viewPortHandler.contentTop() - yoffset, pointF);
                break;
            }
            case 2: {
                pointF.x = 0.5f;
                pointF.y = 1.0f;
                this.drawLabels(c, this.viewPortHandler.contentTop() + yoffset + (float)this.xAxis.mLabelHeight, pointF);
                break;
            }
            case 3: {
                pointF.x = 0.5f;
                pointF.y = 0.0f;
                this.drawLabels(c, this.viewPortHandler.contentBottom() + yoffset, pointF);
                break;
            }
            case 4: {
                pointF.x = 0.5f;
                pointF.y = 0.0f;
                this.drawLabels(c, this.viewPortHandler.contentBottom() - yoffset - (float)this.xAxis.mLabelHeight, pointF);
                break;
            }
            default: {
                pointF.x = 0.5f;
                pointF.y = 1.0f;
                this.drawLabels(c, this.viewPortHandler.contentTop() - yoffset, pointF);
                pointF.x = 0.5f;
                pointF.y = 0.0f;
                this.drawLabels(c, this.viewPortHandler.contentBottom() + yoffset, pointF);
            }
        }
        MPPointF.recycleInstance(pointF);
    }

    @Override
    public void renderAxisLine(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.xAxis.isDrawAxisLineEnabled() || !this.xAxis.isEnabled()) {
            return;
        }
        this.getPaintAxisLine().setColor(this.xAxis.getAxisLineColor());
        this.getPaintAxisLine().setStrokeWidth(this.xAxis.getAxisLineWidth());
        this.getPaintAxisLine().setPathEffect((PathEffect)this.xAxis.getAxisLineDashPathEffect());
        if (this.xAxis.getPosition() == XAxis.XAxisPosition.TOP || this.xAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop(), this.viewPortHandler.contentRight(), this.viewPortHandler.contentTop(), this.getPaintAxisLine());
        }
        if (this.xAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentBottom(), this.viewPortHandler.contentRight(), this.viewPortHandler.contentBottom(), this.getPaintAxisLine());
        }
    }

    protected void drawLabels(@Nullable Canvas c, float pos, @Nullable MPPointF anchor) {
        int i;
        float labelRotationAngleDegrees = this.xAxis.getLabelRotationAngle();
        boolean centeringEnabled = this.xAxis.isCenterAxisLabelsEnabled();
        float[] positions = null;
        if (this.xAxis.isShowSpecificPositions()) {
            positions = new float[this.xAxis.getSpecificPositions().length * 2];
            for (i = 0; i < positions.length; i += 2) {
                positions[i] = this.xAxis.getSpecificPositions()[i / 2];
            }
        } else {
            positions = new float[this.xAxis.mEntryCount * 2];
            for (i = 0; i < positions.length; i += 2) {
                positions[i] = centeringEnabled ? this.xAxis.mCenteredEntries[i / 2] : this.xAxis.mEntries[i / 2];
            }
        }
        Transformer transformer = this.getTransformer();
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(positions);
        for (i = 0; i < positions.length; i += 2) {
            String label;
            float x = positions[i];
            if (!this.viewPortHandler.isInBoundsX(x)) continue;
            String string = label = this.xAxis.isShowSpecificPositions() ? this.xAxis.getValueFormatter().getFormattedValue(this.xAxis.getSpecificPositions()[i / 2], this.xAxis) : this.xAxis.getValueFormatter().getFormattedValue(this.xAxis.mEntries[i / 2], this.xAxis);
            if (this.xAxis.isAvoidFirstLastClippingEnabled()) {
                if (i / 2 == this.xAxis.mEntryCount - 1 && this.xAxis.mEntryCount > 1) {
                    width = Utils.calcTextWidth(this.getPaintAxisLabels(), label);
                    if (width > this.viewPortHandler.offsetRight() * (float)2 && x + width > this.viewPortHandler.getChartWidth()) {
                        x -= width / (float)2;
                    }
                } else if (i == 0) {
                    width = Utils.calcTextWidth(this.getPaintAxisLabels(), label);
                    x += width / (float)2;
                }
            }
            this.drawLabel(c, label, x, pos, anchor, labelRotationAngleDegrees);
        }
    }

    protected final void drawLabel(@Nullable Canvas c, @Nullable String formattedLabel, float x, float y, @Nullable MPPointF anchor, float angleDegrees) {
        Utils.drawXAxisValue(c, formattedLabel, x, y, this.getPaintAxisLabels(), anchor, angleDegrees);
    }

    @NotNull
    protected Path getMRenderGridLinesPath() {
        return this.mRenderGridLinesPath;
    }

    protected void setMRenderGridLinesPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mRenderGridLinesPath = path;
    }

    @NotNull
    protected float[] getMRenderGridLinesBuffer() {
        return this.mRenderGridLinesBuffer;
    }

    protected void setMRenderGridLinesBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mRenderGridLinesBuffer = fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void renderGridLines(@NotNull Canvas c) {
        void $this$withClip$iv;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.xAxis.isDrawGridLinesEnabled() || !this.xAxis.isEnabled()) {
            return;
        }
        Canvas canvas = c;
        RectF rectF = this.getGridClippingRect();
        Intrinsics.checkNotNull((Object)rectF);
        RectF clipRect$iv = rectF;
        boolean $i$f$withClip = false;
        int checkpoint$iv = $this$withClip$iv.save();
        $this$withClip$iv.clipRect(clipRect$iv);
        try {
            void $this$renderGridLines_u24lambda_u241 = $this$withClip$iv;
            boolean bl = false;
            if (this.axis.isShowSpecificPositions()) {
                if (this.getMRenderGridLinesBuffer().length != this.axis.getSpecificPositions().length * 2) {
                    this.setMRenderGridLinesBuffer(new float[this.xAxis.getSpecificPositions().length * 2]);
                }
            } else if (this.getMRenderGridLinesBuffer().length != this.axis.mEntryCount * 2) {
                this.setMRenderGridLinesBuffer(new float[this.xAxis.mEntryCount * 2]);
            }
            float[] positions = this.getMRenderGridLinesBuffer();
            void $this$renderGridLines_u24lambda_u241_u24lambda_u240 = $this$renderGridLines_u24lambda_u241;
            boolean bl2 = false;
            for (int i = 0; i < positions.length; i += 2) {
                if (this.axis.isShowSpecificPositions()) {
                    positions[i] = this.xAxis.getSpecificPositions()[i / 2];
                    positions[i + 1] = this.xAxis.getSpecificPositions()[i / 2];
                    continue;
                }
                positions[i] = this.xAxis.mEntries[i / 2];
                positions[i + 1] = this.xAxis.mEntries[i / 2];
            }
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(positions);
            this.setupGridPaint();
            Path gridLinePath = this.getMRenderGridLinesPath();
            gridLinePath.reset();
            for (int i = 0; i < positions.length; i += 2) {
                this.drawGridLine(c, positions[i], positions[i + 1], gridLinePath);
            }
        }
        finally {
            $this$withClip$iv.restoreToCount(checkpoint$iv);
        }
    }

    @Nullable
    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.viewPortHandler.getContentRect());
        this.mGridClippingRect.inset(-this.axis.getGridLineWidth(), 0.0f);
        return this.mGridClippingRect;
    }

    @NotNull
    public final float[] getLimitLineSegmentsBuffer() {
        return this.limitLineSegmentsBuffer;
    }

    public final void setLimitLineSegmentsBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.limitLineSegmentsBuffer = fArray;
    }

    protected void drawGridLine(@NotNull Canvas c, float x, float y, @NotNull Path gridLinePath) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)gridLinePath, (String)"gridLinePath");
        gridLinePath.moveTo(x, this.viewPortHandler.contentBottom());
        gridLinePath.lineTo(x, this.viewPortHandler.contentTop());
        c.drawPath(gridLinePath, this.getPaintGrid());
        gridLinePath.reset();
    }

    public final void renderLimitLineLine(@NotNull Canvas c, @NotNull LimitLine limitLine, @NotNull float[] position) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)limitLine, (String)"limitLine");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.limitLineSegmentsBuffer[0] = position[0];
        this.limitLineSegmentsBuffer[1] = this.viewPortHandler.contentTop();
        this.limitLineSegmentsBuffer[2] = position[0];
        this.limitLineSegmentsBuffer[3] = this.viewPortHandler.contentBottom();
        this.mLimitLinePath.reset();
        this.mLimitLinePath.moveTo(this.limitLineSegmentsBuffer[0], this.limitLineSegmentsBuffer[1]);
        this.mLimitLinePath.lineTo(this.limitLineSegmentsBuffer[2], this.limitLineSegmentsBuffer[3]);
        this.limitLinePaint.setStyle(Paint.Style.STROKE);
        this.limitLinePaint.setColor(limitLine.getLineColor());
        this.limitLinePaint.setStrokeWidth(limitLine.getLineWidth());
        this.limitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
        c.drawPath(this.mLimitLinePath, this.limitLinePaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLimitLines(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        List<LimitLine> limitLines = this.xAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] position = this.mRenderLimitLinesBuffer;
        position[0] = 0.0f;
        position[1] = 0.0f;
        int n = ((Collection)limitLines).size();
        for (int i = 0; i < n; ++i) {
            LimitLine l = limitLines.get(i);
            if (!l.isEnabled()) continue;
            Canvas $this$withSave$iv = c;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$renderLimitLines_u24lambda_u242 = $this$withSave$iv;
                boolean bl = false;
                this.mLimitLineClippingRect.set(this.viewPortHandler.getContentRect());
                this.mLimitLineClippingRect.inset(-l.getLineWidth(), 0.0f);
                c.clipRect(this.mLimitLineClippingRect);
                position[0] = l.getLimit();
                position[1] = 0.0f;
                Transformer transformer = this.getTransformer();
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(position);
                Intrinsics.checkNotNull((Object)l);
                this.renderLimitLineLine(c, l, position);
                this.renderLimitLineLabel(c, l, position, 2.0f + l.getYOffset());
                continue;
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    public final void renderLimitLineLabel(@NotNull Canvas c, @NotNull LimitLine limitLine, @NotNull float[] position, float yOffset) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)limitLine, (String)"limitLine");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        String label = limitLine.getLabel();
        if (label != null && !Intrinsics.areEqual((Object)label, (Object)"")) {
            LimitLine.LimitLabelPosition labelPosition;
            this.limitLinePaint.setStyle(limitLine.getTextStyle());
            this.limitLinePaint.setPathEffect(null);
            this.limitLinePaint.setColor(limitLine.getTextColor());
            this.limitLinePaint.setStrokeWidth(0.5f);
            this.limitLinePaint.setTextSize(limitLine.getTextSize());
            float xOffset = limitLine.getLineWidth() + limitLine.getXOffset();
            LimitLine.LimitLabelPosition limitLabelPosition = labelPosition = limitLine.getLabelPosition();
            switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$1[limitLabelPosition.ordinal()]) {
                case 1: {
                    float labelLineHeight = Utils.calcTextHeight(this.limitLinePaint, label);
                    this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
                    c.drawText(label, position[0] + xOffset, this.viewPortHandler.contentTop() + yOffset + labelLineHeight, this.limitLinePaint);
                    break;
                }
                case 2: {
                    this.limitLinePaint.setTextAlign(Paint.Align.LEFT);
                    c.drawText(label, position[0] + xOffset, this.viewPortHandler.contentBottom() - yOffset, this.limitLinePaint);
                    break;
                }
                case 3: {
                    this.limitLinePaint.setTextAlign(Paint.Align.RIGHT);
                    float labelLineHeight = Utils.calcTextHeight(this.limitLinePaint, label);
                    c.drawText(label, position[0] - xOffset, this.viewPortHandler.contentTop() + yOffset + labelLineHeight, this.limitLinePaint);
                    break;
                }
                default: {
                    this.limitLinePaint.setTextAlign(Paint.Align.RIGHT);
                    c.drawText(label, position[0] - xOffset, this.viewPortHandler.contentBottom() - yOffset, this.limitLinePaint);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[XAxis.XAxisPosition.values().length];
            try {
                nArray[XAxis.XAxisPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.TOP_INSIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LimitLine.LimitLabelPosition.values().length];
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.LEFT_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

