/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001[B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u001aH\u0016J\u0018\u00102\u001a\u00020/2\u0006\u00101\u001a\u00020\u001a2\u0006\u00103\u001a\u000204H\u0004J\u0010\u00105\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0004J\u0010\u00106\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0004J4\u00107\u001a\u00020/2\u0006\u00101\u001a\u00020\u001a2\u0006\u00103\u001a\u0002042\u0006\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:2\n\u0010;\u001a\u00060<R\u00020=H\u0004J\u0018\u0010>\u001a\u00020/2\u0006\u00101\u001a\u00020\u001a2\u0006\u00103\u001a\u000204H\u0004J,\u0010B\u001a\u00020/2\u0006\u00101\u001a\u00020\u001a2\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020:2\n\u0010;\u001a\u00060<R\u00020=H\u0004J(\u0010C\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020&H\u0002J\u0010\u0010H\u001a\u00020/2\u0006\u00101\u001a\u00020\u001aH\u0016J\u0010\u0010I\u001a\u00020/2\u0006\u00101\u001a\u00020\u001aH\u0016J\u0010\u0010P\u001a\u00020/2\u0006\u00101\u001a\u00020\u001aH\u0004J#\u0010Q\u001a\u00020/2\u0006\u00101\u001a\u00020\u001a2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0016\u00a2\u0006\u0002\u0010UJ\u0006\u0010Z\u001a\u00020/R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001a\u0010?\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010(\"\u0004\bA\u0010*R:\u0010J\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030L\u0012\b\u0012\u00060MR\u00020\u00000Kj\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030L\u0012\b\u0012\u00060MR\u00020\u0000`NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010W\u001a\u00020 2\u0006\u0010V\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010\"\"\u0004\bY\u0010$\u00a8\u0006\\"}, d2={"Lcom/github/mikephil/charting/renderer/LineChartRenderer;", "Lcom/github/mikephil/charting/renderer/LineRadarRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/LineDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/LineDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "circlePaintInner", "Landroid/graphics/Paint;", "getCirclePaintInner", "()Landroid/graphics/Paint;", "setCirclePaintInner", "(Landroid/graphics/Paint;)V", "lineBuffer", "", "drawBitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "getDrawBitmap", "()Ljava/lang/ref/WeakReference;", "setDrawBitmap", "(Ljava/lang/ref/WeakReference;)V", "bitmapCanvas", "Landroid/graphics/Canvas;", "getBitmapCanvas", "()Landroid/graphics/Canvas;", "setBitmapCanvas", "(Landroid/graphics/Canvas;)V", "mBitmapConfig", "Landroid/graphics/Bitmap$Config;", "getMBitmapConfig", "()Landroid/graphics/Bitmap$Config;", "setMBitmapConfig", "(Landroid/graphics/Bitmap$Config;)V", "cubicPath", "Landroid/graphics/Path;", "getCubicPath", "()Landroid/graphics/Path;", "setCubicPath", "(Landroid/graphics/Path;)V", "cubicFillPath", "getCubicFillPath", "setCubicFillPath", "initBuffers", "", "drawData", "c", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/ILineDataSet;", "drawHorizontalBezier", "drawCubicBezier", "drawCubicFill", "spline", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "bounds", "Lcom/github/mikephil/charting/renderer/BarLineScatterCandleBubbleRenderer$XBounds;", "Lcom/github/mikephil/charting/renderer/BarLineScatterCandleBubbleRenderer;", "drawLinear", "mGenerateFilledPathBuffer", "getMGenerateFilledPathBuffer", "setMGenerateFilledPathBuffer", "drawLinearFill", "generateFilledPath", "startIndex", "", "endIndex", "outputPath", "drawValues", "drawExtras", "mImageCaches", "Ljava/util/HashMap;", "Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "Lcom/github/mikephil/charting/renderer/LineChartRenderer$DataSetImageCache;", "Lkotlin/collections/HashMap;", "mCirclesBuffer", "drawCircles", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "config", "bitmapConfig", "getBitmapConfig", "setBitmapConfig", "releaseBitmap", "DataSetImageCache", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nLineChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChartRenderer.kt\ncom/github/mikephil/charting/renderer/LineChartRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,808:1\n1#2:809\n*E\n"})
public final class LineChartRenderer
extends LineRadarRenderer {
    @JvmField
    @NotNull
    public LineDataProvider chart;
    @NotNull
    private Paint circlePaintInner;
    @NotNull
    private float[] lineBuffer;
    @Nullable
    private WeakReference<Bitmap> drawBitmap;
    @Nullable
    private Canvas bitmapCanvas;
    @NotNull
    private Bitmap.Config mBitmapConfig;
    @NotNull
    private Path cubicPath;
    @NotNull
    private Path cubicFillPath;
    @NotNull
    private Path mGenerateFilledPathBuffer;
    @NotNull
    private final HashMap<IDataSet<?>, DataSetImageCache> mImageCaches;
    @NotNull
    private final float[] mCirclesBuffer;

    public LineChartRenderer(@NotNull LineDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.circlePaintInner = new Paint(1);
        this.lineBuffer = new float[4];
        this.mBitmapConfig = Bitmap.Config.ARGB_8888;
        this.cubicPath = new Path();
        this.cubicFillPath = new Path();
        this.mGenerateFilledPathBuffer = new Path();
        this.mImageCaches = new HashMap();
        this.mCirclesBuffer = new float[2];
        this.circlePaintInner.setStyle(Paint.Style.FILL);
        this.circlePaintInner.setColor(-1);
    }

    @NotNull
    protected final Paint getCirclePaintInner() {
        return this.circlePaintInner;
    }

    protected final void setCirclePaintInner(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.circlePaintInner = paint;
    }

    @Nullable
    protected final WeakReference<Bitmap> getDrawBitmap() {
        return this.drawBitmap;
    }

    protected final void setDrawBitmap(@Nullable WeakReference<Bitmap> weakReference) {
        this.drawBitmap = weakReference;
    }

    @Nullable
    protected final Canvas getBitmapCanvas() {
        return this.bitmapCanvas;
    }

    protected final void setBitmapCanvas(@Nullable Canvas canvas) {
        this.bitmapCanvas = canvas;
    }

    @NotNull
    protected final Bitmap.Config getMBitmapConfig() {
        return this.mBitmapConfig;
    }

    protected final void setMBitmapConfig(@NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        this.mBitmapConfig = config;
    }

    @NotNull
    protected final Path getCubicPath() {
        return this.cubicPath;
    }

    protected final void setCubicPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.cubicPath = path;
    }

    @NotNull
    protected final Path getCubicFillPath() {
        return this.cubicFillPath;
    }

    protected final void setCubicFillPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.cubicFillPath = path;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        Bitmap drawBitmapLocal;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int width = (int)this.viewPortHandler.getChartWidth();
        int height = (int)this.viewPortHandler.getChartHeight();
        if (this.drawBitmap == null) {
            v0 = null;
        } else {
            WeakReference<Bitmap> weakReference = this.drawBitmap;
            Intrinsics.checkNotNull(weakReference);
            v0 = drawBitmapLocal = (Bitmap)weakReference.get();
        }
        if (drawBitmapLocal == null || drawBitmapLocal.getWidth() != width || drawBitmapLocal.getHeight() != height) {
            if (width > 0 && height > 0) {
                drawBitmapLocal = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig);
                this.drawBitmap = new WeakReference<Bitmap>(drawBitmapLocal);
                this.bitmapCanvas = new Canvas(drawBitmapLocal);
            } else {
                return;
            }
        }
        drawBitmapLocal.eraseColor(0);
        LineData lineData = this.chart.getLineData();
        for (ILineDataSet set : lineData.getDataSets()) {
            if (!set.isVisible()) continue;
            Intrinsics.checkNotNull((Object)set);
            this.drawDataSet(c, set);
        }
        c.drawBitmap(drawBitmapLocal, 0.0f, 0.0f, null);
    }

    protected final void drawDataSet(@NotNull Canvas c, @NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        this.getPaintRender().setStrokeWidth(dataSet.getLineWidth());
        this.getPaintRender().setPathEffect((PathEffect)dataSet.getDashPathEffect());
        LineDataSet.Mode mode = dataSet.getMode();
        switch (mode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: 
            case 2: {
                this.drawLinear(c, dataSet);
                break;
            }
            case 3: {
                this.drawCubicBezier(dataSet);
                break;
            }
            case 4: {
                this.drawHorizontalBezier(dataSet);
                break;
            }
            default: {
                this.drawLinear(c, dataSet);
            }
        }
        this.getPaintRender().setPathEffect(null);
    }

    protected final void drawHorizontalBezier(@NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float phaseY = this.animator.getPhaseY();
        Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
        this.xBounds.set(this.chart, dataSet);
        this.cubicPath.reset();
        if (this.xBounds.range >= 1) {
            Object prev;
            Object cur = prev = dataSet.getEntryForIndex(this.xBounds.min);
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            int j = this.xBounds.min + 1;
            int n = this.xBounds.range + this.xBounds.min;
            if (j <= n) {
                while (true) {
                    prev = cur;
                    cur = dataSet.getEntryForIndex(j);
                    float cpx = ((Entry)prev).getX() + (((Entry)cur).getX() - ((Entry)prev).getX()) / 2.0f;
                    this.cubicPath.cubicTo(cpx, ((BaseEntry)prev).getY() * phaseY, cpx, ((BaseEntry)cur).getY() * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
                    if (j == n) break;
                    ++j;
                }
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            Canvas canvas = this.bitmapCanvas;
            if (canvas != null) {
                Canvas it = canvas;
                boolean bl = false;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                BarLineScatterCandleBubbleRenderer.XBounds xBounds = this.xBounds;
                Intrinsics.checkNotNullExpressionValue((Object)xBounds, (String)"xBounds");
                this.drawCubicFill(it, dataSet, this.cubicFillPath, transformer, xBounds);
            }
        }
        this.getPaintRender().setColor(dataSet.getColor());
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pathValueToPixel(this.cubicPath);
        Canvas canvas = this.bitmapCanvas;
        Intrinsics.checkNotNull((Object)canvas);
        canvas.drawPath(this.cubicPath, this.getPaintRender());
        this.getPaintRender().setPathEffect(null);
    }

    protected final void drawCubicBezier(@NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float phaseY = this.animator.getPhaseY();
        Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
        this.xBounds.set(this.chart, dataSet);
        float intensity = dataSet.getCubicIntensity();
        this.cubicPath.reset();
        if (this.xBounds.range >= 1) {
            Object cur;
            float prevDx = 0.0f;
            float prevDy = 0.0f;
            float curDx = 0.0f;
            float curDy = 0.0f;
            int firstIndex = this.xBounds.min + 1;
            int lastIndex = this.xBounds.min + this.xBounds.range;
            Entry prevPrev = null;
            Object prev = dataSet.getEntryForIndex((int)Math.max((double)(firstIndex - 2), 0.0));
            Object next = cur = dataSet.getEntryForIndex((int)Math.max((double)(firstIndex - 1), 0.0));
            int nextIndex = -1;
            if (cur == null) {
                return;
            }
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            int j = this.xBounds.min + 1;
            int n = this.xBounds.range + this.xBounds.min;
            if (j <= n) {
                while (true) {
                    prevPrev = (Entry)prev;
                    prev = cur;
                    cur = nextIndex == j ? next : dataSet.getEntryForIndex(j);
                    nextIndex = j + 1 < dataSet.getEntryCount() ? j + 1 : j;
                    next = dataSet.getEntryForIndex(nextIndex);
                    Object t = cur;
                    Intrinsics.checkNotNull(t);
                    float f = ((Entry)t).getX();
                    Entry entry = prevPrev;
                    Intrinsics.checkNotNull(entry);
                    prevDx = (f - entry.getX()) * intensity;
                    prevDy = (((BaseEntry)cur).getY() - prevPrev.getY()) * intensity;
                    curDx = (((Entry)next).getX() - ((Entry)prev).getX()) * intensity;
                    curDy = (((BaseEntry)next).getY() - ((BaseEntry)prev).getY()) * intensity;
                    this.cubicPath.cubicTo(((Entry)prev).getX() + prevDx, (((BaseEntry)prev).getY() + prevDy) * phaseY, ((Entry)cur).getX() - curDx, (((BaseEntry)cur).getY() - curDy) * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
                    if (j == n) break;
                    ++j;
                }
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            Canvas canvas = this.bitmapCanvas;
            if (canvas != null) {
                Canvas it = canvas;
                boolean bl = false;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                BarLineScatterCandleBubbleRenderer.XBounds xBounds = this.xBounds;
                Intrinsics.checkNotNullExpressionValue((Object)xBounds, (String)"xBounds");
                this.drawCubicFill(it, dataSet, this.cubicFillPath, transformer, xBounds);
            }
        }
        this.getPaintRender().setColor(dataSet.getColor());
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pathValueToPixel(this.cubicPath);
        Canvas canvas = this.bitmapCanvas;
        Intrinsics.checkNotNull((Object)canvas);
        canvas.drawPath(this.cubicPath, this.getPaintRender());
        this.getPaintRender().setPathEffect(null);
    }

    protected final void drawCubicFill(@NotNull Canvas c, @NotNull ILineDataSet dataSet, @NotNull Path spline, @NotNull Transformer trans, @NotNull BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.chart);
        spline.lineTo(((Entry)dataSet.getEntryForIndex(bounds.min + bounds.range)).getX(), fillMin);
        spline.lineTo(((Entry)dataSet.getEntryForIndex(bounds.min)).getX(), fillMin);
        spline.close();
        trans.pathValueToPixel(spline);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(c, spline, drawable);
        } else {
            this.drawFilledPath(c, spline, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    protected final void drawLinear(@NotNull Canvas c, @NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        int entryCount = dataSet.getEntryCount();
        boolean isDrawSteppedEnabled = dataSet.isDrawSteppedEnabled();
        int pointsPerEntryPair = isDrawSteppedEnabled ? 4 : 2;
        Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.animator.getPhaseY();
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        Canvas canvas = dataSet.isDashedLineEnabled() ? this.bitmapCanvas : c;
        this.xBounds.set(this.chart, dataSet);
        if (dataSet.isDrawFilledEnabled() && entryCount > 0) {
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            BarLineScatterCandleBubbleRenderer.XBounds xBounds = this.xBounds;
            Intrinsics.checkNotNullExpressionValue((Object)xBounds, (String)"xBounds");
            this.drawLinearFill(c, dataSet, transformer, xBounds);
        }
        if (dataSet.getColors().size() > 1) {
            int numberOfFloats = pointsPerEntryPair * 2;
            if (this.lineBuffer.length <= numberOfFloats) {
                this.lineBuffer = new float[numberOfFloats * 2];
            }
            int max = this.xBounds.min + this.xBounds.range;
            for (int j = this.xBounds.min; j < max; ++j) {
                Object entry;
                if (dataSet.getEntryForIndex(j) == null) continue;
                this.lineBuffer[0] = ((Entry)entry).getX();
                this.lineBuffer[1] = ((BaseEntry)entry).getY() * phaseY;
                if (j < this.xBounds.max) {
                    Object t = dataSet.getEntryForIndex(j + 1);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"getEntryForIndex(...)");
                    entry = t;
                    if (isDrawSteppedEnabled) {
                        this.lineBuffer[2] = ((Entry)entry).getX();
                        this.lineBuffer[3] = this.lineBuffer[1];
                        this.lineBuffer[4] = this.lineBuffer[2];
                        this.lineBuffer[5] = this.lineBuffer[3];
                        this.lineBuffer[6] = ((Entry)entry).getX();
                        this.lineBuffer[7] = ((BaseEntry)entry).getY() * phaseY;
                    } else {
                        this.lineBuffer[2] = ((Entry)entry).getX();
                        this.lineBuffer[3] = ((BaseEntry)entry).getY() * phaseY;
                    }
                } else {
                    this.lineBuffer[2] = this.lineBuffer[0];
                    this.lineBuffer[3] = this.lineBuffer[1];
                }
                float firstCoordinateX = this.lineBuffer[0];
                float firstCoordinateY = this.lineBuffer[1];
                float lastCoordinateX = this.lineBuffer[numberOfFloats - 2];
                float lastCoordinateY = this.lineBuffer[numberOfFloats - 1];
                if (firstCoordinateX == lastCoordinateX && firstCoordinateY == lastCoordinateY) continue;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(this.lineBuffer);
                if (this.viewPortHandler.isInBoundsRight(firstCoordinateX)) {
                    if (!this.viewPortHandler.isInBoundsLeft(lastCoordinateX)) continue;
                    if (!this.viewPortHandler.isInBoundsTop((float)Math.max((double)firstCoordinateY, (double)lastCoordinateY)) || !this.viewPortHandler.isInBoundsBottom((float)Math.min((double)firstCoordinateY, (double)lastCoordinateY))) continue;
                    this.getPaintRender().setColor(dataSet.getColor(j));
                    Canvas canvas2 = canvas;
                    Intrinsics.checkNotNull((Object)canvas2);
                    canvas2.drawLines(this.lineBuffer, 0, pointsPerEntryPair * 2, this.getPaintRender());
                    continue;
                }
                break;
            }
        } else {
            if ((double)this.lineBuffer.length < Math.max((double)(entryCount * pointsPerEntryPair), (double)pointsPerEntryPair) * (double)2) {
                this.lineBuffer = new float[(int)(Math.max((double)(entryCount * pointsPerEntryPair), (double)pointsPerEntryPair) * (double)4)];
            }
            Entry e1 = null;
            Entry e2 = null;
            e1 = (Entry)dataSet.getEntryForIndex(this.xBounds.min);
            if (e1 != null) {
                int j = 0;
                int x = this.xBounds.min;
                int n = this.xBounds.range + this.xBounds.min;
                if (x <= n) {
                    while (true) {
                        e1 = (Entry)dataSet.getEntryForIndex(x == 0 ? 0 : x - 1);
                        e2 = (Entry)dataSet.getEntryForIndex(x);
                        if (e1 != null && e2 != null) {
                            this.lineBuffer[j++] = e1.getX();
                            this.lineBuffer[j++] = e1.getY() * phaseY;
                            if (isDrawSteppedEnabled) {
                                this.lineBuffer[j++] = e2.getX();
                                this.lineBuffer[j++] = e1.getY() * phaseY;
                                this.lineBuffer[j++] = e2.getX();
                                this.lineBuffer[j++] = e1.getY() * phaseY;
                            }
                            this.lineBuffer[j++] = e2.getX();
                            this.lineBuffer[j++] = e2.getY() * phaseY;
                        }
                        if (x == n) break;
                        ++x;
                    }
                }
                if (j > 0) {
                    Transformer transformer = trans;
                    Intrinsics.checkNotNull((Object)transformer);
                    transformer.pointValuesToPixel(this.lineBuffer);
                    int size = (int)(Math.max((double)((this.xBounds.range + 1) * pointsPerEntryPair), (double)pointsPerEntryPair) * (double)2);
                    this.getPaintRender().setColor(dataSet.getColor());
                    Canvas canvas3 = canvas;
                    Intrinsics.checkNotNull((Object)canvas3);
                    canvas3.drawLines(this.lineBuffer, 0, size, this.getPaintRender());
                }
            }
        }
        this.getPaintRender().setPathEffect(null);
    }

    @NotNull
    protected final Path getMGenerateFilledPathBuffer() {
        return this.mGenerateFilledPathBuffer;
    }

    protected final void setMGenerateFilledPathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mGenerateFilledPathBuffer = path;
    }

    protected final void drawLinearFill(@NotNull Canvas c, @NotNull ILineDataSet dataSet, @NotNull Transformer trans, @NotNull BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Path filled = this.mGenerateFilledPathBuffer;
        int startingIndex = bounds.min;
        int endingIndex = bounds.range + bounds.min;
        int indexInterval = 128;
        int currentStartIndex = 0;
        int currentEndIndex = 0;
        int iterations = 0;
        do {
            currentStartIndex = startingIndex + iterations * indexInterval;
            currentEndIndex = currentStartIndex + indexInterval;
            if (currentStartIndex <= (currentEndIndex = (int)Math.min((double)currentEndIndex, (double)endingIndex))) {
                Drawable drawable = dataSet.getFillDrawable();
                int startIndex = currentStartIndex;
                int endIndex = currentEndIndex;
                if (drawable != null) {
                    startIndex = (int)Math.max(0.0, (double)(currentStartIndex - 1));
                    endIndex = (int)Math.min((double)endingIndex, (double)(currentEndIndex + 1));
                }
                this.generateFilledPath(dataSet, startIndex, endIndex, filled);
                trans.pathValueToPixel(filled);
                if (drawable != null) {
                    this.drawFilledPath(c, filled, drawable);
                } else {
                    this.drawFilledPath(c, filled, dataSet.getFillColor(), dataSet.getFillAlpha());
                }
            }
            ++iterations;
        } while (currentStartIndex <= currentEndIndex);
    }

    private final void generateFilledPath(ILineDataSet dataSet, int startIndex, int endIndex, Path outputPath) {
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.chart);
        float phaseY = this.animator.getPhaseY();
        boolean isDrawSteppedEnabled = dataSet.getMode() == LineDataSet.Mode.STEPPED;
        Path filled = outputPath;
        filled.reset();
        Object entry = dataSet.getEntryForIndex(startIndex);
        filled.moveTo(((Entry)entry).getX(), fillMin);
        filled.lineTo(((Entry)entry).getX(), ((BaseEntry)entry).getY() * phaseY);
        Entry currentEntry = null;
        Object previousEntry = entry;
        int x = startIndex + 1;
        if (x <= endIndex) {
            while (true) {
                if ((currentEntry = (Entry)dataSet.getEntryForIndex(x)) != null) {
                    if (isDrawSteppedEnabled) {
                        filled.lineTo(currentEntry.getX(), ((BaseEntry)previousEntry).getY() * phaseY);
                    }
                    filled.lineTo(currentEntry.getX(), currentEntry.getY() * phaseY);
                    previousEntry = currentEntry;
                }
                if (x == endIndex) break;
                ++x;
            }
        }
        if (currentEntry != null) {
            filled.lineTo(currentEntry.getX(), fillMin);
        }
        filled.close();
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.isDrawingValuesAllowed(this.chart)) {
            List dataSets = this.chart.getLineData().getDataSets();
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                Intrinsics.checkNotNull((Object)dataSet);
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
                int valOffset = (int)(dataSet.getCircleRadius() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                this.xBounds.set(this.chart, dataSet);
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                float[] positions = transformer.generateTransformedValuesLine(dataSet, this.animator.getPhaseX(), this.animator.getPhaseY(), this.xBounds.min, this.xBounds.max);
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                int j = 0;
                while (j < positions.length) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.viewPortHandler.isInBoundsRight(x)) break;
                    if (!this.viewPortHandler.isInBoundsLeft(x) || !this.viewPortHandler.isInBoundsY(y)) {
                        j += 2;
                        continue;
                    }
                    Object entry = dataSet.getEntryForIndex(j / 2 + this.xBounds.min);
                    if (entry != null) {
                        if (dataSet.isDrawValuesEnabled()) {
                            IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                            Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                            this.drawValue(c, iValueFormatter, ((BaseEntry)entry).getY(), (Entry)entry, i, x, y - (float)valOffset, dataSet.getValueTextColor(j / 2));
                        }
                        if (((BaseEntry)entry).getIcon() != null && dataSet.isDrawIconsEnabled()) {
                            Drawable icon = ((BaseEntry)entry).getIcon();
                            int n2 = (int)(x + iconsOffset.x);
                            int n3 = (int)(y + iconsOffset.y);
                            Drawable drawable = icon;
                            Intrinsics.checkNotNull((Object)drawable);
                            Utils.drawImage(c, icon, n2, n3, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                        }
                    }
                    j += 2;
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.drawCircles(c);
    }

    protected final void drawCircles(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.getPaintRender().setStyle(Paint.Style.FILL);
        float phaseY = this.animator.getPhaseY();
        this.mCirclesBuffer[0] = 0.0f;
        this.mCirclesBuffer[1] = 0.0f;
        List dataSets = this.chart.getLineData().getDataSets();
        int n = ((Collection)dataSets).size();
        block0: for (int i = 0; i < n; ++i) {
            int boundsRangeCount;
            int j;
            ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
            if (!dataSet.isVisible() || !dataSet.isDrawCirclesEnabled() || dataSet.getEntryCount() == 0) continue;
            this.circlePaintInner.setColor(dataSet.getCircleHoleColor());
            Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
            this.xBounds.set(this.chart, dataSet);
            float circleRadius = dataSet.getCircleRadius();
            float circleHoleRadius = dataSet.getCircleHoleRadius();
            boolean drawCircleHole = dataSet.isDrawCircleHoleEnabled() && circleHoleRadius < circleRadius && circleHoleRadius > 0.0f;
            boolean drawTransparentCircleHole = drawCircleHole && dataSet.getCircleHoleColor() == 0x112233;
            DataSetImageCache imageCache = null;
            if (this.mImageCaches.containsKey(dataSet)) {
                imageCache = this.mImageCaches.get(dataSet);
            } else {
                imageCache = new DataSetImageCache();
                ((Map)this.mImageCaches).put(dataSet, imageCache);
            }
            DataSetImageCache dataSetImageCache = imageCache;
            Intrinsics.checkNotNull((Object)dataSetImageCache);
            Intrinsics.checkNotNull((Object)dataSet);
            boolean changeRequired = dataSetImageCache.init(dataSet);
            if (changeRequired) {
                imageCache.fill(dataSet, drawCircleHole, drawTransparentCircleHole);
            }
            if ((j = this.xBounds.min) > (boundsRangeCount = this.xBounds.range + this.xBounds.min)) continue;
            while (dataSet.getEntryForIndex(j) != null) {
                Bitmap circleBitmap;
                Object e;
                this.mCirclesBuffer[0] = ((Entry)e).getX();
                this.mCirclesBuffer[1] = ((BaseEntry)e).getY() * phaseY;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(this.mCirclesBuffer);
                if (!this.viewPortHandler.isInBoundsRight(this.mCirclesBuffer[0])) continue block0;
                if (this.viewPortHandler.isInBoundsLeft(this.mCirclesBuffer[0]) && this.viewPortHandler.isInBoundsY(this.mCirclesBuffer[1]) && (circleBitmap = imageCache.getBitmap(j)) != null) {
                    c.drawBitmap(circleBitmap, this.mCirclesBuffer[0] - circleRadius, this.mCirclesBuffer[1] - circleRadius, null);
                }
                if (j == boundsRangeCount) continue block0;
                ++j;
            }
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        LineData lineData = this.chart.getLineData();
        for (Highlight high : indices) {
            Object e;
            ILineDataSet set = (ILineDataSet)lineData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX((Entry)(e = set.getEntryForXValue(high.getX(), high.getY())), set)) continue;
            Transformer transformer = this.chart.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD pix = transformer.getPixelForValues(((Entry)e).getX(), ((BaseEntry)e).getY() * this.animator.getPhaseY());
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }

    @NotNull
    public final Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public final void setBitmapConfig(@NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.mBitmapConfig = config;
        this.releaseBitmap();
    }

    public final void releaseBitmap() {
        Canvas canvas = this.bitmapCanvas;
        if (canvas != null) {
            canvas.setBitmap(null);
        }
        this.bitmapCanvas = null;
        if (this.drawBitmap != null) {
            Bitmap drawBitmap;
            WeakReference<Bitmap> weakReference = this.drawBitmap;
            Bitmap bitmap = drawBitmap = weakReference != null ? (Bitmap)weakReference.get() : null;
            if (bitmap != null) {
                bitmap.recycle();
            }
            WeakReference<Bitmap> weakReference2 = this.drawBitmap;
            if (weakReference2 != null) {
                weakReference2.clear();
            }
            this.drawBitmap = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/github/mikephil/charting/renderer/LineChartRenderer$DataSetImageCache;", "", "<init>", "(Lcom/github/mikephil/charting/renderer/LineChartRenderer;)V", "mCirclePathBuffer", "Landroid/graphics/Path;", "circleBitmaps", "", "Landroid/graphics/Bitmap;", "[Landroid/graphics/Bitmap;", "init", "", "set", "Lcom/github/mikephil/charting/interfaces/datasets/ILineDataSet;", "fill", "", "drawCircleHole", "drawTransparentCircleHole", "getBitmap", "index", "", "MPChartLib_release"})
    private final class DataSetImageCache {
        @NotNull
        private final Path mCirclePathBuffer = new Path();
        @Nullable
        private Bitmap[] circleBitmaps;

        public final boolean init(@NotNull ILineDataSet set) {
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            int size = set.getCircleColorCount();
            boolean changeRequired = false;
            if (this.circleBitmaps == null) {
                this.circleBitmaps = new Bitmap[size];
                changeRequired = true;
            } else {
                Intrinsics.checkNotNull((Object)this.circleBitmaps);
                if (this.circleBitmaps.length != size) {
                    this.circleBitmaps = new Bitmap[size];
                    changeRequired = true;
                }
            }
            return changeRequired;
        }

        public final void fill(@NotNull ILineDataSet set, boolean drawCircleHole, boolean drawTransparentCircleHole) {
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            int colorCount = set.getCircleColorCount();
            float circleRadius = set.getCircleRadius();
            float circleHoleRadius = set.getCircleHoleRadius();
            for (int i = 0; i < colorCount; ++i) {
                Bitmap circleBitmap;
                Bitmap.Config conf = Bitmap.Config.ARGB_4444;
                Intrinsics.checkNotNullExpressionValue((Object)Bitmap.createBitmap((int)((int)((double)circleRadius * 2.1)), (int)((int)((double)circleRadius * 2.1)), (Bitmap.Config)conf), (String)"createBitmap(...)");
                Canvas canvas = new Canvas(circleBitmap);
                Intrinsics.checkNotNull((Object)this.circleBitmaps);
                this.circleBitmaps[i] = circleBitmap;
                LineChartRenderer.this.getPaintRender().setColor(set.getCircleColor(i));
                if (drawTransparentCircleHole) {
                    this.mCirclePathBuffer.reset();
                    this.mCirclePathBuffer.addCircle(circleRadius, circleRadius, circleRadius, Path.Direction.CW);
                    this.mCirclePathBuffer.addCircle(circleRadius, circleRadius, circleHoleRadius, Path.Direction.CCW);
                    canvas.drawPath(this.mCirclePathBuffer, LineChartRenderer.this.getPaintRender());
                    continue;
                }
                canvas.drawCircle(circleRadius, circleRadius, circleRadius, LineChartRenderer.this.getPaintRender());
                if (!drawCircleHole) continue;
                canvas.drawCircle(circleRadius, circleRadius, circleHoleRadius, LineChartRenderer.this.getCirclePaintInner());
            }
        }

        @Nullable
        public final Bitmap getBitmap(int index) {
            Intrinsics.checkNotNull((Object)this.circleBitmaps);
            Intrinsics.checkNotNull((Object)this.circleBitmaps);
            return this.circleBitmaps[index % this.circleBitmaps.length];
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineDataSet.Mode.values().length];
            try {
                nArray[LineDataSet.Mode.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDataSet.Mode.STEPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDataSet.Mode.CUBIC_BEZIER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDataSet.Mode.HORIZONTAL_BEZIER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

