/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.LegendEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 J\u000e\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)J0\u0010,\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0004J(\u00101\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/github/mikephil/charting/renderer/LegendRenderer;", "Lcom/github/mikephil/charting/renderer/Renderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "legend", "Lcom/github/mikephil/charting/components/Legend;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/Legend;)V", "getLegend", "()Lcom/github/mikephil/charting/components/Legend;", "setLegend", "(Lcom/github/mikephil/charting/components/Legend;)V", "value", "Landroid/graphics/Paint;", "labelPaint", "getLabelPaint", "()Landroid/graphics/Paint;", "setLabelPaint", "(Landroid/graphics/Paint;)V", "formPaint", "getFormPaint", "setFormPaint", "computedEntries", "", "Lcom/github/mikephil/charting/components/LegendEntry;", "getComputedEntries", "()Ljava/util/List;", "setComputedEntries", "(Ljava/util/List;)V", "computeLegend", "", "data", "Lcom/github/mikephil/charting/data/ChartData;", "legendFontMetrics", "Landroid/graphics/Paint$FontMetrics;", "getLegendFontMetrics", "()Landroid/graphics/Paint$FontMetrics;", "setLegendFontMetrics", "(Landroid/graphics/Paint$FontMetrics;)V", "renderLegend", "c", "Landroid/graphics/Canvas;", "mLineFormPath", "Landroid/graphics/Path;", "drawForm", "x", "", "y", "entry", "drawLabel", "label", "", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nLegendRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegendRenderer.kt\ncom/github/mikephil/charting/renderer/LegendRenderer\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,499:1\n27#2,7:500\n*S KotlinDebug\n*F\n+ 1 LegendRenderer.kt\ncom/github/mikephil/charting/renderer/LegendRenderer\n*L\n434#1:500,7\n*E\n"})
public class LegendRenderer
extends Renderer {
    @NotNull
    private Legend legend;
    @NotNull
    private Paint labelPaint;
    @NotNull
    private Paint formPaint;
    @NotNull
    private List<LegendEntry> computedEntries;
    @NotNull
    private Paint.FontMetrics legendFontMetrics;
    @NotNull
    private final Path mLineFormPath;

    public LegendRenderer(@NotNull ViewPortHandler viewPortHandler, @NotNull Legend legend) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)legend, (String)"legend");
        super(viewPortHandler);
        this.legend = legend;
        this.computedEntries = new ArrayList(16);
        this.legendFontMetrics = new Paint.FontMetrics();
        this.mLineFormPath = new Path();
        this.labelPaint = new Paint(1);
        this.labelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.labelPaint.setTextAlign(Paint.Align.LEFT);
        this.formPaint = new Paint(1);
        this.formPaint.setStyle(Paint.Style.FILL);
    }

    @NotNull
    protected final Legend getLegend() {
        return this.legend;
    }

    protected final void setLegend(@NotNull Legend legend) {
        Intrinsics.checkNotNullParameter((Object)legend, (String)"<set-?>");
        this.legend = legend;
    }

    @NotNull
    public final Paint getLabelPaint() {
        return this.labelPaint;
    }

    protected final void setLabelPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.labelPaint = paint;
    }

    @NotNull
    public final Paint getFormPaint() {
        return this.formPaint;
    }

    protected final void setFormPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.formPaint = paint;
    }

    @NotNull
    protected final List<LegendEntry> getComputedEntries() {
        return this.computedEntries;
    }

    protected final void setComputedEntries(@NotNull List<LegendEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.computedEntries = list;
    }

    public final void computeLegend(@NotNull ChartData<?> data) {
        Typeface tf;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (!this.legend.isLegendCustom()) {
            this.computedEntries.clear();
            int n = data.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                Object dataSet;
                if (data.getDataSetByIndex(i) == null) continue;
                List<Integer> clrs = dataSet.getColors();
                int entryCount = dataSet.getEntryCount();
                if (dataSet instanceof IBarDataSet && ((IBarDataSet)dataSet).isStacked()) {
                    Object bds = dataSet;
                    String[] sLabels = ((IBarDataSet)bds).getStackLabels();
                    int minEntries = (int)Math.min((double)clrs.size(), (double)((IBarDataSet)bds).getStackSize());
                    for (int j = 0; j < minEntries; ++j) {
                        int labelIndex;
                        String label = null;
                        Intrinsics.checkNotNull((Object)sLabels);
                        label = !(sLabels.length == 0) ? ((labelIndex = j % minEntries) < sLabels.length ? sLabels[labelIndex] : null) : null;
                        Legend.LegendForm legendForm = ((IBarDataSet)dataSet).getForm();
                        float f = ((IBarDataSet)dataSet).getFormSize();
                        float f2 = ((IBarDataSet)dataSet).getFormLineWidth();
                        DashPathEffect dashPathEffect = ((IBarDataSet)dataSet).getFormLineDashEffect();
                        Integer n2 = clrs.get(j);
                        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"get(...)");
                        this.computedEntries.add(new LegendEntry(label, legendForm, f, f2, dashPathEffect, ((Number)n2).intValue()));
                    }
                    if (((IBarDataSet)bds).getLabel() == null) continue;
                    this.computedEntries.add(new LegendEntry(((IBarDataSet)dataSet).getLabel(), Legend.LegendForm.NONE, Float.NaN, Float.NaN, null, 0x112233));
                    continue;
                }
                if (dataSet instanceof IPieDataSet) {
                    Object pds = dataSet;
                    for (int j = 0; j < clrs.size() && j < entryCount; ++j) {
                        String string = ((PieEntry)((IPieDataSet)pds).getEntryForIndex(j)).getLabel();
                        Legend.LegendForm legendForm = ((IPieDataSet)dataSet).getForm();
                        float f = ((IPieDataSet)dataSet).getFormSize();
                        float f3 = ((IPieDataSet)dataSet).getFormLineWidth();
                        DashPathEffect dashPathEffect = ((IPieDataSet)dataSet).getFormLineDashEffect();
                        Integer n3 = clrs.get(j);
                        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"get(...)");
                        this.computedEntries.add(new LegendEntry(string, legendForm, f, f3, dashPathEffect, ((Number)n3).intValue()));
                    }
                    if (((IPieDataSet)pds).getLabel() == null) continue;
                    this.computedEntries.add(new LegendEntry(((IPieDataSet)dataSet).getLabel(), Legend.LegendForm.NONE, Float.NaN, Float.NaN, null, 0x112233));
                    continue;
                }
                if (dataSet instanceof ICandleDataSet && ((ICandleDataSet)dataSet).getDecreasingColor() != 0x112233) {
                    int decreasingColor = ((ICandleDataSet)dataSet).getDecreasingColor();
                    int increasingColor = ((ICandleDataSet)dataSet).getIncreasingColor();
                    this.computedEntries.add(new LegendEntry(null, ((ICandleDataSet)dataSet).getForm(), ((ICandleDataSet)dataSet).getFormSize(), ((ICandleDataSet)dataSet).getFormLineWidth(), ((ICandleDataSet)dataSet).getFormLineDashEffect(), decreasingColor));
                    this.computedEntries.add(new LegendEntry(((ICandleDataSet)dataSet).getLabel(), ((ICandleDataSet)dataSet).getForm(), ((ICandleDataSet)dataSet).getFormSize(), ((ICandleDataSet)dataSet).getFormLineWidth(), ((ICandleDataSet)dataSet).getFormLineDashEffect(), increasingColor));
                    continue;
                }
                for (int j = 0; j < clrs.size() && j < entryCount; ++j) {
                    String label = j < clrs.size() - 1 && j < entryCount - 1 ? null : data.getDataSetByIndex(i).getLabel();
                    Legend.LegendForm legendForm = dataSet.getForm();
                    float f = dataSet.getFormSize();
                    float f4 = dataSet.getFormLineWidth();
                    DashPathEffect dashPathEffect = dataSet.getFormLineDashEffect();
                    Integer n4 = clrs.get(j);
                    Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"get(...)");
                    this.computedEntries.add(new LegendEntry(label, legendForm, f, f4, dashPathEffect, ((Number)n4).intValue()));
                }
            }
            if (this.legend.getExtraEntries() != null) {
                LegendEntry[] i = this.legend.getExtraEntries();
                Collections.addAll((Collection)this.computedEntries, Arrays.copyOf(i, i.length));
            }
            this.legend.setEntries(this.computedEntries);
        }
        if ((tf = this.legend.getTypeface()) != null) {
            this.labelPaint.setTypeface(tf);
        }
        this.labelPaint.setTextSize(this.legend.getTextSize());
        this.labelPaint.setColor(this.legend.getTextColor());
        this.legend.calculateDimensions(this.labelPaint, this.viewPortHandler);
    }

    @NotNull
    protected final Paint.FontMetrics getLegendFontMetrics() {
        return this.legendFontMetrics;
    }

    protected final void setLegendFontMetrics(@NotNull Paint.FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"<set-?>");
        this.legendFontMetrics = fontMetrics;
    }

    public final void renderLegend(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.legend.isEnabled()) {
            return;
        }
        Typeface tf = this.legend.getTypeface();
        if (tf != null) {
            this.labelPaint.setTypeface(tf);
        }
        this.labelPaint.setTextSize(this.legend.getTextSize());
        this.labelPaint.setColor(this.legend.getTextColor());
        float labelLineHeight = Utils.getLineHeight(this.labelPaint, this.legendFontMetrics);
        float labelLineSpacing = Utils.getLineSpacing(this.labelPaint, this.legendFontMetrics) + Utils.convertDpToPixel(this.legend.getYEntrySpace());
        float formYOffset = labelLineHeight - (float)Utils.calcTextHeight(this.labelPaint, "ABC") / 2.0f;
        LegendEntry[] entries = this.legend.getEntries();
        float formToTextSpace = Utils.convertDpToPixel(this.legend.getFormToTextSpace());
        float xEntrySpace = Utils.convertDpToPixel(this.legend.getXEntrySpace());
        Legend.LegendOrientation orientation = this.legend.getOrientation();
        Legend.LegendHorizontalAlignment horizontalAlignment = this.legend.getHorizontalAlignment();
        Legend.LegendVerticalAlignment verticalAlignment = this.legend.getVerticalAlignment();
        Legend.LegendDirection direction = this.legend.getDirection();
        float defaultFormSize = Utils.convertDpToPixel(this.legend.getFormSize());
        float stackSpace = Utils.convertDpToPixel(this.legend.getStackSpace());
        float yOffset = this.legend.getYOffset();
        float xOffset = this.legend.getXOffset();
        float originPosX = 0.0f;
        Legend.LegendHorizontalAlignment legendHorizontalAlignment = horizontalAlignment;
        switch (legendHorizontalAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[legendHorizontalAlignment.ordinal()]) {
            case 1: {
                float f = originPosX = orientation == Legend.LegendOrientation.VERTICAL ? xOffset : this.viewPortHandler.contentLeft() + xOffset;
                if (direction != Legend.LegendDirection.RIGHT_TO_LEFT) break;
                originPosX += this.legend.mNeededWidth;
                break;
            }
            case 2: {
                float f = originPosX = orientation == Legend.LegendOrientation.VERTICAL ? this.viewPortHandler.getChartWidth() - xOffset : this.viewPortHandler.contentRight() - xOffset;
                if (direction != Legend.LegendDirection.LEFT_TO_RIGHT) break;
                originPosX -= this.legend.mNeededWidth;
                break;
            }
            case 3: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? this.viewPortHandler.getChartWidth() / 2.0f : this.viewPortHandler.contentLeft() + this.viewPortHandler.contentWidth() / 2.0f;
                originPosX += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? xOffset : -xOffset;
                if (orientation != Legend.LegendOrientation.VERTICAL) break;
                originPosX += (float)(direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (double)(-this.legend.mNeededWidth) / 2.0 + (double)xOffset : (double)this.legend.mNeededWidth / 2.0 - (double)xOffset);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Legend.LegendOrientation legendOrientation = orientation;
        switch (legendOrientation == null ? -1 : WhenMappings.$EnumSwitchMapping$2[legendOrientation.ordinal()]) {
            case 1: {
                List<FSize> calculatedLineSizes = this.legend.getCalculatedLineSizes();
                List<FSize> calculatedLabelSizes = this.legend.getCalculatedLabelSizes();
                List<Boolean> calculatedLabelBreakPoints = this.legend.getCalculatedLabelBreakPoints();
                float posX = originPosX;
                Legend.LegendVerticalAlignment legendVerticalAlignment = verticalAlignment;
                float posY = switch (legendVerticalAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$1[legendVerticalAlignment.ordinal()]) {
                    case 1 -> yOffset;
                    case 2 -> this.viewPortHandler.getChartHeight() - yOffset - this.legend.mNeededHeight;
                    case 3 -> (this.viewPortHandler.getChartHeight() - this.legend.mNeededHeight) / 2.0f + yOffset;
                    default -> throw new NoWhenBranchMatchedException();
                };
                int lineIndex = 0;
                int count = entries.length;
                for (int i = 0; i < count; ++i) {
                    boolean isStacked;
                    float formSize;
                    LegendEntry e = entries[i];
                    boolean drawingForm = e.form != Legend.LegendForm.NONE;
                    float f = formSize = Float.isNaN(e.formSize) ? defaultFormSize : Utils.convertDpToPixel(e.formSize);
                    if (i < calculatedLabelBreakPoints.size() && calculatedLabelBreakPoints.get(i).booleanValue()) {
                        posX = originPosX;
                        posY += labelLineHeight + labelLineSpacing;
                    }
                    if (posX == originPosX && horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER && lineIndex < calculatedLineSizes.size()) {
                        posX += (direction == Legend.LegendDirection.RIGHT_TO_LEFT ? calculatedLineSizes.get((int)lineIndex).width : -calculatedLineSizes.get((int)lineIndex).width) / 2.0f;
                        ++lineIndex;
                    }
                    boolean bl = isStacked = e.label == null;
                    if (drawingForm) {
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= formSize;
                        }
                        Intrinsics.checkNotNull((Object)e);
                        this.drawForm(c, posX, posY + formYOffset, e, this.legend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (!isStacked) {
                        if (drawingForm) {
                            posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -formToTextSpace : formToTextSpace;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= calculatedLabelSizes.get((int)i).width;
                        }
                        String string = e.label;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label");
                        this.drawLabel(c, posX, posY + labelLineHeight, string);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += calculatedLabelSizes.get((int)i).width;
                        }
                        posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -xEntrySpace : xEntrySpace;
                        continue;
                    }
                    posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -stackSpace : stackSpace;
                }
                break;
            }
            case 2: {
                float stack = 0.0f;
                boolean wasStacked = false;
                float posY = 0.0f;
                Legend.LegendVerticalAlignment legendVerticalAlignment = verticalAlignment;
                switch (legendVerticalAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$1[legendVerticalAlignment.ordinal()]) {
                    case 1: {
                        posY = horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? 0.0f : this.viewPortHandler.contentTop();
                        posY += yOffset;
                        break;
                    }
                    case 2: {
                        posY = horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? this.viewPortHandler.getChartHeight() : this.viewPortHandler.contentBottom();
                        posY -= this.legend.mNeededHeight + yOffset;
                        break;
                    }
                    case 3: {
                        posY = this.viewPortHandler.getChartHeight() / 2.0f - this.legend.mNeededHeight / 2.0f + this.legend.getYOffset();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                for (int i = 0; i < entries.length; ++i) {
                    LegendEntry e = entries[i];
                    boolean drawingForm = e.form != Legend.LegendForm.NONE;
                    float formSize = Float.isNaN(e.formSize) ? defaultFormSize : Utils.convertDpToPixel(e.formSize);
                    float posX = originPosX;
                    if (drawingForm) {
                        posX = direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (posX += stack) : (posX -= formSize - stack);
                        Intrinsics.checkNotNull((Object)e);
                        this.drawForm(c, posX, posY + formYOffset, e, this.legend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (e.label != null) {
                        if (drawingForm && !wasStacked) {
                            posX += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? formToTextSpace : -formToTextSpace;
                        } else if (wasStacked) {
                            posX = originPosX;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= (float)Utils.calcTextWidth(this.labelPaint, e.label);
                        }
                        if (!wasStacked) {
                            String string = e.label;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label");
                            this.drawLabel(c, posX, posY + labelLineHeight, string);
                        } else {
                            String string = e.label;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label");
                            this.drawLabel(c, posX, (posY += labelLineHeight + labelLineSpacing) + labelLineHeight, string);
                        }
                        posY += labelLineHeight + labelLineSpacing;
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void drawForm(@NotNull Canvas c, float x, float y, @NotNull LegendEntry entry, @NotNull Legend legend) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)legend, (String)"legend");
        if (entry.formColor == 1122868 || entry.formColor == 0x112233 || entry.formColor == 0) {
            return;
        }
        Canvas $this$withSave$iv = c;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawForm_u24lambda_u240 = $this$withSave$iv;
            boolean bl = false;
            Legend.LegendForm form = entry.form;
            if (form == Legend.LegendForm.DEFAULT) {
                form = legend.getForm();
            }
            this.formPaint.setColor(entry.formColor);
            float formSize = Utils.convertDpToPixel(Float.isNaN(entry.formSize) ? legend.getFormSize() : entry.formSize);
            float half = formSize / 2.0f;
            Legend.LegendForm legendForm = form;
            switch (legendForm == null ? -1 : WhenMappings.$EnumSwitchMapping$3[legendForm.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    this.formPaint.setStyle(Paint.Style.FILL);
                    c.drawCircle(x + half, y, half, this.formPaint);
                    break;
                }
                case 5: {
                    this.formPaint.setStyle(Paint.Style.FILL);
                    c.drawRect(x, y - half, x + formSize, y + half, this.formPaint);
                    break;
                }
                case 6: {
                    float formLineWidth = Utils.convertDpToPixel(Float.isNaN(entry.formLineWidth) ? legend.getFormLineWidth() : entry.formLineWidth);
                    DashPathEffect formLineDashEffect = entry.formLineDashEffect == null ? legend.getFormLineDashEffect() : entry.formLineDashEffect;
                    this.formPaint.setStyle(Paint.Style.STROKE);
                    this.formPaint.setStrokeWidth(formLineWidth);
                    this.formPaint.setPathEffect((PathEffect)formLineDashEffect);
                    this.mLineFormPath.reset();
                    this.mLineFormPath.moveTo(x, y);
                    this.mLineFormPath.lineTo(x + formSize, y);
                    c.drawPath(this.mLineFormPath, this.formPaint);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    protected final void drawLabel(@NotNull Canvas c, float x, float y, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        c.drawText(label, x, y, this.labelPaint);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[Legend.LegendHorizontalAlignment.values().length];
            try {
                nArray[Legend.LegendHorizontalAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Legend.LegendVerticalAlignment.values().length];
            try {
                nArray[Legend.LegendVerticalAlignment.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Legend.LegendOrientation.values().length];
            try {
                nArray[Legend.LegendOrientation.HORIZONTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendOrientation.VERTICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[Legend.LegendForm.values().length];
            try {
                nArray[Legend.LegendForm.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendForm.EMPTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendForm.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendForm.CIRCLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendForm.SQUARE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendForm.LINE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

