/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.Fill;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J0\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J#\u0010,\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020\u0010H\u0014J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00128\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00158\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00158\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/github/mikephil/charting/renderer/BarChartRenderer;", "Lcom/github/mikephil/charting/renderer/BarLineScatterCandleBubbleRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "mDrawRoundedBars", "", "mRoundedBarRadius", "", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;ZF)V", "barRect", "Landroid/graphics/RectF;", "barBuffers", "", "Lcom/github/mikephil/charting/buffer/BarBuffer;", "shadowPaint", "Landroid/graphics/Paint;", "barBorderPaint", "drawRoundedBars", "roundedBarRadius", "initBuffers", "", "drawData", "c", "Landroid/graphics/Canvas;", "barShadowRectBuffer", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "index", "", "prepareBarHighlight", "x", "y1", "y2", "barWidthHalf", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "drawValues", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "setHighlightDrawPos", "high", "bar", "drawExtras", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarChartRenderer.kt\ncom/github/mikephil/charting/renderer/BarChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,562:1\n1869#2,2:563\n*S KotlinDebug\n*F\n+ 1 BarChartRenderer.kt\ncom/github/mikephil/charting/renderer/BarChartRenderer\n*L\n62#1:563,2\n*E\n"})
public class BarChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    @JvmField
    @NotNull
    public BarDataProvider chart;
    @JvmField
    @NotNull
    protected RectF barRect;
    @JvmField
    @NotNull
    protected List<BarBuffer> barBuffers;
    @JvmField
    @NotNull
    protected Paint shadowPaint;
    @JvmField
    @NotNull
    protected Paint barBorderPaint;
    private boolean drawRoundedBars;
    private float roundedBarRadius;
    @NotNull
    private final RectF barShadowRectBuffer;

    public BarChartRenderer(@NotNull BarDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.barRect = new RectF();
        this.barBuffers = new ArrayList();
        this.barShadowRectBuffer = new RectF();
        this.setPaintHighlight(new Paint(1));
        this.getPaintHighlight().setStyle(Paint.Style.FILL);
        this.getPaintHighlight().setColor(Color.rgb((int)0, (int)0, (int)0));
        this.getPaintHighlight().setAlpha(120);
        this.shadowPaint = new Paint(1);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.barBorderPaint = new Paint(1);
        this.barBorderPaint.setStyle(Paint.Style.STROKE);
    }

    public BarChartRenderer(@NotNull BarDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler, boolean mDrawRoundedBars, float mRoundedBarRadius) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        this(chart, animator, viewPortHandler);
        this.drawRoundedBars = mDrawRoundedBars;
        this.roundedBarRadius = mRoundedBarRadius;
    }

    @Override
    public void initBuffers() {
        BarData barData = this.chart.getBarData();
        this.barBuffers = new ArrayList();
        List list = barData.getDataSets();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSets(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IBarDataSet it = (IBarDataSet)element$iv;
            boolean bl = false;
            this.barBuffers.add(new BarBuffer(it.getEntryCount() * 4 * (it.isStacked() ? it.getStackSize() : 1), barData.getDataSetCount(), it.isStacked()));
        }
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.barBuffers.size() == 0) {
            this.initBuffers();
        }
        BarData barData = this.chart.getBarData();
        int n = barData.getDataSetCount();
        for (int i = 0; i < n; ++i) {
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(i);
            if (!set.isVisible()) continue;
            Intrinsics.checkNotNull((Object)set);
            this.drawDataSet(c, set, i);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawDataSet(@NotNull Canvas c, @NotNull IBarDataSet dataSet, int index) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        trans = this.chart.getTransformer(dataSet.getAxisDependency());
        this.barBorderPaint.setColor(dataSet.getBarBorderColor());
        this.barBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        phaseX = this.animator.getPhaseX();
        phaseY = this.animator.getPhaseY();
        if (this.chart.isDrawBarShadowEnabled()) {
            this.shadowPaint.setColor(dataSet.getBarShadowColor());
            barData = this.chart.getBarData();
            barWidth = barData.getBarWidth();
            barWidthHalf = barWidth / 2.0f;
            x = 0.0f;
            i = 0;
            count = (int)Math.min((double)((int)Math.ceil((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
            while (i < count) {
                e = (BarEntry)dataSet.getEntryForIndex(i);
                x = e.getX();
                this.barShadowRectBuffer.left = x - barWidthHalf;
                this.barShadowRectBuffer.right = x + barWidthHalf;
                v0 = trans;
                Intrinsics.checkNotNull((Object)v0);
                v0.rectValueToPixel(this.barShadowRectBuffer);
                if (!this.viewPortHandler.isInBoundsLeft(this.barShadowRectBuffer.right)) {
                    ++i;
                    continue;
                }
                if (!this.viewPortHandler.isInBoundsRight(this.barShadowRectBuffer.left)) break;
                this.barShadowRectBuffer.top = this.viewPortHandler.contentTop();
                this.barShadowRectBuffer.bottom = this.viewPortHandler.contentBottom();
                if (this.drawRoundedBars) {
                    c.drawRoundRect(this.barShadowRectBuffer, this.roundedBarRadius, this.roundedBarRadius, this.shadowPaint);
                } else {
                    c.drawRect(this.barShadowRectBuffer, this.shadowPaint);
                }
                ++i;
            }
        }
        v1 = this.barBuffers.get(index);
        Intrinsics.checkNotNull((Object)v1);
        $this$drawDataSet_u24lambda_u241 = barWidth = v1;
        $i$a$-apply-BarChartRenderer$drawDataSet$buffer$1 = false;
        $this$drawDataSet_u24lambda_u241.setPhases(phaseX, phaseY);
        $this$drawDataSet_u24lambda_u241.setDataSet(index);
        $this$drawDataSet_u24lambda_u241.setInverted(this.chart.isInverted(dataSet.getAxisDependency()));
        $this$drawDataSet_u24lambda_u241.setBarWidth(this.chart.getBarData().getBarWidth());
        $this$drawDataSet_u24lambda_u241.feed(dataSet);
        buffer = barWidth;
        v2 = trans;
        Intrinsics.checkNotNull((Object)v2);
        v2.pointValuesToPixel(buffer.buffer);
        if (dataSet.getFills() == null) ** GOTO lbl-1000
        v3 = dataSet.getFills();
        Intrinsics.checkNotNullExpressionValue(v3, (String)"getFills(...)");
        if (((Collection)v3).isEmpty() == false) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isCustomFill = v4;
        isSingleColor = dataSet.getColors().size() == 1;
        isInverted = this.chart.isInverted(dataSet.getAxisDependency());
        if (isSingleColor) {
            this.getPaintRender().setColor(dataSet.getColor());
        }
        j = 0;
        pos = 0;
        while (j < buffer.size()) {
            if (!this.viewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) {
                j += 4;
                ++pos;
                continue;
            }
            if (!this.viewPortHandler.isInBoundsRight(buffer.buffer[j])) break;
            if (!isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColor(pos));
            }
            if (isCustomFill) {
                dataSet.getFill(pos).fillRect(c, this.getPaintRender(), buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], isInverted != false ? Fill.Direction.DOWN : Fill.Direction.UP, this.roundedBarRadius);
            } else if (this.drawRoundedBars) {
                c.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedBarRadius, this.roundedBarRadius, this.getPaintRender());
            } else {
                c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
            }
            if (drawBorder) {
                if (this.drawRoundedBars) {
                    c.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedBarRadius, this.roundedBarRadius, this.barBorderPaint);
                } else {
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.barBorderPaint);
                }
            }
            j += 4;
            ++pos;
        }
    }

    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, @NotNull Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        float left = x - barWidthHalf;
        float right = x + barWidthHalf;
        float top = y1;
        float bottom = y2;
        this.barRect.set(left, top, right, bottom);
        trans.rectToPixelPhase(this.barRect, this.animator.getPhaseY());
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.isDrawingValuesAllowed(this.chart)) {
            List dataSets = this.chart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(4.5f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.chart.isDrawValueAboveBarEnabled();
            int n = this.chart.getBarData().getDataSetCount();
            for (int i = 0; i < n; ++i) {
                IBarDataSet dataSet = (IBarDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
                Intrinsics.checkNotNull((Object)dataSet);
                this.applyValueTextStyle(dataSet);
                boolean isInverted = this.chart.isInverted(dataSet.getAxisDependency());
                float valueTextHeight = Utils.calcTextHeight(this.getPaintValues(), "8");
                posOffset = drawValueAboveBar ? -valueOffsetPlus : valueTextHeight + valueOffsetPlus;
                float f = negOffset = drawValueAboveBar ? valueTextHeight + valueOffsetPlus : -valueOffsetPlus;
                if (isInverted) {
                    posOffset = -posOffset - valueTextHeight;
                    negOffset = -negOffset - valueTextHeight;
                }
                BarBuffer buffer = this.barBuffers.get(i);
                float phaseY = this.animator.getPhaseY();
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                if (!dataSet.isStacked()) {
                    int j = 0;
                    while (true) {
                        float x;
                        float f2 = j;
                        BarBuffer barBuffer = buffer;
                        Intrinsics.checkNotNull((Object)barBuffer);
                        if (f2 < (float)barBuffer.buffer.length * this.animator.getPhaseX() && this.viewPortHandler.isInBoundsRight(x = (buffer.buffer[j] + buffer.buffer[j + 2]) / 2.0f)) {
                            if (!this.viewPortHandler.isInBoundsY(buffer.buffer[j + 1]) || !this.viewPortHandler.isInBoundsLeft(x)) {
                                j += 4;
                                continue;
                            }
                            BarEntry entry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            float val = entry.getY();
                            if (dataSet.isDrawValuesEnabled()) {
                                IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                                Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                                this.drawValue(c, iValueFormatter, val, entry, i, x, val >= 0.0f ? buffer.buffer[j + 1] + posOffset : buffer.buffer[j + 3] + negOffset, dataSet.getValueTextColor(j / 4));
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                Drawable icon = entry.getIcon();
                                float px = x;
                                float py = val >= 0.0f ? buffer.buffer[j + 1] + posOffset : buffer.buffer[j + 3] + negOffset;
                                int n2 = (int)(px += iconsOffset.x);
                                int n3 = (int)(py += iconsOffset.y);
                                Drawable drawable = icon;
                                Intrinsics.checkNotNull((Object)drawable);
                                Utils.drawImage(c, icon, n2, n3, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                            }
                            j += 4;
                            continue;
                        }
                        break;
                    }
                } else {
                    Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
                    int bufferIndex = 0;
                    int index = 0;
                    while ((float)index < (float)dataSet.getEntryCount() * this.animator.getPhaseX()) {
                        BarEntry entry = (BarEntry)dataSet.getEntryForIndex(index);
                        float[] vals = entry.getYVals();
                        BarBuffer barBuffer = buffer;
                        Intrinsics.checkNotNull((Object)barBuffer);
                        float x = (barBuffer.buffer[bufferIndex] + buffer.buffer[bufferIndex + 2]) / 2.0f;
                        int color = dataSet.getValueTextColor(index);
                        if (vals == null) {
                            if (!this.viewPortHandler.isInBoundsRight(x)) break;
                            if (!this.viewPortHandler.isInBoundsY(buffer.buffer[bufferIndex + 1]) || !this.viewPortHandler.isInBoundsLeft(x)) continue;
                            if (dataSet.isDrawValuesEnabled()) {
                                IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                                Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                                this.drawValue(c, iValueFormatter, entry.getY(), entry, i, x, buffer.buffer[bufferIndex + 1] + (entry.getY() >= 0.0f ? posOffset : negOffset), color);
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                Drawable icon = entry.getIcon();
                                float px = x;
                                float py = buffer.buffer[bufferIndex + 1] + (entry.getY() >= 0.0f ? posOffset : negOffset);
                                int n4 = (int)(px += iconsOffset.x);
                                int n5 = (int)(py += iconsOffset.y);
                                Drawable drawable = icon;
                                Intrinsics.checkNotNull((Object)drawable);
                                Utils.drawImage(c, icon, n4, n5, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                            }
                        } else {
                            float[] transformed = new float[vals.length * 2];
                            float posY = 0.0f;
                            float negY = 0.0f;
                            negY = -entry.getNegativeSum();
                            BarChartRenderer $this$drawValues_u24lambda_u242 = this;
                            boolean bl = false;
                            int k = 0;
                            int idx = 0;
                            while (k < transformed.length) {
                                float value = vals[idx];
                                float y = 0.0f;
                                if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                                    y = value;
                                } else if (value >= 0.0f) {
                                    y = posY += value;
                                } else {
                                    y = negY;
                                    negY -= value;
                                }
                                transformed[k + 1] = y * phaseY;
                                k += 2;
                                ++idx;
                            }
                            Transformer transformer = trans;
                            Intrinsics.checkNotNull((Object)transformer);
                            transformer.pointValuesToPixel(transformed);
                            int k2 = 0;
                            while (k2 < transformed.length) {
                                float val = vals[k2 / 2];
                                boolean drawBelow = val == 0.0f && negY == 0.0f && posY > 0.0f || val < 0.0f;
                                float y = transformed[k2 + 1] + (drawBelow ? negOffset : posOffset);
                                if (!this.viewPortHandler.isInBoundsRight(x)) break;
                                if (!this.viewPortHandler.isInBoundsY(y) || !this.viewPortHandler.isInBoundsLeft(x)) {
                                    k2 += 2;
                                    continue;
                                }
                                if (dataSet.isDrawValuesEnabled()) {
                                    IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                                    Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                                    this.drawValue(c, iValueFormatter, vals[k2 / 2], entry, i, x, y, color);
                                }
                                if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                    Drawable icon = entry.getIcon();
                                    int n6 = (int)(x + iconsOffset.x);
                                    int n7 = (int)(y + iconsOffset.y);
                                    Drawable drawable = icon;
                                    Intrinsics.checkNotNull((Object)drawable);
                                    Utils.drawImage(c, icon, n6, n7, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                                }
                                k2 += 2;
                            }
                        }
                        bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                        ++index;
                    }
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        BarData barData = this.chart.getBarData();
        for (Highlight high : indices) {
            BarEntry e;
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (BarEntry)set.getEntryForXValue(high.getX(), high.getY()), set)) continue;
            Transformer trans = this.chart.getTransformer(set.getAxisDependency());
            this.getPaintHighlight().setColor(set.getHighLightColor());
            this.getPaintHighlight().setAlpha(set.getHighLightAlpha());
            boolean isStack = high.getStackIndex() >= 0 && e.isStacked();
            float y1 = 0.0f;
            float y2 = 0.0f;
            if (isStack) {
                if (this.chart.isHighlightFullBarEnabled()) {
                    y1 = e.getPositiveSum();
                    y2 = -e.getNegativeSum();
                } else {
                    Range range = e.getRanges()[high.getStackIndex()];
                    y1 = range.from;
                    y2 = range.to;
                }
            } else {
                y1 = e.getY();
                y2 = 0.0f;
            }
            float f = e.getX();
            float f2 = barData.getBarWidth() / 2.0f;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            this.prepareBarHighlight(f, y1, y2, f2, transformer);
            this.setHighlightDrawPos(high, this.barRect);
            if (this.drawRoundedBars) {
                c.drawRoundRect(new RectF(this.barRect), this.roundedBarRadius, this.roundedBarRadius, this.getPaintHighlight());
                continue;
            }
            c.drawRect(this.barRect, this.getPaintHighlight());
        }
    }

    protected void setHighlightDrawPos(@NotNull Highlight high, @NotNull RectF bar) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        high.setDraw(bar.centerX(), bar.top);
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }
}

