/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/github/mikephil/charting/buffer/HorizontalBarBuffer;", "Lcom/github/mikephil/charting/buffer/BarBuffer;", "size", "", "dataSetCount", "containsStacks", "", "<init>", "(IIZ)V", "feed", "", "data", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "MPChartLib_release"})
public final class HorizontalBarBuffer
extends BarBuffer {
    public HorizontalBarBuffer(int size, int dataSetCount, boolean containsStacks) {
        super(size, dataSetCount, containsStacks);
    }

    @Override
    public void feed(@Nullable IBarDataSet data) {
        IBarDataSet iBarDataSet = data;
        float size = (float)(iBarDataSet != null ? iBarDataSet.getEntryCount() : 0) * this.phaseX;
        float barWidthHalf = this.barWidth / 2.0f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e;
            IBarDataSet iBarDataSet2 = data;
            BarEntry barEntry = e = iBarDataSet2 != null ? (BarEntry)iBarDataSet2.getEntryForIndex(i) : null;
            if (e == null) {
                ++i;
                continue;
            }
            float x = e.getX();
            float y = e.getY();
            float[] vals = e.getYVals();
            if (!this.containsStacks || vals == null) {
                float bottom = x - barWidthHalf;
                float top = x + barWidthHalf;
                float left = 0.0f;
                float right = 0.0f;
                if (this.inverted) {
                    left = y >= 0.0f ? y : 0.0f;
                    right = y <= 0.0f ? y : 0.0f;
                } else {
                    right = y >= 0.0f ? y : 0.0f;
                    float f = left = y <= 0.0f ? y : 0.0f;
                }
                if (right > 0.0f) {
                    right *= this.phaseY;
                } else {
                    left *= this.phaseY;
                }
                this.addBar(left, top, right, bottom);
            } else {
                float posY = 0.0f;
                float negY = -e.getNegativeSum();
                float yStart = 0.0f;
                for (float value : vals) {
                    if (value >= 0.0f) {
                        y = posY;
                        posY = yStart = posY + value;
                    } else {
                        y = negY;
                        yStart = (float)((double)negY + Math.abs((double)value));
                        negY += (float)Math.abs((double)value);
                    }
                    float bottom = x - barWidthHalf;
                    float top = x + barWidthHalf;
                    float left = 0.0f;
                    float right = 0.0f;
                    if (this.inverted) {
                        left = y >= yStart ? y : yStart;
                        right = y <= yStart ? y : yStart;
                    } else {
                        right = y >= yStart ? y : yStart;
                        left = y <= yStart ? y : yStart;
                    }
                    this.addBar(left *= this.phaseY, top, right *= this.phaseY, bottom);
                }
            }
            ++i;
        }
        this.reset();
    }
}

