/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J(\u0010#\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u000bH\u0014J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/github/mikephil/charting/renderer/XAxisRendererHorizontalBarChart;", "Lcom/github/mikephil/charting/renderer/XAxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "xAxis", "Lcom/github/mikephil/charting/components/XAxis;", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/XAxis;Lcom/github/mikephil/charting/utils/Transformer;)V", "renderLimitLinesPathBuffer", "Landroid/graphics/Path;", "getRenderLimitLinesPathBuffer", "()Landroid/graphics/Path;", "setRenderLimitLinesPathBuffer", "(Landroid/graphics/Path;)V", "computeAxis", "", "min", "", "max", "inverted", "", "computeSize", "renderAxisLabels", "c", "Landroid/graphics/Canvas;", "drawLabels", "pos", "anchor", "Lcom/github/mikephil/charting/utils/MPPointF;", "gridClippingRect", "Landroid/graphics/RectF;", "getGridClippingRect", "()Landroid/graphics/RectF;", "drawGridLine", "x", "y", "gridLinePath", "renderAxisLine", "renderLimitLines", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nXAxisRendererHorizontalBarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XAxisRendererHorizontalBarChart.kt\ncom/github/mikephil/charting/renderer/XAxisRendererHorizontalBarChart\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,293:1\n27#2,7:294\n*S KotlinDebug\n*F\n+ 1 XAxisRendererHorizontalBarChart.kt\ncom/github/mikephil/charting/renderer/XAxisRendererHorizontalBarChart\n*L\n216#1:294,7\n*E\n"})
public class XAxisRendererHorizontalBarChart
extends XAxisRenderer {
    @NotNull
    private Path renderLimitLinesPathBuffer;

    public XAxisRendererHorizontalBarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @Nullable Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        super(viewPortHandler, xAxis, trans);
        this.renderLimitLinesPathBuffer = new Path();
    }

    @NotNull
    protected final Path getRenderLimitLinesPathBuffer() {
        return this.renderLimitLinesPathBuffer;
    }

    protected final void setRenderLimitLinesPathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.renderLimitLinesPathBuffer = path;
    }

    @Override
    public void computeAxis(float min, float max, boolean inverted) {
        float minLocal = min;
        float maxLocal = max;
        if (this.viewPortHandler.contentWidth() > 10.0f && !this.viewPortHandler.isFullyZoomedOutY()) {
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD p1 = transformer.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentBottom());
            Transformer transformer2 = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer2);
            MPPointD p2 = transformer2.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop());
            if (inverted) {
                minLocal = (float)p2.y;
                maxLocal = (float)p1.y;
            } else {
                minLocal = (float)p1.y;
                maxLocal = (float)p2.y;
            }
            MPPointD.recycleInstance(p1);
            MPPointD.recycleInstance(p2);
        }
        this.computeAxisValues(minLocal, maxLocal);
    }

    @Override
    protected void computeSize() {
        Paint paint = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint);
        paint.setTypeface(this.xAxis.getTypeface());
        Paint paint2 = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint2);
        paint2.setTextSize(this.xAxis.getTextSize());
        String longest = this.xAxis.getLongestLabel();
        FSize labelSize = Utils.calcTextSize(this.getPaintAxisLabels(), longest);
        float labelWidth = (int)(labelSize.width + this.xAxis.getXOffset() * 3.5f);
        float labelHeight = labelSize.height;
        FSize labelRotatedSize = Utils.getSizeOfRotatedRectangleByDegrees(labelWidth, labelHeight, this.xAxis.getLabelRotationAngle());
        this.xAxis.mLabelWidth = Math.round(labelRotatedSize.width);
        this.xAxis.mLabelHeight = Math.round(labelRotatedSize.height);
        FSize.recycleInstance(labelRotatedSize);
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.xAxis.isEnabled() || !this.xAxis.isDrawLabelsEnabled()) {
            return;
        }
        float xOffset = this.xAxis.getXOffset();
        Paint paint = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint);
        paint.setTypeface(this.xAxis.getTypeface());
        Paint paint2 = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint2);
        paint2.setTextSize(this.xAxis.getTextSize());
        Paint paint3 = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint3);
        paint3.setColor(this.xAxis.getTextColor());
        MPPointF pointF = MPPointF.getInstance(0.0f, 0.0f);
        XAxis.XAxisPosition xAxisPosition = this.xAxis.getPosition();
        switch (xAxisPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[xAxisPosition.ordinal()]) {
            case 1: {
                pointF.x = 0.0f;
                pointF.y = 0.5f;
                this.drawLabels(c, this.viewPortHandler.contentRight() + xOffset, pointF);
                break;
            }
            case 2: {
                pointF.x = 1.0f;
                pointF.y = 0.5f;
                this.drawLabels(c, this.viewPortHandler.contentRight() - xOffset, pointF);
                break;
            }
            case 3: {
                pointF.x = 1.0f;
                pointF.y = 0.5f;
                this.drawLabels(c, this.viewPortHandler.contentLeft() - xOffset, pointF);
                break;
            }
            case 4: {
                pointF.x = 1.0f;
                pointF.y = 0.5f;
                this.drawLabels(c, this.viewPortHandler.contentLeft() + xOffset, pointF);
                break;
            }
            default: {
                pointF.x = 0.0f;
                pointF.y = 0.5f;
                this.drawLabels(c, this.viewPortHandler.contentRight() + xOffset, pointF);
                pointF.x = 1.0f;
                pointF.y = 0.5f;
                this.drawLabels(c, this.viewPortHandler.contentLeft() - xOffset, pointF);
            }
        }
        MPPointF.recycleInstance(pointF);
    }

    @Override
    protected void drawLabels(@Nullable Canvas c, float pos, @Nullable MPPointF anchor) {
        float labelRotationAngleDegrees = this.xAxis.getLabelRotationAngle();
        boolean centeringEnabled = this.xAxis.isCenterAxisLabelsEnabled();
        float[] positions = new float[this.xAxis.mEntryCount * 2];
        XAxisRendererHorizontalBarChart $this$drawLabels_u24lambda_u240 = this;
        boolean bl = false;
        for (int i = 0; i < positions.length; i += 2) {
            positions[i + 1] = centeringEnabled ? $this$drawLabels_u24lambda_u240.xAxis.mCenteredEntries[i / 2] : $this$drawLabels_u24lambda_u240.xAxis.mEntries[i / 2];
        }
        Transformer transformer = this.getTransformer();
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(positions);
        for (int i = 0; i < positions.length; i += 2) {
            float y = positions[i + 1];
            if (!this.viewPortHandler.isInBoundsY(y)) continue;
            String label = this.xAxis.getValueFormatter().getFormattedValue(this.xAxis.mEntries[i / 2], this.xAxis);
            this.drawLabel(c, label, pos, y, anchor, labelRotationAngleDegrees);
        }
    }

    @Override
    @NotNull
    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.viewPortHandler.getContentRect());
        this.mGridClippingRect.inset(0.0f, -this.axis.getGridLineWidth());
        return this.mGridClippingRect;
    }

    @Override
    protected void drawGridLine(@NotNull Canvas c, float x, float y, @NotNull Path gridLinePath) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)gridLinePath, (String)"gridLinePath");
        gridLinePath.moveTo(this.viewPortHandler.contentRight(), y);
        gridLinePath.lineTo(this.viewPortHandler.contentLeft(), y);
        Paint paint = this.getPaintGrid();
        Intrinsics.checkNotNull((Object)paint);
        c.drawPath(gridLinePath, paint);
        gridLinePath.reset();
    }

    @Override
    public void renderAxisLine(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.xAxis.isDrawAxisLineEnabled() || !this.xAxis.isEnabled()) {
            return;
        }
        Paint paint = this.getPaintAxisLine();
        Intrinsics.checkNotNull((Object)paint);
        paint.setColor(this.xAxis.getAxisLineColor());
        Paint paint2 = this.getPaintAxisLine();
        Intrinsics.checkNotNull((Object)paint2);
        paint2.setStrokeWidth(this.xAxis.getAxisLineWidth());
        if (this.xAxis.getPosition() == XAxis.XAxisPosition.TOP || this.xAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            float f = this.viewPortHandler.contentRight();
            float f2 = this.viewPortHandler.contentTop();
            float f3 = this.viewPortHandler.contentRight();
            float f4 = this.viewPortHandler.contentBottom();
            Paint paint3 = this.getPaintAxisLine();
            Intrinsics.checkNotNull((Object)paint3);
            c.drawLine(f, f2, f3, f4, paint3);
        }
        if (this.xAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            float f = this.viewPortHandler.contentLeft();
            float f5 = this.viewPortHandler.contentTop();
            float f6 = this.viewPortHandler.contentLeft();
            float f7 = this.viewPortHandler.contentBottom();
            Paint paint4 = this.getPaintAxisLine();
            Intrinsics.checkNotNull((Object)paint4);
            c.drawLine(f, f5, f6, f7, paint4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLimitLines(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        List<LimitLine> limitLines = this.xAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] pts = this.mRenderLimitLinesBuffer;
        pts[0] = 0.0f;
        pts[1] = 0.0f;
        Path limitLinePath = this.renderLimitLinesPathBuffer;
        limitLinePath.reset();
        int n = ((Collection)limitLines).size();
        for (int i = 0; i < n; ++i) {
            LimitLine l = limitLines.get(i);
            if (!l.isEnabled()) continue;
            Canvas $this$withSave$iv = c;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                LimitLine.LimitLabelPosition position;
                Canvas $this$renderLimitLines_u24lambda_u241 = $this$withSave$iv;
                boolean bl = false;
                this.mLimitLineClippingRect.set(this.viewPortHandler.getContentRect());
                this.mLimitLineClippingRect.inset(0.0f, -l.getLineWidth());
                c.clipRect(this.mLimitLineClippingRect);
                Paint paint = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint);
                paint.setStyle(Paint.Style.STROKE);
                Paint paint2 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint2);
                paint2.setColor(l.getLineColor());
                Paint paint3 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint3);
                paint3.setStrokeWidth(l.getLineWidth());
                Paint paint4 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint4);
                paint4.setPathEffect((PathEffect)l.getDashPathEffect());
                pts[1] = l.getLimit();
                Transformer transformer = this.getTransformer();
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(pts);
                limitLinePath.moveTo(this.viewPortHandler.contentLeft(), pts[1]);
                limitLinePath.lineTo(this.viewPortHandler.contentRight(), pts[1]);
                Paint paint5 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint5);
                c.drawPath(limitLinePath, paint5);
                limitLinePath.reset();
                String label = l.getLabel();
                if (label == null || Intrinsics.areEqual((Object)label, (Object)"")) continue;
                Paint paint6 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint6);
                paint6.setStyle(l.getTextStyle());
                Paint paint7 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint7);
                paint7.setPathEffect(null);
                Paint paint8 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint8);
                paint8.setColor(l.getTextColor());
                Paint paint9 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint9);
                paint9.setStrokeWidth(0.5f);
                Paint paint10 = this.limitLinePaint;
                Intrinsics.checkNotNull((Object)paint10);
                paint10.setTextSize(l.getTextSize());
                float labelLineHeight = Utils.calcTextHeight(this.limitLinePaint, label);
                float xOffset = Utils.convertDpToPixel(4.0f) + l.getXOffset();
                float yOffset = l.getLineWidth() + labelLineHeight + l.getYOffset();
                LimitLine.LimitLabelPosition limitLabelPosition = position = l.getLabelPosition();
                switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$1[limitLabelPosition.ordinal()]) {
                    case 1: {
                        Paint paint11 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint11);
                        paint11.setTextAlign(Paint.Align.RIGHT);
                        float f = this.viewPortHandler.contentRight() - xOffset;
                        float f2 = pts[1] - yOffset + labelLineHeight;
                        Paint paint12 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint12);
                        c.drawText(label, f, f2, paint12);
                        break;
                    }
                    case 2: {
                        Paint paint13 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint13);
                        paint13.setTextAlign(Paint.Align.RIGHT);
                        float f = this.viewPortHandler.contentRight() - xOffset;
                        float f3 = pts[1] + yOffset;
                        Paint paint14 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint14);
                        c.drawText(label, f, f3, paint14);
                        break;
                    }
                    case 3: {
                        Paint paint15 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint15);
                        paint15.setTextAlign(Paint.Align.LEFT);
                        float f = this.viewPortHandler.contentLeft() + xOffset;
                        float f4 = pts[1] - yOffset + labelLineHeight;
                        Paint paint16 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint16);
                        c.drawText(label, f, f4, paint16);
                        break;
                    }
                    default: {
                        Paint paint17 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint17);
                        paint17.setTextAlign(Paint.Align.LEFT);
                        float f = this.viewPortHandler.offsetLeft() + xOffset;
                        float f5 = pts[1] + yOffset;
                        Paint paint18 = this.limitLinePaint;
                        Intrinsics.checkNotNull((Object)paint18);
                        c.drawText(label, f, f5, paint18);
                    }
                }
                continue;
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[XAxis.XAxisPosition.values().length];
            try {
                nArray[XAxis.XAxisPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.TOP_INSIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LimitLine.LimitLabelPosition.values().length];
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.LEFT_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

