/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0004J\b\u0010 \u001a\u00020\u001dH&J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H&J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H&JH\u0010%\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020,J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H&J#\u00101\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H&\u00a2\u0006\u0002\u00105R\u0012\u0010\u0002\u001a\u00020\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR$\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u00066"}, d2={"Lcom/github/mikephil/charting/renderer/DataRenderer;", "Lcom/github/mikephil/charting/renderer/Renderer;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "value", "Landroid/graphics/Paint;", "paintRender", "getPaintRender", "()Landroid/graphics/Paint;", "setPaintRender", "(Landroid/graphics/Paint;)V", "paintHighlight", "getPaintHighlight", "setPaintHighlight", "drawPaint", "getDrawPaint", "setDrawPaint", "paintValues", "getPaintValues", "setPaintValues", "isDrawingValuesAllowed", "", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/ChartInterface;", "applyValueTextStyle", "", "set", "Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "initBuffers", "drawData", "c", "Landroid/graphics/Canvas;", "drawValues", "drawValue", "formatter", "Lcom/github/mikephil/charting/formatter/IValueFormatter;", "", "entry", "Lcom/github/mikephil/charting/data/Entry;", "dataSetIndex", "", "x", "y", "color", "drawExtras", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "MPChartLib_release"})
public abstract class DataRenderer
extends Renderer {
    @JvmField
    @NotNull
    protected ChartAnimator animator;
    @NotNull
    private Paint paintRender;
    @NotNull
    private Paint paintHighlight;
    @NotNull
    private Paint drawPaint;
    @NotNull
    private Paint paintValues;

    public DataRenderer(@NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(viewPortHandler);
        this.animator = animator;
        this.paintRender = new Paint(1);
        this.paintRender.setStyle(Paint.Style.FILL);
        this.drawPaint = new Paint(4);
        this.paintValues = new Paint(1);
        this.paintValues.setColor(Color.rgb((int)63, (int)63, (int)63));
        this.paintValues.setTextAlign(Paint.Align.CENTER);
        this.paintValues.setTextSize(Utils.convertDpToPixel(9.0f));
        this.paintHighlight = new Paint(1);
        this.paintHighlight.setStyle(Paint.Style.STROKE);
        this.paintHighlight.setStrokeWidth(2.0f);
        this.paintHighlight.setColor(Color.rgb((int)255, (int)187, (int)115));
    }

    @NotNull
    public final Paint getPaintRender() {
        return this.paintRender;
    }

    protected final void setPaintRender(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintRender = paint;
    }

    @NotNull
    public final Paint getPaintHighlight() {
        return this.paintHighlight;
    }

    protected final void setPaintHighlight(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintHighlight = paint;
    }

    @NotNull
    protected final Paint getDrawPaint() {
        return this.drawPaint;
    }

    protected final void setDrawPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.drawPaint = paint;
    }

    @NotNull
    public final Paint getPaintValues() {
        return this.paintValues;
    }

    protected final void setPaintValues(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintValues = paint;
    }

    protected boolean isDrawingValuesAllowed(@NotNull ChartInterface chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        ChartData chartData = chart.getData();
        Intrinsics.checkNotNull((Object)chartData);
        return (float)chartData.getEntryCount() < (float)chart.getMaxVisibleCount() * this.viewPortHandler.getScaleX();
    }

    protected final void applyValueTextStyle(@NotNull IDataSet<?> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.paintValues.setTypeface(set.getValueTypeface());
        this.paintValues.setTextSize(set.getValueTextSize());
    }

    public abstract void initBuffers();

    public abstract void drawData(@NotNull Canvas var1);

    public abstract void drawValues(@NotNull Canvas var1);

    public final void drawValue(@NotNull Canvas c, @NotNull IValueFormatter formatter, float value, @Nullable Entry entry, int dataSetIndex, float x, float y, int color) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        this.paintValues.setColor(color);
        String string = formatter.getFormattedValue(value, entry, dataSetIndex, this.viewPortHandler);
        Intrinsics.checkNotNull((Object)string);
        c.drawText(string, x, y, this.paintValues);
    }

    public abstract void drawExtras(@NotNull Canvas var1);

    public abstract void drawHighlighted(@NotNull Canvas var1, @NotNull Highlight[] var2);
}

