/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.BubbleChartRenderer;
import com.github.mikephil.charting.renderer.CandleStickChartRenderer;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.renderer.ScatterChartRenderer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J#\u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)J\u0014\u0010-\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\r\u00a8\u0006/"}, d2={"Lcom/github/mikephil/charting/renderer/CombinedChartRenderer;", "Lcom/github/mikephil/charting/renderer/DataRenderer;", "chart", "Lcom/github/mikephil/charting/charts/CombinedChart;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/charts/CombinedChart;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "dataRenderers", "", "getDataRenderers", "()Ljava/util/List;", "setDataRenderers", "(Ljava/util/List;)V", "weakChart", "Ljava/lang/ref/WeakReference;", "Lcom/github/mikephil/charting/charts/Chart;", "getWeakChart", "()Ljava/lang/ref/WeakReference;", "setWeakChart", "(Ljava/lang/ref/WeakReference;)V", "createRenderers", "", "initBuffers", "drawData", "c", "Landroid/graphics/Canvas;", "drawValues", "drawExtras", "mHighlightBuffer", "Lcom/github/mikephil/charting/highlight/Highlight;", "getMHighlightBuffer", "setMHighlightBuffer", "drawHighlighted", "indices", "", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "getSubRenderer", "index", "", "subRenderers", "", "getSubRenderers", "setSubRenderers", "renderers", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nCombinedChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedChartRenderer.kt\ncom/github/mikephil/charting/renderer/CombinedChartRenderer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,120:1\n37#2:121\n36#2,3:122\n*S KotlinDebug\n*F\n+ 1 CombinedChartRenderer.kt\ncom/github/mikephil/charting/renderer/CombinedChartRenderer\n*L\n93#1:121\n93#1:122,3\n*E\n"})
public class CombinedChartRenderer
extends DataRenderer {
    @NotNull
    private List<DataRenderer> dataRenderers;
    @NotNull
    private WeakReference<Chart<?>> weakChart;
    @NotNull
    private List<Highlight> mHighlightBuffer;

    public CombinedChartRenderer(@NotNull CombinedChart chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataRenderers = new ArrayList(5);
        this.weakChart = new WeakReference<CombinedChart>(chart);
        this.mHighlightBuffer = new ArrayList();
        this.createRenderers();
    }

    @NotNull
    protected final List<DataRenderer> getDataRenderers() {
        return this.dataRenderers;
    }

    protected final void setDataRenderers(@NotNull List<DataRenderer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataRenderers = list;
    }

    @NotNull
    protected final WeakReference<Chart<?>> getWeakChart() {
        return this.weakChart;
    }

    protected final void setWeakChart(@NotNull WeakReference<Chart<?>> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.weakChart = weakReference;
    }

    public final void createRenderers() {
        this.dataRenderers.clear();
        CombinedChart combinedChart = (CombinedChart)this.weakChart.get();
        if (combinedChart == null) {
            return;
        }
        CombinedChart chart = combinedChart;
        CombinedChart.DrawOrder[] orders = chart.getDrawOrder();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])orders);
        block7: while (iterator.hasNext()) {
            CombinedChart.DrawOrder order;
            CombinedChart.DrawOrder drawOrder = order = (CombinedChart.DrawOrder)((Object)iterator.next());
            switch (drawOrder == null ? -1 : WhenMappings.$EnumSwitchMapping$0[drawOrder.ordinal()]) {
                case 1: {
                    if (chart.getBarData() == null) continue block7;
                    this.dataRenderers.add(new BarChartRenderer(chart, this.animator, this.viewPortHandler));
                    continue block7;
                }
                case 2: {
                    if (chart.getBubbleData() == null) continue block7;
                    this.dataRenderers.add(new BubbleChartRenderer(chart, this.animator, this.viewPortHandler));
                    continue block7;
                }
                case 3: {
                    this.dataRenderers.add(new LineChartRenderer(chart, this.animator, this.viewPortHandler));
                    continue block7;
                }
                case 4: {
                    if (chart.getCandleData() == null) continue block7;
                    this.dataRenderers.add(new CandleStickChartRenderer(chart, this.animator, this.viewPortHandler));
                    continue block7;
                }
                case 5: {
                    if (chart.getScatterData() == null) continue block7;
                    this.dataRenderers.add(new ScatterChartRenderer(chart, this.animator, this.viewPortHandler));
                    continue block7;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.initBuffers();
        }
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.drawData(c);
        }
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.drawValues(c);
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        for (DataRenderer renderer : this.dataRenderers) {
            renderer.drawExtras(c);
        }
    }

    @NotNull
    protected final List<Highlight> getMHighlightBuffer() {
        return this.mHighlightBuffer;
    }

    protected final void setMHighlightBuffer(@NotNull List<Highlight> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mHighlightBuffer = list;
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        Chart chart = (Chart)this.weakChart.get();
        if (chart == null) {
            return;
        }
        Chart chart2 = chart;
        for (DataRenderer renderer : this.dataRenderers) {
            int n;
            ChartData data = null;
            if (renderer instanceof BarChartRenderer) {
                data = ((BarChartRenderer)renderer).chart.getBarData();
            } else if (renderer instanceof LineChartRenderer) {
                data = ((LineChartRenderer)renderer).chart.getLineData();
            } else if (renderer instanceof CandleStickChartRenderer) {
                data = ((CandleStickChartRenderer)renderer).chart.getCandleData();
            } else if (renderer instanceof ScatterChartRenderer) {
                data = ((ScatterChartRenderer)renderer).chart.getScatterData();
            } else if (renderer instanceof BubbleChartRenderer) {
                data = ((BubbleChartRenderer)renderer).chart.getBubbleData();
            }
            if (data == null) {
                n = -1;
            } else {
                Object t = chart2.getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.github.mikephil.charting.data.CombinedData");
                List<BarLineScatterCandleBubbleData> list = ((CombinedData)t).getAllData();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAllData(...)");
                n = CollectionsKt.indexOf(list, (Object)data);
            }
            int dataIndex = n;
            this.mHighlightBuffer.clear();
            for (Highlight h : indices) {
                if (h.getDataIndex() != dataIndex && h.getDataIndex() != -1) continue;
                this.mHighlightBuffer.add(h);
            }
            Collection $this$toTypedArray$iv = this.mHighlightBuffer;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            renderer.drawHighlighted(c, thisCollection$iv.toArray(new Highlight[0]));
        }
    }

    @Nullable
    public final DataRenderer getSubRenderer(int index) {
        return index >= this.dataRenderers.size() || index < 0 ? null : this.dataRenderers.get(index);
    }

    @NotNull
    public final List<DataRenderer> getSubRenderers() {
        return this.dataRenderers;
    }

    public final void setSubRenderers(@NotNull List<DataRenderer> renderers) {
        Intrinsics.checkNotNullParameter(renderers, (String)"renderers");
        this.dataRenderers = renderers;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CombinedChart.DrawOrder.values().length];
            try {
                nArray[CombinedChart.DrawOrder.BAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.BUBBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.CANDLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CombinedChart.DrawOrder.SCATTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

