/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.mikephil.charting.utils.Utils;

public class Fill {
    private Type mType = Type.EMPTY;
    @Nullable
    private Integer mColor = null;
    private Integer mFinalColor = null;
    @Nullable
    protected Drawable mDrawable;
    @Nullable
    private int[] mGradientColors;
    @Nullable
    private float[] mGradientPositions;
    private int mAlpha = 255;

    public Fill() {
    }

    public Fill(int color) {
        this.mType = Type.COLOR;
        this.mColor = color;
        this.calculateFinalColor();
    }

    public Fill(int startColor, int endColor) {
        this.mType = Type.LINEAR_GRADIENT;
        this.mGradientColors = new int[]{startColor, endColor};
    }

    public Fill(@NonNull int[] gradientColors) {
        this.mType = Type.LINEAR_GRADIENT;
        this.mGradientColors = gradientColors;
    }

    public Fill(@NonNull int[] gradientColors, @NonNull float[] gradientPositions) {
        this.mType = Type.LINEAR_GRADIENT;
        this.mGradientColors = gradientColors;
        this.mGradientPositions = gradientPositions;
    }

    public Fill(@NonNull Drawable drawable) {
        this.mType = Type.DRAWABLE;
        this.mDrawable = drawable;
    }

    public Type getType() {
        return this.mType;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    @Nullable
    public Integer getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.calculateFinalColor();
    }

    public int[] getGradientColors() {
        return this.mGradientColors;
    }

    public void setGradientColors(int[] colors) {
        this.mGradientColors = colors;
    }

    public float[] getGradientPositions() {
        return this.mGradientPositions;
    }

    public void setGradientPositions(float[] positions) {
        this.mGradientPositions = positions;
    }

    public void setGradientColors(int startColor, int endColor) {
        this.mGradientColors = new int[]{startColor, endColor};
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
        this.calculateFinalColor();
    }

    private void calculateFinalColor() {
        if (this.mColor == null) {
            this.mFinalColor = null;
        } else {
            int alpha = (int)Math.floor((double)(this.mColor >> 24) / 255.0 * ((double)this.mAlpha / 255.0) * 255.0);
            this.mFinalColor = alpha << 24 | this.mColor & 0xFFFFFF;
        }
    }

    public void fillRect(Canvas c, Paint paint, float left, float top, float right, float bottom, Direction gradientDirection, float mRoundedBarRadius) {
        switch (this.mType) {
            case EMPTY: {
                return;
            }
            case COLOR: {
                if (this.mFinalColor == null) {
                    return;
                }
                if (this.isClipPathSupported()) {
                    int save = c.save();
                    c.clipRect(left, top, right, bottom);
                    c.drawColor(this.mFinalColor.intValue());
                    c.restoreToCount(save);
                    break;
                }
                Paint.Style previous = paint.getStyle();
                int previousColor = paint.getColor();
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(this.mFinalColor.intValue());
                c.drawRoundRect(new RectF(left, top, right, bottom), mRoundedBarRadius, mRoundedBarRadius, paint);
                paint.setColor(previousColor);
                paint.setStyle(previous);
                break;
            }
            case LINEAR_GRADIENT: {
                if (this.mGradientColors == null) {
                    return;
                }
                LinearGradient gradient = new LinearGradient((float)((int)(gradientDirection == Direction.RIGHT ? right : (gradientDirection == Direction.LEFT ? left : left))), (float)((int)(gradientDirection == Direction.UP ? bottom : (gradientDirection == Direction.DOWN ? top : top))), (float)((int)(gradientDirection == Direction.RIGHT ? left : (gradientDirection == Direction.LEFT ? right : left))), (float)((int)(gradientDirection == Direction.UP ? top : (gradientDirection == Direction.DOWN ? bottom : top))), this.mGradientColors, this.mGradientPositions, Shader.TileMode.MIRROR);
                paint.setShader((Shader)gradient);
                c.drawRoundRect(new RectF(left, top, right, bottom), mRoundedBarRadius, mRoundedBarRadius, paint);
                break;
            }
            case DRAWABLE: {
                if (this.mDrawable == null) {
                    return;
                }
                this.mDrawable.setBounds((int)left, (int)top, (int)right, (int)bottom);
                this.mDrawable.draw(c);
            }
        }
    }

    public void fillPath(Canvas c, Path path, Paint paint, @Nullable RectF clipRect) {
        switch (this.mType) {
            case EMPTY: {
                return;
            }
            case COLOR: {
                if (this.mFinalColor == null) {
                    return;
                }
                if (clipRect != null && this.isClipPathSupported()) {
                    int save = c.save();
                    c.clipPath(path);
                    c.drawColor(this.mFinalColor.intValue());
                    c.restoreToCount(save);
                    break;
                }
                Paint.Style previous = paint.getStyle();
                int previousColor = paint.getColor();
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(this.mFinalColor.intValue());
                c.drawPath(path, paint);
                paint.setColor(previousColor);
                paint.setStyle(previous);
                break;
            }
            case LINEAR_GRADIENT: {
                if (this.mGradientColors == null) {
                    return;
                }
                LinearGradient gradient = new LinearGradient(0.0f, 0.0f, (float)c.getWidth(), (float)c.getHeight(), this.mGradientColors, this.mGradientPositions, Shader.TileMode.MIRROR);
                paint.setShader((Shader)gradient);
                c.drawPath(path, paint);
                break;
            }
            case DRAWABLE: {
                if (this.mDrawable == null) {
                    return;
                }
                this.ensureClipPathSupported();
                int save = c.save();
                c.clipPath(path);
                this.mDrawable.setBounds(clipRect == null ? 0 : (int)clipRect.left, clipRect == null ? 0 : (int)clipRect.top, clipRect == null ? c.getWidth() : (int)clipRect.right, clipRect == null ? c.getHeight() : (int)clipRect.bottom);
                this.mDrawable.draw(c);
                c.restoreToCount(save);
            }
        }
    }

    private boolean isClipPathSupported() {
        return Utils.getSDKInt() >= 18;
    }

    private void ensureClipPathSupported() {
        if (Utils.getSDKInt() < 18) {
            throw new RuntimeException("Fill-drawables not (yet) supported below API level 18, this code was run on API level " + Utils.getSDKInt() + ".");
        }
    }

    public static enum Type {
        EMPTY,
        COLOR,
        LINEAR_GRADIENT,
        DRAWABLE;

    }

    public static enum Direction {
        DOWN,
        UP,
        RIGHT,
        LEFT;

    }
}

