/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.IHighlighter;
import java.util.ArrayList;
import java.util.List;

public abstract class PieRadarHighlighter<T extends PieRadarChartBase>
implements IHighlighter {
    protected T mChart;
    protected List<Highlight> mHighlightBuffer = new ArrayList<Highlight>();

    public PieRadarHighlighter(T chart) {
        this.mChart = chart;
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        int index;
        float touchDistanceToCenter = ((PieRadarChartBase)this.mChart).distanceToCenter(x, y);
        if (touchDistanceToCenter > ((PieRadarChartBase)this.mChart).getRadius()) {
            return null;
        }
        float angle = ((PieRadarChartBase)this.mChart).getAngleForPoint(x, y);
        if (this.mChart instanceof PieChart) {
            angle /= ((Chart)this.mChart).getAnimator().getPhaseY();
        }
        if ((index = ((PieRadarChartBase)this.mChart).getIndexForAngle(angle)) < 0 || index >= ((ChartData)((Chart)this.mChart).getData()).getMaxEntryCountSet().getEntryCount()) {
            return null;
        }
        return this.getClosestHighlight(index, x, y);
    }

    protected abstract Highlight getClosestHighlight(int var1, float var2, float var3);
}

