/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.formatter.ValueFormatter;
import java.text.DecimalFormat;

public class LargeValueFormatter
extends ValueFormatter {
    private String[] mSuffix = new String[]{"", "k", "m", "b", "t"};
    private int mMaxLength = 5;
    private DecimalFormat mFormat = new DecimalFormat("###E00");
    private String mText = "";

    public LargeValueFormatter() {
    }

    public LargeValueFormatter(String appendix) {
        this();
        this.mText = appendix;
    }

    @Override
    public String getFormattedValue(float value) {
        return this.makePretty(value) + this.mText;
    }

    public void setAppendix(String appendix) {
        this.mText = appendix;
    }

    public void setSuffix(String[] suffix) {
        this.mSuffix = suffix;
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
    }

    private String makePretty(double number) {
        String r = this.mFormat.format(number);
        int numericValue1 = Character.getNumericValue(r.charAt(r.length() - 1));
        int numericValue2 = Character.getNumericValue(r.charAt(r.length() - 2));
        int combined = Integer.valueOf(numericValue2 + "" + numericValue1);
        r = r.replaceAll("E[0-9][0-9]", this.mSuffix[combined / 3]);
        while (r.length() > this.mMaxLength || r.matches("[0-9]+\\.[a-z]")) {
            r = r.substring(0, r.length() - 2) + r.substring(r.length() - 1);
        }
        return r;
    }

    public int getDecimalDigits() {
        return 0;
    }
}

