/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.util.Log;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineRadarDataSet;
import com.github.mikephil.charting.formatter.DefaultFillFormatter;
import com.github.mikephil.charting.formatter.IFillFormatter;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class LineDataSet
extends LineRadarDataSet<Entry>
implements ILineDataSet {
    private Mode mMode = Mode.LINEAR;
    private List<Integer> mCircleColors = null;
    private int mCircleHoleColor = -1;
    private float mCircleRadius = 8.0f;
    private float mCircleHoleRadius = 4.0f;
    private float mCubicIntensity = 0.2f;
    private DashPathEffect mDashPathEffect = null;
    private IFillFormatter mFillFormatter = new DefaultFillFormatter();
    private boolean mDrawCircles = true;
    private boolean mDrawCircleHole = true;

    public LineDataSet(List<Entry> yVals, String label) {
        super(yVals, label);
        if (this.mCircleColors == null) {
            this.mCircleColors = new ArrayList<Integer>();
        }
        this.mCircleColors.clear();
        this.mCircleColors.add(Color.rgb((int)140, (int)234, (int)255));
    }

    @Override
    public DataSet<Entry> copy() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < this.mEntries.size(); ++i) {
            entries.add(((Entry)this.mEntries.get(i)).copy());
        }
        LineDataSet copied = new LineDataSet((List<Entry>)entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected void copy(LineDataSet lineDataSet) {
        super.copy(lineDataSet);
        lineDataSet.mCircleColors = this.mCircleColors;
        lineDataSet.mCircleHoleColor = this.mCircleHoleColor;
        lineDataSet.mCircleHoleRadius = this.mCircleHoleRadius;
        lineDataSet.mCircleRadius = this.mCircleRadius;
        lineDataSet.mCubicIntensity = this.mCubicIntensity;
        lineDataSet.mDashPathEffect = this.mDashPathEffect;
        lineDataSet.mDrawCircleHole = this.mDrawCircleHole;
        lineDataSet.mDrawCircles = this.mDrawCircleHole;
        lineDataSet.mFillFormatter = this.mFillFormatter;
        lineDataSet.mMode = this.mMode;
    }

    @Override
    public Mode getMode() {
        return this.mMode;
    }

    public void setMode(Mode mode) {
        this.mMode = mode;
    }

    public void setCubicIntensity(float intensity) {
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (intensity < 0.05f) {
            intensity = 0.05f;
        }
        this.mCubicIntensity = intensity;
    }

    @Override
    public float getCubicIntensity() {
        return this.mCubicIntensity;
    }

    public void setCircleRadius(float radius) {
        if (radius >= 1.0f) {
            this.mCircleRadius = Utils.convertDpToPixel(radius);
        } else {
            Log.e((String)"LineDataSet", (String)"Circle radius cannot be < 1");
        }
    }

    @Override
    public float getCircleRadius() {
        return this.mCircleRadius;
    }

    public void setCircleHoleRadius(float holeRadius) {
        if (holeRadius >= 0.5f) {
            this.mCircleHoleRadius = Utils.convertDpToPixel(holeRadius);
        } else {
            Log.e((String)"LineDataSet", (String)"Circle radius cannot be < 0.5");
        }
    }

    @Override
    public float getCircleHoleRadius() {
        return this.mCircleHoleRadius;
    }

    @Deprecated
    public void setCircleSize(float size) {
        this.setCircleRadius(size);
    }

    @Deprecated
    public float getCircleSize() {
        return this.getCircleRadius();
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mDashPathEffect = new DashPathEffect(new float[]{lineLength, spaceLength}, phase);
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    @Override
    public boolean isDashedLineEnabled() {
        return this.mDashPathEffect != null;
    }

    @Override
    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }

    public void setDrawCircles(boolean enabled) {
        this.mDrawCircles = enabled;
    }

    @Override
    public boolean isDrawCirclesEnabled() {
        return this.mDrawCircles;
    }

    @Override
    @Deprecated
    public boolean isDrawCubicEnabled() {
        return this.mMode == Mode.CUBIC_BEZIER;
    }

    @Override
    @Deprecated
    public boolean isDrawSteppedEnabled() {
        return this.mMode == Mode.STEPPED;
    }

    public List<Integer> getCircleColors() {
        return this.mCircleColors;
    }

    @Override
    public int getCircleColor(int index) {
        return this.mCircleColors.get(index);
    }

    @Override
    public int getCircleColorCount() {
        return this.mCircleColors.size();
    }

    public void setCircleColors(List<Integer> colors) {
        this.mCircleColors = colors;
    }

    public void setCircleColors(int ... colors) {
        this.mCircleColors = ColorTemplate.createColors(colors);
    }

    public void setCircleColors(int[] colors, Context c) {
        List<Integer> clrs = this.mCircleColors;
        if (clrs == null) {
            clrs = new ArrayList<Integer>();
        }
        clrs.clear();
        for (int color : colors) {
            clrs.add(c.getResources().getColor(color));
        }
        this.mCircleColors = clrs;
    }

    public void setCircleColor(int color) {
        this.resetCircleColors();
        this.mCircleColors.add(color);
    }

    public void resetCircleColors() {
        if (this.mCircleColors == null) {
            this.mCircleColors = new ArrayList<Integer>();
        }
        this.mCircleColors.clear();
    }

    public void setCircleHoleColor(int color) {
        this.mCircleHoleColor = color;
    }

    @Override
    public int getCircleHoleColor() {
        return this.mCircleHoleColor;
    }

    public void setDrawCircleHole(boolean enabled) {
        this.mDrawCircleHole = enabled;
    }

    @Override
    public boolean isDrawCircleHoleEnabled() {
        return this.mDrawCircleHole;
    }

    public void setFillFormatter(IFillFormatter formatter) {
        this.mFillFormatter = formatter == null ? new DefaultFillFormatter() : formatter;
    }

    @Override
    public IFillFormatter getFillFormatter() {
        return this.mFillFormatter;
    }

    public static enum Mode {
        LINEAR,
        STEPPED,
        CUBIC_BEZIER,
        HORIZONTAL_BEZIER;

    }
}

