/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class BarLineChartTouchListener
extends ChartTouchListener<BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>>> {
    private Matrix mMatrix = new Matrix();
    private Matrix mSavedMatrix = new Matrix();
    private MPPointF mTouchStartPoint = MPPointF.getInstance(0.0f, 0.0f);
    private MPPointF mTouchPointCenter = MPPointF.getInstance(0.0f, 0.0f);
    private float mSavedXDist = 1.0f;
    private float mSavedYDist = 1.0f;
    private float mSavedDist = 1.0f;
    private IDataSet mClosestDataSetToTouch;
    private VelocityTracker mVelocityTracker;
    private long mDecelerationLastTime = 0L;
    private MPPointF mDecelerationCurrentPoint = MPPointF.getInstance(0.0f, 0.0f);
    private MPPointF mDecelerationVelocity = MPPointF.getInstance(0.0f, 0.0f);
    private float mDragTriggerDist;
    private float mMinScalePointerDistance;

    public BarLineChartTouchListener(BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>> chart, Matrix touchMatrix, float dragTriggerDistance) {
        super(chart);
        this.mMatrix = touchMatrix;
        this.mDragTriggerDist = Utils.convertDpToPixel(dragTriggerDistance);
        this.mMinScalePointerDistance = Utils.convertDpToPixel(3.5f);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        if (event.getActionMasked() == 3 && this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mTouchMode == 0 || ((BarLineChartBase)this.mChart).isFlingEnabled()) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (!(((BarLineChartBase)this.mChart).isDragEnabled() || ((BarLineChartBase)this.mChart).isScaleXEnabled() || ((BarLineChartBase)this.mChart).isScaleYEnabled())) {
            return true;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.startAction(event);
                this.stopDeceleration();
                this.saveTouchStart(event);
                break;
            }
            case 5: {
                if (event.getPointerCount() < 2) break;
                ((BarLineChartBase)this.mChart).disableScroll();
                this.saveTouchStart(event);
                this.mSavedXDist = BarLineChartTouchListener.getXDist(event);
                this.mSavedYDist = BarLineChartTouchListener.getYDist(event);
                this.mSavedDist = BarLineChartTouchListener.spacing(event);
                if (this.mSavedDist > 10.0f) {
                    this.mTouchMode = ((BarLineChartBase)this.mChart).isPinchZoomEnabled() ? 4 : (((BarLineChartBase)this.mChart).isScaleXEnabled() != ((BarLineChartBase)this.mChart).isScaleYEnabled() ? (((BarLineChartBase)this.mChart).isScaleXEnabled() ? 2 : 3) : (this.mSavedXDist > this.mSavedYDist ? 2 : 3));
                }
                BarLineChartTouchListener.midPoint(this.mTouchPointCenter, event);
                break;
            }
            case 2: {
                boolean shouldPan;
                if (this.mTouchMode == 1) {
                    ((BarLineChartBase)this.mChart).disableScroll();
                    float x = ((BarLineChartBase)this.mChart).isDragXEnabled() ? event.getX() - this.mTouchStartPoint.x : 0.0f;
                    float y = ((BarLineChartBase)this.mChart).isDragYEnabled() ? event.getY() - this.mTouchStartPoint.y : 0.0f;
                    this.performDrag(event, x, y);
                    break;
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4) {
                    ((BarLineChartBase)this.mChart).disableScroll();
                    if (!((BarLineChartBase)this.mChart).isScaleXEnabled() && !((BarLineChartBase)this.mChart).isScaleYEnabled()) break;
                    this.performZoom(event);
                    break;
                }
                if (this.mTouchMode != 0 || !(Math.abs(BarLineChartTouchListener.distance(event.getX(), this.mTouchStartPoint.x, event.getY(), this.mTouchStartPoint.y)) > this.mDragTriggerDist) || !((BarLineChartBase)this.mChart).isDragEnabled()) break;
                boolean bl = shouldPan = !((BarLineChartBase)this.mChart).isFullyZoomedOut() || !((BarLineChartBase)this.mChart).hasNoDragOffset();
                if (shouldPan) {
                    float distanceX = Math.abs(event.getX() - this.mTouchStartPoint.x);
                    float distanceY = Math.abs(event.getY() - this.mTouchStartPoint.y);
                    if (!((BarLineChartBase)this.mChart).isDragXEnabled() && !(distanceY >= distanceX) || !((BarLineChartBase)this.mChart).isDragYEnabled() && !(distanceY <= distanceX)) break;
                    this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
                    this.mTouchMode = 1;
                    break;
                }
                if (!((BarLineChartBase)this.mChart).isHighlightPerDragEnabled()) break;
                this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
                if (!((BarLineChartBase)this.mChart).isHighlightPerDragEnabled()) break;
                this.performHighlightDrag(event);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                int pointerId = event.getPointerId(0);
                velocityTracker.computeCurrentVelocity(1000, (float)Utils.getMaximumFlingVelocity());
                float velocityY = velocityTracker.getYVelocity(pointerId);
                float velocityX = velocityTracker.getXVelocity(pointerId);
                if ((Math.abs(velocityX) > (float)Utils.getMinimumFlingVelocity() || Math.abs(velocityY) > (float)Utils.getMinimumFlingVelocity()) && this.mTouchMode == 1 && ((BarLineChartBase)this.mChart).isDragDecelerationEnabled()) {
                    this.stopDeceleration();
                    this.mDecelerationLastTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDecelerationCurrentPoint.x = event.getX();
                    this.mDecelerationCurrentPoint.y = event.getY();
                    this.mDecelerationVelocity.x = velocityX;
                    this.mDecelerationVelocity.y = velocityY;
                    Utils.postInvalidateOnAnimation((View)this.mChart);
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4 || this.mTouchMode == 5) {
                    ((BarLineChartBase)this.mChart).calculateOffsets();
                    ((BarLineChartBase)this.mChart).postInvalidate();
                }
                this.mTouchMode = 0;
                ((BarLineChartBase)this.mChart).enableScroll();
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.endAction(event);
                break;
            }
            case 6: {
                Utils.velocityTrackerPointerUpCleanUpIfNecessary(event, this.mVelocityTracker);
                this.mTouchMode = 5;
                break;
            }
            case 3: {
                this.mTouchMode = 0;
                this.endAction(event);
            }
        }
        this.mMatrix = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, true);
        return true;
    }

    private void saveTouchStart(MotionEvent event) {
        this.mSavedMatrix.set(this.mMatrix);
        this.mTouchStartPoint.x = event.getX();
        this.mTouchStartPoint.y = event.getY();
        this.mClosestDataSetToTouch = ((BarLineChartBase)this.mChart).getDataSetByTouchPoint(event.getX(), event.getY());
    }

    private void performDrag(MotionEvent event, float distanceX, float distanceY) {
        this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
        this.mMatrix.set(this.mSavedMatrix);
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (this.inverted()) {
            if (this.mChart instanceof HorizontalBarChart) {
                distanceX = -distanceX;
            } else {
                distanceY = -distanceY;
            }
        }
        this.mMatrix.postTranslate(distanceX, distanceY);
        if (l != null) {
            l.onChartTranslate(event, distanceX, distanceY);
        }
    }

    private void performZoom(MotionEvent event) {
        if (event.getPointerCount() >= 2) {
            OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
            float totalDist = BarLineChartTouchListener.spacing(event);
            if (totalDist > this.mMinScalePointerDistance) {
                MPPointF t = this.getTrans(this.mTouchPointCenter.x, this.mTouchPointCenter.y);
                ViewPortHandler h = ((BarLineChartBase)this.mChart).getViewPortHandler();
                if (this.mTouchMode == 4) {
                    float scaleY;
                    this.mLastGesture = ChartTouchListener.ChartGesture.PINCH_ZOOM;
                    float scale = totalDist / this.mSavedDist;
                    boolean isZoomingOut = scale < 1.0f;
                    boolean canZoomMoreX = isZoomingOut ? h.canZoomOutMoreX() : h.canZoomInMoreX();
                    boolean canZoomMoreY = isZoomingOut ? h.canZoomOutMoreY() : h.canZoomInMoreY();
                    float scaleX = ((BarLineChartBase)this.mChart).isScaleXEnabled() ? scale : 1.0f;
                    float f = scaleY = ((BarLineChartBase)this.mChart).isScaleYEnabled() ? scale : 1.0f;
                    if (canZoomMoreY || canZoomMoreX) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(scaleX, scaleY, t.x, t.y);
                        if (l != null) {
                            l.onChartScale(event, scaleX, scaleY);
                        }
                    }
                } else if (this.mTouchMode == 2 && ((BarLineChartBase)this.mChart).isScaleXEnabled()) {
                    boolean canZoomMoreX;
                    this.mLastGesture = ChartTouchListener.ChartGesture.X_ZOOM;
                    float xDist = BarLineChartTouchListener.getXDist(event);
                    float scaleX = xDist / this.mSavedXDist;
                    boolean isZoomingOut = scaleX < 1.0f;
                    boolean bl = canZoomMoreX = isZoomingOut ? h.canZoomOutMoreX() : h.canZoomInMoreX();
                    if (canZoomMoreX) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(scaleX, 1.0f, t.x, t.y);
                        if (l != null) {
                            l.onChartScale(event, scaleX, 1.0f);
                        }
                    }
                } else if (this.mTouchMode == 3 && ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                    boolean canZoomMoreY;
                    this.mLastGesture = ChartTouchListener.ChartGesture.Y_ZOOM;
                    float yDist = BarLineChartTouchListener.getYDist(event);
                    float scaleY = yDist / this.mSavedYDist;
                    boolean isZoomingOut = scaleY < 1.0f;
                    boolean bl = canZoomMoreY = isZoomingOut ? h.canZoomOutMoreY() : h.canZoomInMoreY();
                    if (canZoomMoreY) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(1.0f, scaleY, t.x, t.y);
                        if (l != null) {
                            l.onChartScale(event, 1.0f, scaleY);
                        }
                    }
                }
                MPPointF.recycleInstance(t);
            }
        }
    }

    private void performHighlightDrag(MotionEvent e) {
        Highlight h = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(e.getX(), e.getY());
        if (h != null && !h.equalTo(this.mLastHighlighted)) {
            this.mLastHighlighted = h;
            ((BarLineChartBase)this.mChart).highlightValue(h, true);
        }
    }

    private static void midPoint(MPPointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.x = x / 2.0f;
        point.y = y / 2.0f;
    }

    private static float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private static float getXDist(MotionEvent e) {
        float x = Math.abs(e.getX(0) - e.getX(1));
        return x;
    }

    private static float getYDist(MotionEvent e) {
        float y = Math.abs(e.getY(0) - e.getY(1));
        return y;
    }

    public MPPointF getTrans(float x, float y) {
        ViewPortHandler vph = ((BarLineChartBase)this.mChart).getViewPortHandler();
        float xTrans = x - vph.offsetLeft();
        float yTrans = 0.0f;
        yTrans = this.inverted() ? -(y - vph.offsetTop()) : -((float)((BarLineChartBase)this.mChart).getMeasuredHeight() - y - vph.offsetBottom());
        return MPPointF.getInstance(xTrans, yTrans);
    }

    private boolean inverted() {
        return this.mClosestDataSetToTouch == null && ((BarLineChartBase)this.mChart).isAnyAxisInverted() || this.mClosestDataSetToTouch != null && ((BarLineChartBase)this.mChart).isInverted(this.mClosestDataSetToTouch.getAxisDependency());
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public void setDragTriggerDist(float dragTriggerDistance) {
        this.mDragTriggerDist = Utils.convertDpToPixel(dragTriggerDistance);
    }

    public boolean onDoubleTap(MotionEvent e) {
        this.mLastGesture = ChartTouchListener.ChartGesture.DOUBLE_TAP;
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartDoubleTapped(e);
        }
        if (((BarLineChartBase)this.mChart).isDoubleTapToZoomEnabled() && ((BarLineScatterCandleBubbleData)((BarLineChartBase)this.mChart).getData()).getEntryCount() > 0) {
            MPPointF trans = this.getTrans(e.getX(), e.getY());
            float scaleX = ((BarLineChartBase)this.mChart).isScaleXEnabled() ? 1.4f : 1.0f;
            float scaleY = ((BarLineChartBase)this.mChart).isScaleYEnabled() ? 1.4f : 1.0f;
            ((BarLineChartBase)this.mChart).zoom(scaleX, scaleY, trans.x, trans.y);
            if (((BarLineChartBase)this.mChart).isLogEnabled()) {
                Log.i((String)"BarlineChartTouch", (String)("Double-Tap, Zooming In, x: " + trans.x + ", y: " + trans.y));
            }
            if (l != null) {
                l.onChartScale(e, scaleX, scaleY);
            }
            MPPointF.recycleInstance(trans);
        }
        return super.onDoubleTap(e);
    }

    public void onLongPress(MotionEvent e) {
        this.mLastGesture = ChartTouchListener.ChartGesture.LONG_PRESS;
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartLongPressed(e);
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.mLastGesture = ChartTouchListener.ChartGesture.SINGLE_TAP;
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartSingleTapped(e);
        }
        if (!((BarLineChartBase)this.mChart).isHighlightPerTapEnabled()) {
            return false;
        }
        Highlight h = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(e.getX(), e.getY());
        this.performHighlight(h, e);
        return super.onSingleTapUp(e);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.mLastGesture = ChartTouchListener.ChartGesture.FLING;
        OnChartGestureListener l = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartFling(e1, e2, velocityX, velocityY);
        }
        return super.onFling(e1, e2, velocityX, velocityY);
    }

    public void stopDeceleration() {
        this.mDecelerationVelocity.x = 0.0f;
        this.mDecelerationVelocity.y = 0.0f;
    }

    public void computeScroll() {
        if (this.mDecelerationVelocity.x == 0.0f && this.mDecelerationVelocity.y == 0.0f) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDecelerationVelocity.x *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        this.mDecelerationVelocity.y *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        float timeInterval = (float)(currentTime - this.mDecelerationLastTime) / 1000.0f;
        float distanceX = this.mDecelerationVelocity.x * timeInterval;
        float distanceY = this.mDecelerationVelocity.y * timeInterval;
        this.mDecelerationCurrentPoint.x += distanceX;
        this.mDecelerationCurrentPoint.y += distanceY;
        MotionEvent event = MotionEvent.obtain((long)currentTime, (long)currentTime, (int)2, (float)this.mDecelerationCurrentPoint.x, (float)this.mDecelerationCurrentPoint.y, (int)0);
        float dragDistanceX = ((BarLineChartBase)this.mChart).isDragXEnabled() ? this.mDecelerationCurrentPoint.x - this.mTouchStartPoint.x : 0.0f;
        float dragDistanceY = ((BarLineChartBase)this.mChart).isDragYEnabled() ? this.mDecelerationCurrentPoint.y - this.mTouchStartPoint.y : 0.0f;
        this.performDrag(event, dragDistanceX, dragDistanceY);
        event.recycle();
        this.mMatrix = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, false);
        this.mDecelerationLastTime = currentTime;
        if ((double)Math.abs(this.mDecelerationVelocity.x) >= 0.01 || (double)Math.abs(this.mDecelerationVelocity.y) >= 0.01) {
            Utils.postInvalidateOnAnimation((View)this.mChart);
        } else {
            ((BarLineChartBase)this.mChart).calculateOffsets();
            ((BarLineChartBase)this.mChart).postInvalidate();
            this.stopDeceleration();
        }
    }
}

