/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.MPPointD;
import java.util.ArrayList;
import java.util.List;

public class HorizontalBarHighlighter
extends BarHighlighter {
    public HorizontalBarHighlighter(BarDataProvider chart) {
        super(chart);
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        BarData barData = ((BarDataProvider)this.mChart).getBarData();
        MPPointD pos = this.getValsForTouch(y, x);
        Highlight high = this.getHighlightForX((float)pos.y, y, x);
        if (high == null) {
            return null;
        }
        IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(high.getDataSetIndex());
        if (set.isStacked()) {
            return this.getStackedHighlight(high, set, (float)pos.y, (float)pos.x);
        }
        MPPointD.recycleInstance(pos);
        return high;
    }

    @Override
    protected List<Highlight> buildHighlights(IDataSet set, int dataSetIndex, float xVal, DataSet.Rounding rounding) {
        Object closest;
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        List entries = set.getEntriesForXValue(xVal);
        if (entries.size() == 0 && (closest = set.getEntryForXValue(xVal, Float.NaN, rounding)) != null) {
            entries = set.getEntriesForXValue(((Entry)closest).getX());
        }
        if (entries.size() == 0) {
            return highlights;
        }
        for (Entry e : entries) {
            MPPointD pixels = ((BarDataProvider)this.mChart).getTransformer(set.getAxisDependency()).getPixelForValues(e.getY(), e.getX());
            highlights.add(new Highlight(e.getX(), e.getY(), (float)pixels.x, (float)pixels.y, dataSetIndex, set.getAxisDependency()));
        }
        return highlights;
    }

    @Override
    protected float getDistance(float x1, float y1, float x2, float y2) {
        return Math.abs(y1 - y2);
    }
}

