/*
 * Decompiled with CFR 0.152.
 */
package com.sothree.slidinguppanel;

import android.view.View;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.recyclerview.widget.RecyclerView;

public class ScrollableViewHelper {
    public int getScrollableViewScrollPosition(View scrollableView, boolean isSlidingUp) {
        if (scrollableView == null) {
            return 0;
        }
        if (scrollableView instanceof ScrollView) {
            if (isSlidingUp) {
                return scrollableView.getScrollY();
            }
            ScrollView sv = (ScrollView)scrollableView;
            View child = sv.getChildAt(0);
            return child.getBottom() - (sv.getHeight() + sv.getScrollY());
        }
        if (scrollableView instanceof ListView && ((ListView)scrollableView).getChildCount() > 0) {
            ListView lv = (ListView)scrollableView;
            if (lv.getAdapter() == null) {
                return 0;
            }
            if (isSlidingUp) {
                View firstChild = lv.getChildAt(0);
                return lv.getFirstVisiblePosition() * firstChild.getHeight() - firstChild.getTop();
            }
            View lastChild = lv.getChildAt(lv.getChildCount() - 1);
            return (lv.getAdapter().getCount() - lv.getLastVisiblePosition() - 1) * lastChild.getHeight() + lastChild.getBottom() - lv.getBottom();
        }
        if (scrollableView instanceof RecyclerView && ((RecyclerView)scrollableView).getChildCount() > 0) {
            RecyclerView rv = (RecyclerView)scrollableView;
            RecyclerView.LayoutManager lm = rv.getLayoutManager();
            if (rv.getAdapter() == null) {
                return 0;
            }
            if (isSlidingUp) {
                View firstChild = rv.getChildAt(0);
                return rv.getChildLayoutPosition(firstChild) * lm.getDecoratedMeasuredHeight(firstChild) - lm.getDecoratedTop(firstChild);
            }
            View lastChild = rv.getChildAt(rv.getChildCount() - 1);
            return (rv.getAdapter().getItemCount() - 1) * lm.getDecoratedMeasuredHeight(lastChild) + lm.getDecoratedBottom(lastChild) - rv.getBottom();
        }
        return 0;
    }
}

