/*
 * Decompiled with CFR 0.152.
 */
package com.sothree.slidinguppanel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.nineoldandroids.view.animation.AnimatorProxy;
import com.sothree.slidinguppanel.ScrollableViewHelper;
import com.sothree.slidinguppanel.ViewDragHelper;
import com.sothree.slidinguppanel.library.R;
import java.util.ArrayList;
import java.util.List;

public class SlidingUpPanelLayout
extends ViewGroup {
    private static final String TAG = SlidingUpPanelLayout.class.getSimpleName();
    private static final int DEFAULT_PANEL_HEIGHT = 68;
    private static final float DEFAULT_ANCHOR_POINT = 1.0f;
    private static PanelState DEFAULT_SLIDE_STATE = PanelState.COLLAPSED;
    private static final int DEFAULT_SHADOW_HEIGHT = 4;
    private static final int DEFAULT_FADE_COLOR = -1728053248;
    private static final int DEFAULT_MIN_FLING_VELOCITY = 400;
    private static final boolean DEFAULT_OVERLAY_FLAG = false;
    private static final boolean DEFAULT_CLIP_PANEL_FLAG = true;
    private static final int[] DEFAULT_ATTRS = new int[]{16842927};
    private int mMinFlingVelocity = 400;
    private int mCoveredFadeColor = -1728053248;
    private static final int DEFAULT_PARALLAX_OFFSET = 0;
    private final Paint mCoveredFadePaint = new Paint();
    private final Drawable mShadowDrawable;
    private int mPanelHeight = -1;
    private int mShadowHeight = -1;
    private int mParallaxOffset = -1;
    private boolean mIsSlidingUp;
    private boolean mOverlayContent = false;
    private boolean mClipPanel = true;
    private View mDragView;
    private int mDragViewResId = -1;
    private View mScrollableView;
    private int mScrollableViewResId;
    private ScrollableViewHelper mScrollableViewHelper = new ScrollableViewHelper();
    private View mSlideableView;
    private View mMainView;
    private PanelState mSlideState = DEFAULT_SLIDE_STATE;
    private PanelState mLastNotDraggingSlideState = DEFAULT_SLIDE_STATE;
    private float mSlideOffset;
    private int mSlideRange;
    private float mAnchorPoint = 1.0f;
    private boolean mIsUnableToDrag;
    private boolean mIsTouchEnabled;
    private float mPrevMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsScrollableViewHandlingTouch = false;
    private List<PanelSlideListener> mPanelSlideListeners = new ArrayList<PanelSlideListener>();
    private View.OnClickListener mFadeOnClickListener;
    private final ViewDragHelper mDragHelper;
    private boolean mFirstLayout = true;
    private final Rect mTmpRect = new Rect();

    public SlidingUpPanelLayout(Context context) {
        this(context, null);
    }

    public SlidingUpPanelLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingUpPanelLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            this.mShadowDrawable = null;
            this.mDragHelper = null;
            return;
        }
        Interpolator scrollerInterpolator = null;
        if (attrs != null) {
            TypedArray defAttrs = context.obtainStyledAttributes(attrs, DEFAULT_ATTRS);
            if (defAttrs != null) {
                int gravity = defAttrs.getInt(0, 0);
                this.setGravity(gravity);
            }
            defAttrs.recycle();
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SlidingUpPanelLayout);
            if (ta != null) {
                this.mPanelHeight = ta.getDimensionPixelSize(R.styleable.SlidingUpPanelLayout_umanoPanelHeight, -1);
                this.mShadowHeight = ta.getDimensionPixelSize(R.styleable.SlidingUpPanelLayout_umanoShadowHeight, -1);
                this.mParallaxOffset = ta.getDimensionPixelSize(R.styleable.SlidingUpPanelLayout_umanoParallaxOffset, -1);
                this.mMinFlingVelocity = ta.getInt(R.styleable.SlidingUpPanelLayout_umanoFlingVelocity, 400);
                this.mCoveredFadeColor = ta.getColor(R.styleable.SlidingUpPanelLayout_umanoFadeColor, -1728053248);
                this.mDragViewResId = ta.getResourceId(R.styleable.SlidingUpPanelLayout_umanoDragView, -1);
                this.mScrollableViewResId = ta.getResourceId(R.styleable.SlidingUpPanelLayout_umanoScrollableView, -1);
                this.mOverlayContent = ta.getBoolean(R.styleable.SlidingUpPanelLayout_umanoOverlay, false);
                this.mClipPanel = ta.getBoolean(R.styleable.SlidingUpPanelLayout_umanoClipPanel, true);
                this.mAnchorPoint = ta.getFloat(R.styleable.SlidingUpPanelLayout_umanoAnchorPoint, 1.0f);
                this.mSlideState = PanelState.values()[ta.getInt(R.styleable.SlidingUpPanelLayout_umanoInitialState, DEFAULT_SLIDE_STATE.ordinal())];
                int interpolatorResId = ta.getResourceId(R.styleable.SlidingUpPanelLayout_umanoScrollInterpolator, -1);
                if (interpolatorResId != -1) {
                    scrollerInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)interpolatorResId);
                }
            }
            ta.recycle();
        }
        float density = context.getResources().getDisplayMetrics().density;
        if (this.mPanelHeight == -1) {
            this.mPanelHeight = (int)(68.0f * density + 0.5f);
        }
        if (this.mShadowHeight == -1) {
            this.mShadowHeight = (int)(4.0f * density + 0.5f);
        }
        if (this.mParallaxOffset == -1) {
            this.mParallaxOffset = (int)(0.0f * density);
        }
        this.mShadowDrawable = this.mShadowHeight > 0 ? (this.mIsSlidingUp ? this.getResources().getDrawable(R.drawable.above_shadow) : this.getResources().getDrawable(R.drawable.below_shadow)) : null;
        this.setWillNotDraw(false);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, scrollerInterpolator, new DragHelperCallback());
        this.mDragHelper.setMinVelocity((float)this.mMinFlingVelocity * density);
        this.mIsTouchEnabled = true;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mDragViewResId != -1) {
            this.setDragView(this.findViewById(this.mDragViewResId));
        }
        if (this.mScrollableViewResId != -1) {
            this.setScrollableView(this.findViewById(this.mScrollableViewResId));
        }
    }

    public void setGravity(int gravity) {
        if (gravity != 48 && gravity != 80) {
            throw new IllegalArgumentException("gravity must be set to either top or bottom");
        }
        boolean bl = this.mIsSlidingUp = gravity == 80;
        if (!this.mFirstLayout) {
            this.requestLayout();
        }
    }

    public void setCoveredFadeColor(int color) {
        this.mCoveredFadeColor = color;
        this.requestLayout();
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public void setTouchEnabled(boolean enabled) {
        this.mIsTouchEnabled = enabled;
    }

    public boolean isTouchEnabled() {
        return this.mIsTouchEnabled && this.mSlideableView != null && this.mSlideState != PanelState.HIDDEN;
    }

    public void setPanelHeight(int val) {
        if (this.getPanelHeight() == val) {
            return;
        }
        this.mPanelHeight = val;
        if (!this.mFirstLayout) {
            this.requestLayout();
        }
        if (this.getPanelState() == PanelState.COLLAPSED) {
            this.smoothToBottom();
            this.invalidate();
            return;
        }
    }

    protected void smoothToBottom() {
        this.smoothSlideTo(0.0f, 0);
    }

    public int getShadowHeight() {
        return this.mShadowHeight;
    }

    public void setShadowHeight(int val) {
        this.mShadowHeight = val;
        if (!this.mFirstLayout) {
            this.invalidate();
        }
    }

    public int getPanelHeight() {
        return this.mPanelHeight;
    }

    public int getCurrentParallaxOffset() {
        int offset = (int)((float)this.mParallaxOffset * Math.max(this.mSlideOffset, 0.0f));
        return this.mIsSlidingUp ? -offset : offset;
    }

    public void setParallaxOffset(int val) {
        this.mParallaxOffset = val;
        if (!this.mFirstLayout) {
            this.requestLayout();
        }
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    public void setMinFlingVelocity(int val) {
        this.mMinFlingVelocity = val;
    }

    public void addPanelSlideListener(PanelSlideListener listener) {
        this.mPanelSlideListeners.add(listener);
    }

    public void removePanelSlideListener(PanelSlideListener listener) {
        this.mPanelSlideListeners.remove(listener);
    }

    public void setFadeOnClickListener(View.OnClickListener listener) {
        this.mFadeOnClickListener = listener;
    }

    public void setDragView(View dragView) {
        if (this.mDragView != null) {
            this.mDragView.setOnClickListener(null);
        }
        this.mDragView = dragView;
        if (this.mDragView != null) {
            this.mDragView.setClickable(true);
            this.mDragView.setFocusable(false);
            this.mDragView.setFocusableInTouchMode(false);
            this.mDragView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!SlidingUpPanelLayout.this.isEnabled() || !SlidingUpPanelLayout.this.isTouchEnabled()) {
                        return;
                    }
                    if (SlidingUpPanelLayout.this.mSlideState != PanelState.EXPANDED && SlidingUpPanelLayout.this.mSlideState != PanelState.ANCHORED) {
                        if (SlidingUpPanelLayout.this.mAnchorPoint < 1.0f) {
                            SlidingUpPanelLayout.this.setPanelState(PanelState.ANCHORED);
                        } else {
                            SlidingUpPanelLayout.this.setPanelState(PanelState.EXPANDED);
                        }
                    } else {
                        SlidingUpPanelLayout.this.setPanelState(PanelState.COLLAPSED);
                    }
                }
            });
        }
    }

    public void setDragView(int dragViewResId) {
        this.mDragViewResId = dragViewResId;
        this.setDragView(this.findViewById(dragViewResId));
    }

    public void setScrollableView(View scrollableView) {
        this.mScrollableView = scrollableView;
    }

    public void setScrollableViewHelper(ScrollableViewHelper helper) {
        this.mScrollableViewHelper = helper;
    }

    public void setAnchorPoint(float anchorPoint) {
        if (anchorPoint > 0.0f && anchorPoint <= 1.0f) {
            this.mAnchorPoint = anchorPoint;
            this.mFirstLayout = true;
            this.requestLayout();
        }
    }

    public float getAnchorPoint() {
        return this.mAnchorPoint;
    }

    public void setOverlayed(boolean overlayed) {
        this.mOverlayContent = overlayed;
    }

    public boolean isOverlayed() {
        return this.mOverlayContent;
    }

    public void setClipPanel(boolean clip) {
        this.mClipPanel = clip;
    }

    public boolean isClipPanel() {
        return this.mClipPanel;
    }

    void dispatchOnPanelSlide(View panel) {
        for (PanelSlideListener l : this.mPanelSlideListeners) {
            l.onPanelSlide(panel, this.mSlideOffset);
        }
    }

    void dispatchOnPanelStateChanged(View panel, PanelState previousState, PanelState newState) {
        for (PanelSlideListener l : this.mPanelSlideListeners) {
            l.onPanelStateChanged(panel, previousState, newState);
        }
        this.sendAccessibilityEvent(32);
    }

    void updateObscuredViewVisibility() {
        int bottom;
        int top;
        int right;
        int left;
        if (this.getChildCount() == 0) {
            return;
        }
        int leftBound = this.getPaddingLeft();
        int rightBound = this.getWidth() - this.getPaddingRight();
        int topBound = this.getPaddingTop();
        int bottomBound = this.getHeight() - this.getPaddingBottom();
        if (this.mSlideableView != null && SlidingUpPanelLayout.hasOpaqueBackground(this.mSlideableView)) {
            left = this.mSlideableView.getLeft();
            right = this.mSlideableView.getRight();
            top = this.mSlideableView.getTop();
            bottom = this.mSlideableView.getBottom();
        } else {
            bottom = 0;
            top = 0;
            right = 0;
            left = 0;
        }
        View child = this.getChildAt(0);
        int clampedChildLeft = Math.max(leftBound, child.getLeft());
        int clampedChildTop = Math.max(topBound, child.getTop());
        int clampedChildRight = Math.min(rightBound, child.getRight());
        int clampedChildBottom = Math.min(bottomBound, child.getBottom());
        int vis = clampedChildLeft >= left && clampedChildTop >= top && clampedChildRight <= right && clampedChildBottom <= bottom ? 4 : 0;
        child.setVisibility(vis);
    }

    void setAllChildrenVisible() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 4) continue;
            child.setVisibility(0);
        }
    }

    private static boolean hasOpaqueBackground(View v) {
        Drawable bg = v.getBackground();
        return bg != null && bg.getOpacity() == -1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
        }
        if (heightMode != 0x40000000) {
            throw new IllegalStateException("Height must have an exact value or MATCH_PARENT");
        }
        int childCount = this.getChildCount();
        if (childCount != 2) {
            throw new IllegalStateException("Sliding up panel layout must have exactly 2 children!");
        }
        this.mMainView = this.getChildAt(0);
        this.mSlideableView = this.getChildAt(1);
        if (this.mDragView == null) {
            this.setDragView(this.mSlideableView);
        }
        if (this.mSlideableView.getVisibility() != 0) {
            this.mSlideState = PanelState.HIDDEN;
        }
        int layoutHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
        int layoutWidth = widthSize - this.getPaddingLeft() - this.getPaddingRight();
        for (int i = 0; i < childCount; ++i) {
            int childHeightSpec;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 && i == 0) continue;
            int height = layoutHeight;
            int width = layoutWidth;
            if (child == this.mMainView) {
                if (!this.mOverlayContent && this.mSlideState != PanelState.HIDDEN) {
                    height -= this.mPanelHeight;
                }
                width -= lp.leftMargin + lp.rightMargin;
            } else if (child == this.mSlideableView) {
                height -= lp.topMargin;
            }
            int childWidthSpec = lp.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE) : (lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)0x40000000));
            if (lp.height == -2) {
                childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
            } else {
                if (lp.weight > 0.0f && lp.weight < 1.0f) {
                    height = (int)((float)height * lp.weight);
                } else if (lp.height != -1) {
                    height = lp.height;
                }
                childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            }
            child.measure(childWidthSpec, childHeightSpec);
            if (child != this.mSlideableView) continue;
            this.mSlideRange = this.mSlideableView.getMeasuredHeight() - this.mPanelHeight;
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int childCount = this.getChildCount();
        if (this.mFirstLayout) {
            switch (this.mSlideState) {
                case EXPANDED: {
                    this.mSlideOffset = 1.0f;
                    break;
                }
                case ANCHORED: {
                    this.mSlideOffset = this.mAnchorPoint;
                    break;
                }
                case HIDDEN: {
                    int newTop = this.computePanelTopPosition(0.0f) + (this.mIsSlidingUp ? this.mPanelHeight : -this.mPanelHeight);
                    this.mSlideOffset = this.computeSlideOffset(newTop);
                    break;
                }
                default: {
                    this.mSlideOffset = 0.0f;
                }
            }
        }
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 && (i == 0 || this.mFirstLayout)) continue;
            int childHeight = child.getMeasuredHeight();
            int childTop = paddingTop;
            if (child == this.mSlideableView) {
                childTop = this.computePanelTopPosition(this.mSlideOffset);
            }
            if (!this.mIsSlidingUp && child == this.mMainView && !this.mOverlayContent) {
                childTop = this.computePanelTopPosition(this.mSlideOffset) + this.mSlideableView.getMeasuredHeight();
            }
            int childBottom = childTop + childHeight;
            int childLeft = paddingLeft + lp.leftMargin;
            int childRight = childLeft + child.getMeasuredWidth();
            child.layout(childLeft, childTop, childRight, childBottom);
        }
        if (this.mFirstLayout) {
            this.updateObscuredViewVisibility();
        }
        this.applyParallaxForCurrentSlideOffset();
        this.mFirstLayout = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (h != oldh) {
            this.mFirstLayout = true;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mIsScrollableViewHandlingTouch || !this.isTouchEnabled()) {
            this.mDragHelper.abort();
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        float x = ev.getX();
        float y = ev.getY();
        float adx = Math.abs(x - this.mInitialMotionX);
        float ady = Math.abs(y - this.mInitialMotionY);
        int dragSlop = this.mDragHelper.getTouchSlop();
        switch (action) {
            case 0: {
                this.mIsUnableToDrag = false;
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                break;
            }
            case 2: {
                if (!(ady > (float)dragSlop && adx > ady) && this.isViewUnder(this.mDragView, (int)this.mInitialMotionX, (int)this.mInitialMotionY)) break;
                this.mDragHelper.cancel();
                this.mIsUnableToDrag = true;
                return false;
            }
            case 1: 
            case 3: {
                if (this.mDragHelper.isDragging()) {
                    this.mDragHelper.processTouchEvent(ev);
                    return true;
                }
                if (!(ady <= (float)dragSlop) || !(adx <= (float)dragSlop) || !(this.mSlideOffset > 0.0f) || this.isViewUnder(this.mSlideableView, (int)this.mInitialMotionX, (int)this.mInitialMotionY) || this.mFadeOnClickListener == null) break;
                this.playSoundEffect(0);
                this.mFadeOnClickListener.onClick((View)this);
                return true;
            }
        }
        return this.mDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || !this.isTouchEnabled()) {
            return super.onTouchEvent(ev);
        }
        try {
            this.mDragHelper.processTouchEvent(ev);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (!this.isEnabled() || !this.isTouchEnabled() || this.mIsUnableToDrag && action != 0) {
            this.mDragHelper.abort();
            return super.dispatchTouchEvent(ev);
        }
        float y = ev.getY();
        if (action == 0) {
            this.mIsScrollableViewHandlingTouch = false;
            this.mPrevMotionY = y;
        } else if (action == 2) {
            float dy = y - this.mPrevMotionY;
            this.mPrevMotionY = y;
            if (!this.isViewUnder(this.mScrollableView, (int)this.mInitialMotionX, (int)this.mInitialMotionY)) {
                return super.dispatchTouchEvent(ev);
            }
            int n = this.mIsSlidingUp ? 1 : -1;
            if (dy * (float)n > 0.0f) {
                if (this.mScrollableViewHelper.getScrollableViewScrollPosition(this.mScrollableView, this.mIsSlidingUp) > 0) {
                    this.mIsScrollableViewHandlingTouch = true;
                    return super.dispatchTouchEvent(ev);
                }
                if (this.mIsScrollableViewHandlingTouch) {
                    MotionEvent up = MotionEvent.obtain((MotionEvent)ev);
                    up.setAction(3);
                    super.dispatchTouchEvent(up);
                    up.recycle();
                    ev.setAction(0);
                }
                this.mIsScrollableViewHandlingTouch = false;
                return this.onTouchEvent(ev);
            }
            int n2 = this.mIsSlidingUp ? 1 : -1;
            if (dy * (float)n2 < 0.0f) {
                if (this.mSlideOffset < 1.0f) {
                    this.mIsScrollableViewHandlingTouch = false;
                    return this.onTouchEvent(ev);
                }
                if (!this.mIsScrollableViewHandlingTouch && this.mDragHelper.isDragging()) {
                    this.mDragHelper.cancel();
                    ev.setAction(0);
                }
                this.mIsScrollableViewHandlingTouch = true;
                return super.dispatchTouchEvent(ev);
            }
        } else if (action == 1 && this.mIsScrollableViewHandlingTouch) {
            this.mDragHelper.setDragState(0);
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean isViewUnder(View view, int x, int y) {
        if (view == null) {
            return false;
        }
        int[] viewLocation = new int[2];
        view.getLocationOnScreen(viewLocation);
        int[] parentLocation = new int[2];
        this.getLocationOnScreen(parentLocation);
        int screenX = parentLocation[0] + x;
        int screenY = parentLocation[1] + y;
        return screenX >= viewLocation[0] && screenX < viewLocation[0] + view.getWidth() && screenY >= viewLocation[1] && screenY < viewLocation[1] + view.getHeight();
    }

    private int computePanelTopPosition(float slideOffset) {
        int slidingViewHeight = this.mSlideableView != null ? this.mSlideableView.getMeasuredHeight() : 0;
        int slidePixelOffset = (int)(slideOffset * (float)this.mSlideRange);
        return this.mIsSlidingUp ? this.getMeasuredHeight() - this.getPaddingBottom() - this.mPanelHeight - slidePixelOffset : this.getPaddingTop() - slidingViewHeight + this.mPanelHeight + slidePixelOffset;
    }

    private float computeSlideOffset(int topPosition) {
        int topBoundCollapsed = this.computePanelTopPosition(0.0f);
        return this.mIsSlidingUp ? (float)(topBoundCollapsed - topPosition) / (float)this.mSlideRange : (float)(topPosition - topBoundCollapsed) / (float)this.mSlideRange;
    }

    public PanelState getPanelState() {
        return this.mSlideState;
    }

    public void setPanelState(PanelState state) {
        if (state == null || state == PanelState.DRAGGING) {
            throw new IllegalArgumentException("Panel state cannot be null or DRAGGING.");
        }
        if (!this.isEnabled() || !this.mFirstLayout && this.mSlideableView == null || state == this.mSlideState || this.mSlideState == PanelState.DRAGGING) {
            return;
        }
        if (this.mFirstLayout) {
            this.setPanelStateInternal(state);
        } else {
            if (this.mSlideState == PanelState.HIDDEN) {
                this.mSlideableView.setVisibility(0);
                this.requestLayout();
            }
            switch (state) {
                case ANCHORED: {
                    this.smoothSlideTo(this.mAnchorPoint, 0);
                    break;
                }
                case COLLAPSED: {
                    this.smoothSlideTo(0.0f, 0);
                    break;
                }
                case EXPANDED: {
                    this.smoothSlideTo(1.0f, 0);
                    break;
                }
                case HIDDEN: {
                    int newTop = this.computePanelTopPosition(0.0f) + (this.mIsSlidingUp ? this.mPanelHeight : -this.mPanelHeight);
                    this.smoothSlideTo(this.computeSlideOffset(newTop), 0);
                }
            }
        }
    }

    private void setPanelStateInternal(PanelState state) {
        if (this.mSlideState == state) {
            return;
        }
        PanelState oldState = this.mSlideState;
        this.mSlideState = state;
        this.dispatchOnPanelStateChanged((View)this, oldState, state);
    }

    @SuppressLint(value={"NewApi"})
    private void applyParallaxForCurrentSlideOffset() {
        if (this.mParallaxOffset > 0) {
            int mainViewOffset = this.getCurrentParallaxOffset();
            if (Build.VERSION.SDK_INT >= 11) {
                this.mMainView.setTranslationY((float)mainViewOffset);
            } else {
                AnimatorProxy.wrap((View)this.mMainView).setTranslationY((float)mainViewOffset);
            }
        }
    }

    private void onPanelDragged(int newTop) {
        this.mLastNotDraggingSlideState = this.mSlideState;
        this.setPanelStateInternal(PanelState.DRAGGING);
        this.mSlideOffset = this.computeSlideOffset(newTop);
        this.applyParallaxForCurrentSlideOffset();
        this.dispatchOnPanelSlide(this.mSlideableView);
        LayoutParams lp = (LayoutParams)this.mMainView.getLayoutParams();
        int defaultHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop() - this.mPanelHeight;
        if (this.mSlideOffset <= 0.0f && !this.mOverlayContent) {
            int n = lp.height = this.mIsSlidingUp ? newTop - this.getPaddingBottom() : this.getHeight() - this.getPaddingBottom() - this.mSlideableView.getMeasuredHeight() - newTop;
            if (lp.height == defaultHeight) {
                lp.height = -1;
            }
            this.mMainView.requestLayout();
        } else if (lp.height != -1 && !this.mOverlayContent) {
            lp.height = -1;
            this.mMainView.requestLayout();
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean result;
        int save = canvas.save(2);
        if (this.mSlideableView != child) {
            canvas.getClipBounds(this.mTmpRect);
            if (!this.mOverlayContent) {
                if (this.mIsSlidingUp) {
                    this.mTmpRect.bottom = Math.min(this.mTmpRect.bottom, this.mSlideableView.getTop());
                } else {
                    this.mTmpRect.top = Math.max(this.mTmpRect.top, this.mSlideableView.getBottom());
                }
            }
            if (this.mClipPanel) {
                canvas.clipRect(this.mTmpRect);
            }
            result = super.drawChild(canvas, child, drawingTime);
            if (this.mCoveredFadeColor != 0 && this.mSlideOffset > 0.0f) {
                int baseAlpha = (this.mCoveredFadeColor & 0xFF000000) >>> 24;
                int imag = (int)((float)baseAlpha * this.mSlideOffset);
                int color = imag << 24 | this.mCoveredFadeColor & 0xFFFFFF;
                this.mCoveredFadePaint.setColor(color);
                canvas.drawRect(this.mTmpRect, this.mCoveredFadePaint);
            }
        } else {
            result = super.drawChild(canvas, child, drawingTime);
        }
        canvas.restoreToCount(save);
        return result;
    }

    boolean smoothSlideTo(float slideOffset, int velocity) {
        if (!this.isEnabled() || this.mSlideableView == null) {
            return false;
        }
        int panelTop = this.computePanelTopPosition(slideOffset);
        if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, this.mSlideableView.getLeft(), panelTop)) {
            this.setAllChildrenVisible();
            ViewCompat.postInvalidateOnAnimation((View)this);
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mDragHelper != null && this.mDragHelper.continueSettling(true)) {
            if (!this.isEnabled()) {
                this.mDragHelper.abort();
                return;
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void draw(Canvas c) {
        super.draw(c);
        if (this.mShadowDrawable != null && this.mSlideableView != null) {
            int bottom;
            int top;
            int right = this.mSlideableView.getRight();
            if (this.mIsSlidingUp) {
                top = this.mSlideableView.getTop() - this.mShadowHeight;
                bottom = this.mSlideableView.getTop();
            } else {
                top = this.mSlideableView.getBottom();
                bottom = this.mSlideableView.getBottom() + this.mShadowHeight;
            }
            int left = this.mSlideableView.getLeft();
            this.mShadowDrawable.setBounds(left, top, right, bottom);
            this.mShadowDrawable.draw(c);
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && ViewCompat.canScrollHorizontally((View)v, (int)(-dx));
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mSlideState = this.mSlideState != PanelState.DRAGGING ? this.mSlideState : this.mLastNotDraggingSlideState;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSlideState = ss.mSlideState != null ? ss.mSlideState : DEFAULT_SLIDE_STATE;
    }

    static class SavedState
    extends View.BaseSavedState {
        PanelState mSlideState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            String panelStateString = in.readString();
            try {
                this.mSlideState = panelStateString != null ? Enum.valueOf(PanelState.class, panelStateString) : PanelState.COLLAPSED;
            }
            catch (IllegalArgumentException e) {
                this.mSlideState = PanelState.COLLAPSED;
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.mSlideState == null ? null : this.mSlideState.toString());
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};
        public float weight = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height);
            this.weight = weight;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray ta = c.obtainStyledAttributes(attrs, ATTRS);
            if (ta != null) {
                this.weight = ta.getFloat(0, 0.0f);
            }
            ta.recycle();
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            if (SlidingUpPanelLayout.this.mIsUnableToDrag) {
                return false;
            }
            return child == SlidingUpPanelLayout.this.mSlideableView;
        }

        @Override
        public void onViewDragStateChanged(int state) {
            if (SlidingUpPanelLayout.this.mDragHelper.getViewDragState() == 0) {
                SlidingUpPanelLayout.this.mSlideOffset = SlidingUpPanelLayout.this.computeSlideOffset(SlidingUpPanelLayout.this.mSlideableView.getTop());
                SlidingUpPanelLayout.this.applyParallaxForCurrentSlideOffset();
                if (SlidingUpPanelLayout.this.mSlideOffset == 1.0f) {
                    SlidingUpPanelLayout.this.updateObscuredViewVisibility();
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.EXPANDED);
                } else if (SlidingUpPanelLayout.this.mSlideOffset == 0.0f) {
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.COLLAPSED);
                } else if (SlidingUpPanelLayout.this.mSlideOffset < 0.0f) {
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.HIDDEN);
                    SlidingUpPanelLayout.this.mSlideableView.setVisibility(4);
                } else {
                    SlidingUpPanelLayout.this.updateObscuredViewVisibility();
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.ANCHORED);
                }
            }
        }

        @Override
        public void onViewCaptured(View capturedChild, int activePointerId) {
            SlidingUpPanelLayout.this.setAllChildrenVisible();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SlidingUpPanelLayout.this.onPanelDragged(top);
            SlidingUpPanelLayout.this.invalidate();
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            float direction;
            int target = 0;
            float f = direction = SlidingUpPanelLayout.this.mIsSlidingUp ? -yvel : yvel;
            target = direction > 0.0f && SlidingUpPanelLayout.this.mSlideOffset <= SlidingUpPanelLayout.this.mAnchorPoint ? SlidingUpPanelLayout.this.computePanelTopPosition(SlidingUpPanelLayout.this.mAnchorPoint) : (direction > 0.0f && SlidingUpPanelLayout.this.mSlideOffset > SlidingUpPanelLayout.this.mAnchorPoint ? SlidingUpPanelLayout.this.computePanelTopPosition(1.0f) : (direction < 0.0f && SlidingUpPanelLayout.this.mSlideOffset >= SlidingUpPanelLayout.this.mAnchorPoint ? SlidingUpPanelLayout.this.computePanelTopPosition(SlidingUpPanelLayout.this.mAnchorPoint) : (direction < 0.0f && SlidingUpPanelLayout.this.mSlideOffset < SlidingUpPanelLayout.this.mAnchorPoint ? SlidingUpPanelLayout.this.computePanelTopPosition(0.0f) : (SlidingUpPanelLayout.this.mSlideOffset >= (1.0f + SlidingUpPanelLayout.this.mAnchorPoint) / 2.0f ? SlidingUpPanelLayout.this.computePanelTopPosition(1.0f) : (SlidingUpPanelLayout.this.mSlideOffset >= SlidingUpPanelLayout.this.mAnchorPoint / 2.0f ? SlidingUpPanelLayout.this.computePanelTopPosition(SlidingUpPanelLayout.this.mAnchorPoint) : SlidingUpPanelLayout.this.computePanelTopPosition(0.0f))))));
            SlidingUpPanelLayout.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), target);
            SlidingUpPanelLayout.this.invalidate();
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return SlidingUpPanelLayout.this.mSlideRange;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            int collapsedTop = SlidingUpPanelLayout.this.computePanelTopPosition(0.0f);
            int expandedTop = SlidingUpPanelLayout.this.computePanelTopPosition(1.0f);
            if (SlidingUpPanelLayout.this.mIsSlidingUp) {
                return Math.min(Math.max(top, expandedTop), collapsedTop);
            }
            return Math.min(Math.max(top, collapsedTop), expandedTop);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelSlide(View panel, float slideOffset) {
        }

        @Override
        public void onPanelStateChanged(View panel, PanelState previousState, PanelState newState) {
        }
    }

    public static interface PanelSlideListener {
        public void onPanelSlide(View var1, float var2);

        public void onPanelStateChanged(View var1, PanelState var2, PanelState var3);
    }

    public static enum PanelState {
        EXPANDED,
        COLLAPSED,
        ANCHORED,
        HIDDEN,
        DRAGGING;

    }
}

