/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;

public class WriteBatchImpl
implements WriteBatch {
    private final List<Map.Entry<Slice, Slice>> batch = new ArrayList<Map.Entry<Slice, Slice>>();
    private int approximateSize;

    public int getApproximateSize() {
        return this.approximateSize;
    }

    public int size() {
        return this.batch.size();
    }

    public WriteBatchImpl put(byte[] key, byte[] value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.batch.add(Maps.immutableEntry((Object)Slices.wrappedBuffer(key), (Object)Slices.wrappedBuffer(value)));
        this.approximateSize += 12 + key.length + value.length;
        return this;
    }

    public WriteBatchImpl put(Slice key, Slice value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.batch.add(Maps.immutableEntry((Object)key, (Object)value));
        this.approximateSize += 12 + key.length() + value.length();
        return this;
    }

    public WriteBatchImpl delete(byte[] key) {
        Objects.requireNonNull(key, "key is null");
        this.batch.add(Maps.immutableEntry((Object)Slices.wrappedBuffer(key), (Object)null));
        this.approximateSize += 6 + key.length;
        return this;
    }

    public WriteBatchImpl delete(Slice key) {
        Objects.requireNonNull(key, "key is null");
        this.batch.add(Maps.immutableEntry((Object)key, (Object)null));
        this.approximateSize += 6 + key.length();
        return this;
    }

    public void close() {
    }

    public void forEach(Handler handler) {
        for (Map.Entry<Slice, Slice> entry : this.batch) {
            Slice key = entry.getKey();
            Slice value = entry.getValue();
            if (value != null) {
                handler.put(key, value);
                continue;
            }
            handler.delete(key);
        }
    }

    public static interface Handler {
        public void put(Slice var1, Slice var2);

        public void delete(Slice var1);
    }
}

