/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.math.MathEx;
import smile.plot.swing.Graphics;
import smile.plot.swing.Plot;

public class Wireframe
extends Plot {
    final double[][] vertices;
    final int[][] edges;

    public Wireframe(double[][] vertices, int[][] edges, Color color) {
        super(color);
        this.vertices = vertices;
        this.edges = edges;
    }

    @Override
    public double[] getLowerBound() {
        return MathEx.colMin((double[][])this.vertices);
    }

    @Override
    public double[] getUpperBound() {
        return MathEx.colMax((double[][])this.vertices);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        for (int[] edge : this.edges) {
            g.drawLine(this.vertices[edge[0]], this.vertices[edge[1]]);
        }
    }

    public static Wireframe of(double[][] vertices, int[][] edges) {
        return new Wireframe(vertices, edges, Color.BLACK);
    }
}

