/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import smile.plot.swing.Base;
import smile.plot.swing.Canvas;

abstract class Projection {
    protected final Canvas canvas;
    private int[][] baseScreenCoords;
    protected int width = 1;
    protected int height = 1;

    public Projection(Canvas canvas) {
        this.canvas = canvas;
        this.init();
    }

    public void reset() {
        this.init();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.reset();
    }

    private void init() {
        Base base = this.canvas.base;
        double margin = this.canvas.margin;
        this.baseScreenCoords = new int[base.baseCoords.length][2];
        for (int i = 0; i < base.dimension + 1; ++i) {
            double[] ratio = this.baseCoordsScreenProjectionRatio(base.baseCoords[i]);
            this.baseScreenCoords[i][0] = (int)((double)this.width * (margin + (1.0 - 2.0 * margin) * ratio[0]));
            this.baseScreenCoords[i][1] = (int)((double)this.height - (double)this.height * (margin + (1.0 - 2.0 * margin) * ratio[1]));
        }
    }

    public int[] screenProjection(double ... coord) {
        Base base = this.canvas.base;
        double[] sc = new double[]{this.baseScreenCoords[0][0], this.baseScreenCoords[0][1]};
        for (int i = 0; i < base.dimension; ++i) {
            sc[0] = sc[0] + (coord[i] - base.baseCoords[0][i]) / (base.baseCoords[i + 1][i] - base.baseCoords[0][i]) * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
            sc[1] = sc[1] + (coord[i] - base.baseCoords[0][i]) / (base.baseCoords[i + 1][i] - base.baseCoords[0][i]) * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
        }
        return new int[]{(int)sc[0], (int)sc[1]};
    }

    public int[] screenProjectionBaseRatio(double ... coord) {
        Base base = this.canvas.base;
        double[] sc = new double[]{this.baseScreenCoords[0][0], this.baseScreenCoords[0][1]};
        for (int i = 0; i < base.dimension; ++i) {
            sc[0] = sc[0] + coord[i] * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
            sc[1] = sc[1] + coord[i] * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
        }
        return new int[]{(int)sc[0], (int)sc[1]};
    }

    abstract double[] baseCoordsScreenProjectionRatio(double[] var1);
}

