/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class TableCopyPasteAdapter
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(TableCopyPasteAdapter.class.getName());
    private String rowstring;
    private String value;
    private Clipboard system;
    private StringSelection stsel;
    private JTable table;

    private TableCopyPasteAdapter(JTable table) {
        this.table = table;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        table.registerKeyboardAction(this, "Copy", copy, 0);
        table.registerKeyboardAction(this, "Paste", paste, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static TableCopyPasteAdapter apply(JTable table) {
        TableCopyPasteAdapter adapter = new TableCopyPasteAdapter(table);
        return adapter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int j;
        if (e.getActionCommand().compareTo("Copy") == 0) {
            StringBuilder sbf = new StringBuilder();
            int numcols = this.table.getSelectedColumnCount();
            int numrows = this.table.getSelectedRowCount();
            int[] rowsselected = this.table.getSelectedRows();
            int[] colsselected = this.table.getSelectedColumns();
            if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                return;
            }
            for (int i = 0; i < numrows; ++i) {
                for (j = 0; j < numcols; ++j) {
                    sbf.append(this.table.getValueAt(rowsselected[i], colsselected[j]));
                    if (j >= numcols - 1) continue;
                    sbf.append("\t");
                }
                sbf.append("\n");
            }
            this.stsel = new StringSelection(sbf.toString());
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(this.stsel, this.stsel);
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            LOGGER.log(Level.FINE, "Trying to Paste");
            int startRow = this.table.getSelectedRows()[0];
            int startCol = this.table.getSelectedColumns()[0];
            try {
                String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                int i = 0;
                while (st1.hasMoreTokens()) {
                    this.rowstring = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(this.rowstring, "\t");
                    j = 0;
                    while (st2.hasMoreTokens()) {
                        this.value = st2.nextToken();
                        if (startRow + i < this.table.getRowCount() && startCol + j < this.table.getColumnCount()) {
                            this.table.setValueAt(this.value, startRow + i, startCol + j);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

