/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class Wireframe
extends Plot {
    private double[][] vertices;
    private int[][] edges;

    public Wireframe(double[][] vertices, int[][] edges) {
        this(vertices, edges, Color.BLACK);
    }

    public Wireframe(double[][] vertices, int[][] edges, Color color) {
        super(color);
        this.vertices = vertices;
        this.edges = edges;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.getColor());
        for (int i = 0; i < this.edges.length; ++i) {
            g.drawLine(this.vertices[this.edges[i][0]], this.vertices[this.edges[i][1]]);
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[][] vertices, int[][] edges) {
        double[] lowerBound = Math.colMin((double[][])vertices);
        double[] upperBound = Math.colMax((double[][])vertices);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Wireframe frame = new Wireframe(vertices, edges);
        canvas.add(frame);
        return canvas;
    }

    public static PlotCanvas plot(String id, double[][] vertices, int[][] edges) {
        double[] lowerBound = Math.colMin((double[][])vertices);
        double[] upperBound = Math.colMax((double[][])vertices);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Wireframe frame = new Wireframe(vertices, edges);
        frame.setID(id);
        canvas.add(frame);
        return canvas;
    }
}

