/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.util.Arrays;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class BoxPlot
extends Plot {
    private double[][] data;
    private String[] description;
    private double[][] quantiles;
    private static String format = "<table border=\"1\"><tr><td>Median</td><td align=\"right\">%g</td></tr><tr><td>Q1</td><td align=\"right\">%g</td></tr><tr><td>Q3</td><td align=\"right\">%g</td></tr></table>";

    public BoxPlot(double[] data) {
        this.data = new double[1][];
        this.data[0] = data;
        this.init();
    }

    public BoxPlot(double[][] data) {
        this.data = data;
        this.init();
    }

    public BoxPlot(String[] description, double[][] data) {
        if (description.length != data.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        this.description = description;
        this.data = data;
        this.init();
    }

    private void init() {
        this.quantiles = new double[this.data.length][8];
        for (int i = 0; i < this.data.length; ++i) {
            int n = this.data[i].length;
            Arrays.sort(this.data[i]);
            this.quantiles[i][1] = this.data[i][n / 4];
            this.quantiles[i][2] = this.data[i][n / 2];
            this.quantiles[i][3] = this.data[i][3 * n / 4];
            this.quantiles[i][5] = this.quantiles[i][3] - this.quantiles[i][1];
            this.quantiles[i][6] = this.quantiles[i][1] - 1.5 * this.quantiles[i][5];
            this.quantiles[i][7] = this.quantiles[i][3] + 1.5 * this.quantiles[i][5];
            this.quantiles[i][0] = this.quantiles[i][6] < this.data[i][0] ? this.data[i][0] : this.quantiles[i][6];
            this.quantiles[i][4] = this.quantiles[i][7] > this.data[i][this.data[i].length - 1] ? this.data[i][this.data[i].length - 1] : this.quantiles[i][7];
        }
    }

    @Override
    public String getToolTip(double[] coord) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!(coord[0] < (double)i + 0.8) || !(coord[0] > (double)i + 0.2) || !(coord[1] < this.quantiles[i][3]) || !(coord[1] > this.quantiles[i][1])) continue;
            if (this.description != null) {
                return "<b>&nbsp;" + this.description[i] + ":</b></br>" + String.format(format, this.quantiles[i][2], this.quantiles[i][1], this.quantiles[i][3]);
            }
            return String.format(format, this.quantiles[i][2], this.quantiles[i][1], this.quantiles[i][3]);
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.getColor());
        double[] start = new double[2];
        double[] end = new double[2];
        for (int i = 0; i < this.data.length; ++i) {
            start[0] = (double)i + 0.4;
            start[1] = this.quantiles[i][0];
            end[0] = (double)i + 0.6;
            end[1] = this.quantiles[i][0];
            g.drawLine(start, end);
            start[0] = (double)i + 0.4;
            start[1] = this.quantiles[i][4];
            end[0] = (double)i + 0.6;
            end[1] = this.quantiles[i][4];
            g.drawLine(start, end);
            start[0] = (double)i + 0.2;
            start[1] = this.quantiles[i][2];
            end[0] = (double)i + 0.8;
            end[1] = this.quantiles[i][2];
            g.drawLine(start, end);
            start[0] = (double)i + 0.5;
            start[1] = this.quantiles[i][0];
            end[0] = (double)i + 0.5;
            end[1] = this.quantiles[i][1];
            g.drawLine(start, end);
            start[0] = (double)i + 0.5;
            start[1] = this.quantiles[i][4];
            end[0] = (double)i + 0.5;
            end[1] = this.quantiles[i][3];
            g.drawLine(start, end);
            start[0] = (double)i + 0.2;
            start[1] = this.quantiles[i][3];
            end[0] = (double)i + 0.8;
            end[1] = this.quantiles[i][1];
            g.drawRect(start, end);
            start[0] = (double)i + 0.5;
            for (int j = 0; j < this.data[i].length; ++j) {
                if (!(this.data[i][j] < this.quantiles[i][6]) && !(this.data[i][j] > this.quantiles[i][7])) continue;
                start[1] = this.data[i][j];
                g.drawPoint('o', start);
            }
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[] data) {
        double[] lowerBound = new double[]{0.0, Math.min((double[])data)};
        double[] upperBound = new double[]{1.0, Math.max((double[])data)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new BoxPlot(data));
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[] ... data) {
        double[] lowerBound = new double[]{0.0, Math.min((double[][])data)};
        double[] upperBound = new double[]{data.length, Math.max((double[][])data)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new BoxPlot(data));
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, String[] labels) {
        if (data.length != labels.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        double[] lowerBound = new double[]{0.0, Math.min((double[][])data)};
        double[] upperBound = new double[]{data.length, Math.max((double[][])data)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new BoxPlot(labels, data));
        double[] locations = new double[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            locations[i] = (double)i + 0.5;
        }
        canvas.getAxis(0).addLabel(labels, locations);
        canvas.getAxis(0).setGridVisible(false);
        if (labels.length > 10) {
            canvas.getAxis(0).setRotation(-1.5707963267948966);
        }
        return canvas;
    }
}

