/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;

public class Array2D {
    private double[] A;
    private int nrows;
    private int ncols;

    public Array2D(double[][] A) {
        this.nrows = A.length;
        this.ncols = A[0].length;
        this.A = new double[this.nrows * this.ncols];
        int pos = 0;
        for (int i = 0; i < this.nrows; ++i) {
            System.arraycopy(A[i], 0, this.A, pos, this.ncols);
            pos += this.ncols;
        }
    }

    public Array2D(int rows, int cols) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = new double[rows * cols];
    }

    public Array2D(int rows, int cols, double value) {
        this(rows, cols);
        if (value != 0.0) {
            Arrays.fill(this.A, value);
        }
    }

    public Array2D(int rows, int cols, double[] value) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = value;
    }

    public int nrows() {
        return this.nrows;
    }

    public int ncols() {
        return this.ncols;
    }

    public double apply(int i, int j) {
        return this.A[i * this.ncols + j];
    }

    public double get(int i, int j) {
        return this.A[i * this.ncols + j];
    }

    public double set(int i, int j, double x) {
        double d = x;
        this.A[i * this.ncols + j] = d;
        return d;
    }

    public double add(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] + x;
        this.A[n] = d;
        return d;
    }

    public double sub(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] - x;
        this.A[n] = d;
        return d;
    }

    public double mul(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] * x;
        this.A[n] = d;
        return d;
    }

    public double div(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] / x;
        this.A[n] = d;
        return d;
    }

    public Array2D add(Array2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + b.A[i];
        }
        return this;
    }

    public Array2D sub(Array2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - b.A[i];
        }
        return this;
    }

    public Array2D mul(Array2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * b.A[i];
        }
        return this;
    }

    public Array2D div(Array2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / b.A[i];
        }
        return this;
    }

    public Array2D add(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    public Array2D sub(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    public Array2D mul(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    public Array2D div(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    public Array2D replaceNaN(double x) {
        for (int i = 0; i < this.A.length; ++i) {
            if (!Double.isNaN(this.A[i])) continue;
            this.A[i] = x;
        }
        return this;
    }

    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.A.length; ++i) {
            s += this.A[i];
        }
        return s;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        return full ? this.toString(this.nrows(), this.ncols()) : this.toString(7, 7);
    }

    public String toString(int m, int n) {
        StringBuilder sb = new StringBuilder();
        m = Math.min(m, this.nrows());
        String newline = (n = Math.min(n, this.ncols())) < this.ncols() ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%8.4f  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrows()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }
}

