/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.MathEx;
import smile.math.special.Beta;

public class FTest {
    public final int df1;
    public final int df2;
    public final double f;
    public final double pvalue;

    private FTest(double f, int df1, int df2, double pvalue) {
        this.f = f;
        this.df1 = df1;
        this.df2 = df2;
        this.pvalue = pvalue;
    }

    public String toString() {
        return String.format("F-test(f = %.4f, df1 = %d, df2 = %d, p-value = %G)", this.f, this.df1, this.df2, this.pvalue);
    }

    public static FTest test(double[] x, double[] y) {
        int df2;
        int df1;
        double f;
        double var2;
        int n1 = x.length;
        int n2 = y.length;
        double var1 = MathEx.var(x);
        if (var1 > (var2 = MathEx.var(y))) {
            f = var1 / var2;
            df1 = n1 - 1;
            df2 = n2 - 1;
        } else {
            f = var2 / var1;
            df1 = n2 - 1;
            df2 = n1 - 1;
        }
        double p = 2.0 * Beta.regularizedIncompleteBetaFunction(0.5 * (double)df2, 0.5 * (double)df1, (double)df2 / ((double)df2 + (double)df1 * f));
        if (p > 1.0) {
            p = 2.0 - p;
        }
        return new FTest(f, df1, df2, p);
    }
}

