/*
 * Decompiled with CFR 0.152.
 */
package smile.stat;

import java.util.Arrays;
import smile.math.MathEx;
import smile.util.IntSet;

public interface Sampling {
    public static int[] random(int n, double subsample) {
        if (subsample == 1.0) {
            int[] samples = new int[n];
            for (int i = 0; i < n; ++i) {
                samples[i] = MathEx.randomInt(n);
            }
            return samples;
        }
        int size = (int)Math.round(subsample * (double)n);
        int[] samples = MathEx.permutate(n);
        return Arrays.copyOf(samples, size);
    }

    public static int[] strateified(int[] category, double subsample) {
        int i;
        int[] unique = MathEx.unique(category);
        int m = unique.length;
        Arrays.sort(unique);
        IntSet encoder = new IntSet(unique);
        int n = category.length;
        int[] y = category;
        if (unique[0] != 0 || unique[m - 1] != m - 1) {
            y = new int[n];
            for (int i2 = 0; i2 < n; ++i2) {
                y[i2] = encoder.indexOf(category[i2]);
            }
        }
        int[] ni = new int[m];
        int[] nArray = y;
        int n2 = nArray.length;
        for (int j = 0; j < n2; ++j) {
            int n3 = i = nArray[j];
            ni[n3] = ni[n3] + 1;
        }
        int[][] strata = new int[m][];
        for (int i3 = 0; i3 < m; ++i3) {
            strata[i3] = new int[ni[i3]];
        }
        int[] pos = new int[m];
        int i4 = 0;
        while (i4 < n) {
            int j;
            int n4 = j = y[i4];
            int n5 = pos[n4];
            pos[n4] = n5 + 1;
            strata[j][n5] = i4++;
        }
        if (subsample == 1.0) {
            int[] samples = new int[n];
            int l = 0;
            for (int i5 = 0; i5 < m; ++i5) {
                int[] stratum = strata[i5];
                int size = ni[i5];
                for (int j = 0; j < size; ++j) {
                    samples[l++] = stratum[MathEx.randomInt(size)];
                }
            }
            return samples;
        }
        int size = 0;
        for (i = 0; i < m; ++i) {
            size += (int)Math.round(subsample * (double)ni[i]);
        }
        int[] samples = new int[size];
        int l = 0;
        for (int i6 = 0; i6 < m; ++i6) {
            int sub = (int)Math.round(subsample * (double)ni[i6]);
            int[] stratum = strata[i6];
            int[] permutation = MathEx.permutate(ni[i6]);
            for (int j = 0; j < sub; ++j) {
                samples[l++] = stratum[permutation[j]];
            }
        }
        return samples;
    }
}

