/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.IsotropicKernel;

public class ThinPlateSpline
implements IsotropicKernel {
    private static final long serialVersionUID = 2L;
    final double sigma;
    final double lo;
    final double hi;

    public ThinPlateSpline(double sigma, double lo, double hi) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive: " + sigma);
        }
        this.sigma = sigma;
        this.lo = lo;
        this.hi = hi;
    }

    public double scale() {
        return this.sigma;
    }

    public String toString() {
        return String.format("ThinPlateSplineKernel(%.4f)", this.sigma);
    }

    @Override
    public double k(double dist) {
        double d = dist / this.sigma;
        return d * d * Math.log(d);
    }

    @Override
    public double[] kg(double dist) {
        double k;
        double[] g = new double[2];
        double d = dist / this.sigma;
        g[0] = k = d * d * Math.log(d);
        g[1] = -d * d * (2.0 * Math.log(d) + 1.0) / this.sigma;
        return g;
    }
}

