/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.DotProductKernel;

public class HyperbolicTangent
implements DotProductKernel {
    private static final long serialVersionUID = 2L;
    final double scale;
    final double offset;
    final double[] lo;
    final double[] hi;

    public HyperbolicTangent(double scale, double offset, double[] lo, double[] hi) {
        this.scale = scale;
        this.offset = offset;
        this.lo = lo;
        this.hi = hi;
    }

    public double scale() {
        return this.scale;
    }

    public double offset() {
        return this.offset;
    }

    public String toString() {
        return String.format("HyperbolicTangentKernel(%.4f, %.4f)", this.scale, this.offset);
    }

    @Override
    public double k(double dot) {
        return Math.tanh(this.scale * dot + this.offset);
    }

    @Override
    public double[] kg(double dot) {
        double[] g = new double[3];
        double cosh = Math.cosh(this.scale * dot + this.offset);
        double sech = 1.0 / (cosh * cosh);
        g[0] = Math.tanh(this.scale * dot + this.offset);
        g[1] = dot * sech;
        g[2] = sech;
        return g;
    }
}

