/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import java.util.Arrays;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.gap.Chromosome;
import smile.gap.LamarckianChromosome;
import smile.gap.Selection;

public class GeneticAlgorithm<T extends Chromosome> {
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    private int size;
    private T[] population;
    private Selection selection;
    private int elitism;
    private int t = 5;

    public GeneticAlgorithm(T[] seeds) {
        this((Chromosome[])seeds, Selection.Tournament(3, 0.95), 1);
    }

    public GeneticAlgorithm(T[] seeds, Selection selection, int elitism) {
        if (elitism < 0 || elitism >= seeds.length) {
            throw new IllegalArgumentException("Invalid elitism: " + elitism);
        }
        this.size = seeds.length;
        this.population = seeds;
        this.selection = selection;
        this.elitism = elitism;
    }

    public T[] population() {
        return this.population;
    }

    public GeneticAlgorithm<T> setLocalSearchSteps(int t2) {
        if (t2 < 0) {
            throw new IllegalArgumentException("Invalid of number of iterations of local search: " + t2);
        }
        this.t = t2;
        return this;
    }

    public int getLocalSearchSteps() {
        return this.t;
    }

    public T evolve(int generation) {
        return this.evolve(generation, Double.POSITIVE_INFINITY);
    }

    public T evolve(int generation, double threshold) {
        if (generation <= 0) {
            throw new IllegalArgumentException("Invalid number of generations to go: " + generation);
        }
        ((Stream)Arrays.stream(this.population).parallel()).forEach(chromosome -> {
            if (chromosome instanceof LamarckianChromosome) {
                LamarckianChromosome ch = (LamarckianChromosome)chromosome;
                for (int j = 0; j < this.t; ++j) {
                    ch.evolve();
                }
            }
            chromosome.fitness();
        });
        Arrays.sort(this.population);
        T best = this.population[this.size - 1];
        Chromosome[] offsprings = new Chromosome[this.size];
        for (int g = 1; g <= generation && best.fitness() < threshold; ++g) {
            int i;
            for (i = 0; i < this.elitism; ++i) {
                offsprings[i] = this.population[this.size - i - 1];
            }
            for (i = this.elitism; i < this.size; i += 2) {
                Chromosome father = this.selection.apply((Chromosome[])this.population);
                Chromosome mother = this.selection.apply((Chromosome[])this.population);
                while (mother == father) {
                    mother = this.selection.apply((Chromosome[])this.population);
                }
                Chromosome[] children = father.crossover(mother);
                offsprings[i] = children[0];
                offsprings[i].mutate();
                if (i + 1 >= this.size) continue;
                offsprings[i + 1] = children[1];
                offsprings[i + 1].mutate();
            }
            System.arraycopy(offsprings, 0, this.population, 0, this.size);
            ((Stream)Arrays.stream(this.population).parallel()).forEach(chromosome -> {
                if (chromosome instanceof LamarckianChromosome) {
                    LamarckianChromosome ch = (LamarckianChromosome)chromosome;
                    for (int j = 0; j < this.t; ++j) {
                        ch.evolve();
                    }
                }
                chromosome.fitness();
            });
            Arrays.sort(this.population);
            best = this.population[this.size - 1];
            double avg = 0.0;
            for (T ch : this.population) {
                avg += ch.fitness();
            }
            logger.info(String.format("Generation %d, best fitness %G, average fitness %G", g, best.fitness(), avg /= (double)this.size));
        }
        return best;
    }
}

