/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.Tuple;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.NominalScale;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class FactorInteraction
implements Term {
    private List<String> factors;

    public FactorInteraction(String ... factors) {
        if (factors.length < 2) {
            throw new IllegalArgumentException("Interaction() takes at least two factors");
        }
        this.factors = Arrays.asList(factors);
    }

    public int size() {
        return this.factors.size();
    }

    public String toString() {
        return this.factors.stream().collect(Collectors.joining(":"));
    }

    @Override
    public Set<String> variables() {
        return new HashSet<String>(this.factors);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        List fields = this.factors.stream().map(factor -> schema.field((String)factor)).collect(Collectors.toList());
        for (Object field : fields) {
            if (((StructField)field).measure instanceof CategoricalMeasure) continue;
            throw new IllegalStateException(String.format("%s is not a categorical variable: %s", ((StructField)field).name, ((StructField)field).measure));
        }
        List<String> levels = new ArrayList<String>();
        levels.add("");
        for (StructField field : fields) {
            CategoricalMeasure cat = (CategoricalMeasure)field.measure;
            levels = levels.stream().flatMap(l -> Arrays.stream(cat.levels()).map(level -> l.isEmpty() ? level : l + ":" + level)).collect(Collectors.toList());
        }
        final NominalScale measure = new NominalScale(levels);
        Feature feature = new Feature(){
            StructField field;
            {
                this.field = new StructField(FactorInteraction.this.factors.stream().collect(Collectors.joining(":")), DataTypes.IntegerType, measure);
            }

            public String toString() {
                return this.field.name;
            }

            @Override
            public StructField field() {
                return this.field;
            }

            @Override
            public int applyAsInt(Tuple o) {
                String level = FactorInteraction.this.factors.stream().map(factor -> o.getString((String)factor)).collect(Collectors.joining(":"));
                return measure.valueOf(level).intValue();
            }

            @Override
            public Object apply(Tuple o) {
                String level = FactorInteraction.this.factors.stream().map(factor -> o.getString((String)factor)).collect(Collectors.joining(":"));
                return measure.valueOf(level);
            }
        };
        return Collections.singletonList(feature);
    }
}

