/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator.buildins.commonnavigator.titles;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.widget.TextView;
import net.lucode.hackware.magicindicator.buildins.UIUtil;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IMeasurablePagerTitleView;

public class SimplePagerTitleView
extends TextView
implements IMeasurablePagerTitleView {
    protected int mSelectedColor;
    protected int mNormalColor;

    public SimplePagerTitleView(Context context) {
        super(context, null);
        this.init(context);
    }

    private void init(Context context) {
        this.setGravity(17);
        int padding = UIUtil.dip2px(context, 10.0);
        this.setPadding(padding, 0, padding, 0);
        this.setSingleLine();
        this.setEllipsize(TextUtils.TruncateAt.END);
    }

    @Override
    public void onSelected(int index, int totalCount) {
        this.setTextColor(this.mSelectedColor);
    }

    @Override
    public void onDeselected(int index, int totalCount) {
        this.setTextColor(this.mNormalColor);
    }

    @Override
    public void onLeave(int index, int totalCount, float leavePercent, boolean leftToRight) {
    }

    @Override
    public void onEnter(int index, int totalCount, float enterPercent, boolean leftToRight) {
    }

    @Override
    public int getContentLeft() {
        Rect bound = new Rect();
        this.getPaint().getTextBounds(this.getText().toString(), 0, this.getText().length(), bound);
        int contentWidth = bound.width();
        return this.getLeft() + this.getWidth() / 2 - contentWidth / 2;
    }

    @Override
    public int getContentTop() {
        Paint.FontMetrics metrics = this.getPaint().getFontMetrics();
        float contentHeight = metrics.bottom - metrics.top;
        return (int)((float)(this.getHeight() / 2) - contentHeight / 2.0f);
    }

    @Override
    public int getContentRight() {
        Rect bound = new Rect();
        this.getPaint().getTextBounds(this.getText().toString(), 0, this.getText().length(), bound);
        int contentWidth = bound.width();
        return this.getLeft() + this.getWidth() / 2 + contentWidth / 2;
    }

    @Override
    public int getContentBottom() {
        Paint.FontMetrics metrics = this.getPaint().getFontMetrics();
        float contentHeight = metrics.bottom - metrics.top;
        return (int)((float)(this.getHeight() / 2) + contentHeight / 2.0f);
    }

    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public int getNormalColor() {
        return this.mNormalColor;
    }

    public void setNormalColor(int normalColor) {
        this.mNormalColor = normalColor;
    }
}

