/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator.buildins.commonnavigator.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.List;
import net.lucode.hackware.magicindicator.FragmentContainerHelper;
import net.lucode.hackware.magicindicator.buildins.UIUtil;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.model.PositionData;

public class TriangularPagerIndicator
extends View
implements IPagerIndicator {
    private List<PositionData> mPositionDataList;
    private Paint mPaint;
    private int mLineHeight;
    private int mLineColor;
    private int mTriangleHeight;
    private int mTriangleWidth;
    private boolean mReverse;
    private float mYOffset;
    private Path mPath = new Path();
    private Interpolator mStartInterpolator = new LinearInterpolator();
    private float mAnchorX;

    public TriangularPagerIndicator(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mLineHeight = UIUtil.dip2px(context, 3.0);
        this.mTriangleWidth = UIUtil.dip2px(context, 14.0);
        this.mTriangleHeight = UIUtil.dip2px(context, 8.0);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.mLineColor);
        if (this.mReverse) {
            canvas.drawRect(0.0f, (float)this.getHeight() - this.mYOffset - (float)this.mTriangleHeight, (float)this.getWidth(), (float)this.getHeight() - this.mYOffset - (float)this.mTriangleHeight + (float)this.mLineHeight, this.mPaint);
        } else {
            canvas.drawRect(0.0f, (float)(this.getHeight() - this.mLineHeight) - this.mYOffset, (float)this.getWidth(), (float)this.getHeight() - this.mYOffset, this.mPaint);
        }
        this.mPath.reset();
        if (this.mReverse) {
            this.mPath.moveTo(this.mAnchorX - (float)(this.mTriangleWidth / 2), (float)this.getHeight() - this.mYOffset - (float)this.mTriangleHeight);
            this.mPath.lineTo(this.mAnchorX, (float)this.getHeight() - this.mYOffset);
            this.mPath.lineTo(this.mAnchorX + (float)(this.mTriangleWidth / 2), (float)this.getHeight() - this.mYOffset - (float)this.mTriangleHeight);
        } else {
            this.mPath.moveTo(this.mAnchorX - (float)(this.mTriangleWidth / 2), (float)this.getHeight() - this.mYOffset);
            this.mPath.lineTo(this.mAnchorX, (float)(this.getHeight() - this.mTriangleHeight) - this.mYOffset);
            this.mPath.lineTo(this.mAnchorX + (float)(this.mTriangleWidth / 2), (float)this.getHeight() - this.mYOffset);
        }
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaint);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mPositionDataList == null || this.mPositionDataList.isEmpty()) {
            return;
        }
        PositionData current = FragmentContainerHelper.getImitativePositionData(this.mPositionDataList, position);
        PositionData next = FragmentContainerHelper.getImitativePositionData(this.mPositionDataList, position + 1);
        float leftX = current.mLeft + (current.mRight - current.mLeft) / 2;
        float rightX = next.mLeft + (next.mRight - next.mLeft) / 2;
        this.mAnchorX = leftX + (rightX - leftX) * this.mStartInterpolator.getInterpolation(positionOffset);
        this.invalidate();
    }

    @Override
    public void onPageSelected(int position) {
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void onPositionDataProvide(List<PositionData> dataList) {
        this.mPositionDataList = dataList;
    }

    public int getLineHeight() {
        return this.mLineHeight;
    }

    public void setLineHeight(int lineHeight) {
        this.mLineHeight = lineHeight;
    }

    public int getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(int lineColor) {
        this.mLineColor = lineColor;
    }

    public int getTriangleHeight() {
        return this.mTriangleHeight;
    }

    public void setTriangleHeight(int triangleHeight) {
        this.mTriangleHeight = triangleHeight;
    }

    public int getTriangleWidth() {
        return this.mTriangleWidth;
    }

    public void setTriangleWidth(int triangleWidth) {
        this.mTriangleWidth = triangleWidth;
    }

    public Interpolator getStartInterpolator() {
        return this.mStartInterpolator;
    }

    public void setStartInterpolator(Interpolator startInterpolator) {
        this.mStartInterpolator = startInterpolator;
        if (this.mStartInterpolator == null) {
            this.mStartInterpolator = new LinearInterpolator();
        }
    }

    public boolean isReverse() {
        return this.mReverse;
    }

    public void setReverse(boolean reverse) {
        this.mReverse = reverse;
    }

    public float getYOffset() {
        return this.mYOffset;
    }

    public void setYOffset(float yOffset) {
        this.mYOffset = yOffset;
    }
}

