/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator.buildins.circlenavigator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.List;
import net.lucode.hackware.magicindicator.abs.IPagerNavigator;
import net.lucode.hackware.magicindicator.buildins.UIUtil;

public class CircleNavigator
extends View
implements IPagerNavigator {
    private int mRadius;
    private int mCircleColor;
    private int mStrokeWidth;
    private int mCircleSpacing;
    private int mCurrentIndex;
    private int mTotalCount;
    private Interpolator mStartInterpolator = new LinearInterpolator();
    private Paint mPaint = new Paint(1);
    private List<PointF> mCirclePoints = new ArrayList<PointF>();
    private float mIndicatorX;
    private boolean mTouchable;
    private OnCircleClickListener mCircleClickListener;
    private float mDownX;
    private float mDownY;
    private int mTouchSlop;
    private boolean mFollowTouch = true;

    public CircleNavigator(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mRadius = UIUtil.dip2px(context, 3.0);
        this.mCircleSpacing = UIUtil.dip2px(context, 8.0);
        this.mStrokeWidth = UIUtil.dip2px(context, 1.0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int result = 0;
        switch (mode) {
            case 0x40000000: {
                result = width;
                break;
            }
            case -2147483648: 
            case 0: {
                result = this.mTotalCount * this.mRadius * 2 + (this.mTotalCount - 1) * this.mCircleSpacing + this.getPaddingLeft() + this.getPaddingRight() + this.mStrokeWidth * 2;
                break;
            }
        }
        return result;
    }

    private int measureHeight(int heightMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int result = 0;
        switch (mode) {
            case 0x40000000: {
                result = height;
                break;
            }
            case -2147483648: 
            case 0: {
                result = this.mRadius * 2 + this.mStrokeWidth * 2 + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.mCircleColor);
        this.drawCircles(canvas);
        this.drawIndicator(canvas);
    }

    private void drawCircles(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
        int j = this.mCirclePoints.size();
        for (int i = 0; i < j; ++i) {
            PointF pointF = this.mCirclePoints.get(i);
            canvas.drawCircle(pointF.x, pointF.y, (float)this.mRadius, this.mPaint);
        }
    }

    private void drawIndicator(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        if (this.mCirclePoints.size() > 0) {
            canvas.drawCircle(this.mIndicatorX, (float)((int)((float)this.getHeight() / 2.0f + 0.5f)), (float)this.mRadius, this.mPaint);
        }
    }

    private void prepareCirclePoints() {
        this.mCirclePoints.clear();
        if (this.mTotalCount > 0) {
            int y = (int)((float)this.getHeight() / 2.0f + 0.5f);
            int centerSpacing = this.mRadius * 2 + this.mCircleSpacing;
            int startX = this.mRadius + (int)((float)this.mStrokeWidth / 2.0f + 0.5f) + this.getPaddingLeft();
            for (int i = 0; i < this.mTotalCount; ++i) {
                PointF pointF = new PointF((float)startX, (float)y);
                this.mCirclePoints.add(pointF);
                startX += centerSpacing;
            }
            this.mIndicatorX = this.mCirclePoints.get((int)this.mCurrentIndex).x;
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mFollowTouch) {
            if (this.mCirclePoints.isEmpty()) {
                return;
            }
            int currentPosition = Math.min(this.mCirclePoints.size() - 1, position);
            int nextPosition = Math.min(this.mCirclePoints.size() - 1, position + 1);
            PointF current = this.mCirclePoints.get(currentPosition);
            PointF next = this.mCirclePoints.get(nextPosition);
            this.mIndicatorX = current.x + (next.x - current.x) * this.mStartInterpolator.getInterpolation(positionOffset);
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                if (!this.mTouchable) break;
                this.mDownX = x;
                this.mDownY = y;
                return true;
            }
            case 1: {
                if (this.mCircleClickListener == null || !(Math.abs(x - this.mDownX) <= (float)this.mTouchSlop) || !(Math.abs(y - this.mDownY) <= (float)this.mTouchSlop)) break;
                float max = Float.MAX_VALUE;
                int index = 0;
                for (int i = 0; i < this.mCirclePoints.size(); ++i) {
                    PointF pointF = this.mCirclePoints.get(i);
                    float offset = Math.abs(pointF.x - x);
                    if (!(offset < max)) continue;
                    max = offset;
                    index = i;
                }
                this.mCircleClickListener.onClick(index);
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    @Override
    public void onPageSelected(int position) {
        this.mCurrentIndex = position;
        if (!this.mFollowTouch) {
            this.mIndicatorX = this.mCirclePoints.get((int)this.mCurrentIndex).x;
            this.invalidate();
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.prepareCirclePoints();
    }

    @Override
    public void onAttachToMagicIndicator() {
    }

    @Override
    public void notifyDataSetChanged() {
        this.prepareCirclePoints();
        this.invalidate();
    }

    @Override
    public void onDetachFromMagicIndicator() {
    }

    public int getRadius() {
        return this.mRadius;
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
        this.prepareCirclePoints();
        this.invalidate();
    }

    public int getCircleColor() {
        return this.mCircleColor;
    }

    public void setCircleColor(int circleColor) {
        this.mCircleColor = circleColor;
        this.invalidate();
    }

    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.mStrokeWidth = strokeWidth;
        this.invalidate();
    }

    public int getCircleSpacing() {
        return this.mCircleSpacing;
    }

    public void setCircleSpacing(int circleSpacing) {
        this.mCircleSpacing = circleSpacing;
        this.prepareCirclePoints();
        this.invalidate();
    }

    public Interpolator getStartInterpolator() {
        return this.mStartInterpolator;
    }

    public void setStartInterpolator(Interpolator startInterpolator) {
        this.mStartInterpolator = startInterpolator;
        if (this.mStartInterpolator == null) {
            this.mStartInterpolator = new LinearInterpolator();
        }
    }

    public int getCircleCount() {
        return this.mTotalCount;
    }

    public void setCircleCount(int count) {
        this.mTotalCount = count;
    }

    public boolean isTouchable() {
        return this.mTouchable;
    }

    public void setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    public boolean isFollowTouch() {
        return this.mFollowTouch;
    }

    public void setFollowTouch(boolean followTouch) {
        this.mFollowTouch = followTouch;
    }

    public OnCircleClickListener getCircleClickListener() {
        return this.mCircleClickListener;
    }

    public void setCircleClickListener(OnCircleClickListener circleClickListener) {
        if (!this.mTouchable) {
            this.mTouchable = true;
        }
        this.mCircleClickListener = circleClickListener;
    }

    public static interface OnCircleClickListener {
        public void onClick(int var1);
    }
}

