/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator.buildins.commonnavigator.titles.badge;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IMeasurablePagerTitleView;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerTitleView;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.titles.badge.BadgeAnchor;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.titles.badge.BadgeRule;

public class BadgePagerTitleView
extends FrameLayout
implements IMeasurablePagerTitleView {
    private IPagerTitleView mInnerPagerTitleView;
    private View mBadgeView;
    private boolean mAutoCancelBadge = true;
    private BadgeRule mXBadgeRule;
    private BadgeRule mYBadgeRule;

    public BadgePagerTitleView(Context context) {
        super(context);
    }

    @Override
    public void onSelected(int index, int totalCount) {
        if (this.mInnerPagerTitleView != null) {
            this.mInnerPagerTitleView.onSelected(index, totalCount);
        }
        if (this.mAutoCancelBadge) {
            this.setBadgeView(null);
        }
    }

    @Override
    public void onDeselected(int index, int totalCount) {
        if (this.mInnerPagerTitleView != null) {
            this.mInnerPagerTitleView.onDeselected(index, totalCount);
        }
    }

    @Override
    public void onLeave(int index, int totalCount, float leavePercent, boolean leftToRight) {
        if (this.mInnerPagerTitleView != null) {
            this.mInnerPagerTitleView.onLeave(index, totalCount, leavePercent, leftToRight);
        }
    }

    @Override
    public void onEnter(int index, int totalCount, float enterPercent, boolean leftToRight) {
        if (this.mInnerPagerTitleView != null) {
            this.mInnerPagerTitleView.onEnter(index, totalCount, enterPercent, leftToRight);
        }
    }

    public IPagerTitleView getInnerPagerTitleView() {
        return this.mInnerPagerTitleView;
    }

    public void setInnerPagerTitleView(IPagerTitleView innerPagerTitleView) {
        FrameLayout.LayoutParams lp;
        if (this.mInnerPagerTitleView == innerPagerTitleView) {
            return;
        }
        this.mInnerPagerTitleView = innerPagerTitleView;
        this.removeAllViews();
        if (this.mInnerPagerTitleView instanceof View) {
            lp = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mInnerPagerTitleView, (ViewGroup.LayoutParams)lp);
        }
        if (this.mBadgeView != null) {
            lp = new FrameLayout.LayoutParams(-2, -2);
            this.addView(this.mBadgeView, (ViewGroup.LayoutParams)lp);
        }
    }

    public View getBadgeView() {
        return this.mBadgeView;
    }

    public void setBadgeView(View badgeView) {
        FrameLayout.LayoutParams lp;
        if (this.mBadgeView == badgeView) {
            return;
        }
        this.mBadgeView = badgeView;
        this.removeAllViews();
        if (this.mInnerPagerTitleView instanceof View) {
            lp = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mInnerPagerTitleView, (ViewGroup.LayoutParams)lp);
        }
        if (this.mBadgeView != null) {
            lp = new FrameLayout.LayoutParams(-2, -2);
            this.addView(this.mBadgeView, (ViewGroup.LayoutParams)lp);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mInnerPagerTitleView instanceof View && this.mBadgeView != null) {
            int offset;
            int[] position = new int[14];
            View v = (View)this.mInnerPagerTitleView;
            position[0] = v.getLeft();
            position[1] = v.getTop();
            position[2] = v.getRight();
            position[3] = v.getBottom();
            if (this.mInnerPagerTitleView instanceof IMeasurablePagerTitleView) {
                IMeasurablePagerTitleView view = (IMeasurablePagerTitleView)this.mInnerPagerTitleView;
                position[4] = view.getContentLeft();
                position[5] = view.getContentTop();
                position[6] = view.getContentRight();
                position[7] = view.getContentBottom();
            } else {
                for (int i = 4; i < 8; ++i) {
                    position[i] = position[i - 4];
                }
            }
            position[8] = v.getWidth() / 2;
            position[9] = v.getHeight() / 2;
            position[10] = position[4] / 2;
            position[11] = position[5] / 2;
            position[12] = position[6] + (position[2] - position[6]) / 2;
            position[13] = position[7] + (position[3] - position[7]) / 2;
            if (this.mXBadgeRule != null) {
                int x = position[this.mXBadgeRule.getAnchor().ordinal()];
                offset = this.mXBadgeRule.getOffset();
                int newLeft = x + offset;
                this.mBadgeView.offsetLeftAndRight(newLeft - this.mBadgeView.getLeft());
            }
            if (this.mYBadgeRule != null) {
                int y = position[this.mYBadgeRule.getAnchor().ordinal()];
                offset = this.mYBadgeRule.getOffset();
                int newTop = y + offset;
                this.mBadgeView.offsetTopAndBottom(newTop - this.mBadgeView.getTop());
            }
        }
    }

    @Override
    public int getContentLeft() {
        if (this.mInnerPagerTitleView instanceof IMeasurablePagerTitleView) {
            return this.getLeft() + ((IMeasurablePagerTitleView)this.mInnerPagerTitleView).getContentLeft();
        }
        return this.getLeft();
    }

    @Override
    public int getContentTop() {
        if (this.mInnerPagerTitleView instanceof IMeasurablePagerTitleView) {
            return ((IMeasurablePagerTitleView)this.mInnerPagerTitleView).getContentTop();
        }
        return this.getTop();
    }

    @Override
    public int getContentRight() {
        if (this.mInnerPagerTitleView instanceof IMeasurablePagerTitleView) {
            return this.getLeft() + ((IMeasurablePagerTitleView)this.mInnerPagerTitleView).getContentRight();
        }
        return this.getRight();
    }

    @Override
    public int getContentBottom() {
        if (this.mInnerPagerTitleView instanceof IMeasurablePagerTitleView) {
            return ((IMeasurablePagerTitleView)this.mInnerPagerTitleView).getContentBottom();
        }
        return this.getBottom();
    }

    public BadgeRule getXBadgeRule() {
        return this.mXBadgeRule;
    }

    public void setXBadgeRule(BadgeRule badgeRule) {
        BadgeAnchor anchor;
        if (badgeRule != null && (anchor = badgeRule.getAnchor()) != BadgeAnchor.LEFT && anchor != BadgeAnchor.RIGHT && anchor != BadgeAnchor.CONTENT_LEFT && anchor != BadgeAnchor.CONTENT_RIGHT && anchor != BadgeAnchor.CENTER_X && anchor != BadgeAnchor.LEFT_EDGE_CENTER_X && anchor != BadgeAnchor.RIGHT_EDGE_CENTER_X) {
            throw new IllegalArgumentException("x badge rule is wrong.");
        }
        this.mXBadgeRule = badgeRule;
    }

    public BadgeRule getYBadgeRule() {
        return this.mYBadgeRule;
    }

    public void setYBadgeRule(BadgeRule badgeRule) {
        BadgeAnchor anchor;
        if (badgeRule != null && (anchor = badgeRule.getAnchor()) != BadgeAnchor.TOP && anchor != BadgeAnchor.BOTTOM && anchor != BadgeAnchor.CONTENT_TOP && anchor != BadgeAnchor.CONTENT_BOTTOM && anchor != BadgeAnchor.CENTER_Y && anchor != BadgeAnchor.TOP_EDGE_CENTER_Y && anchor != BadgeAnchor.BOTTOM_EDGE_CENTER_Y) {
            throw new IllegalArgumentException("y badge rule is wrong.");
        }
        this.mYBadgeRule = badgeRule;
    }

    public boolean isAutoCancelBadge() {
        return this.mAutoCancelBadge;
    }

    public void setAutoCancelBadge(boolean autoCancelBadge) {
        this.mAutoCancelBadge = autoCancelBadge;
    }
}

