/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator.buildins.commonnavigator.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.Arrays;
import java.util.List;
import net.lucode.hackware.magicindicator.buildins.ArgbEvaluatorHolder;
import net.lucode.hackware.magicindicator.buildins.UIUtil;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.model.PositionData;

public class BezierPagerIndicator
extends View
implements IPagerIndicator {
    private List<PositionData> mPositionDataList;
    private float mLeftCircleRadius;
    private float mLeftCircleX;
    private float mRightCircleRadius;
    private float mRightCircleX;
    private float mYOffset;
    private float mMaxCircleRadius;
    private float mMinCircleRadius;
    private Paint mPaint;
    private Path mPath = new Path();
    private List<Integer> mColors;
    private Interpolator mStartInterpolator = new AccelerateInterpolator();
    private Interpolator mEndInterpolator = new DecelerateInterpolator();

    public BezierPagerIndicator(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mMaxCircleRadius = UIUtil.dip2px(context, 3.5);
        this.mMinCircleRadius = UIUtil.dip2px(context, 2.0);
        this.mYOffset = UIUtil.dip2px(context, 1.5);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawCircle(this.mLeftCircleX, (float)this.getHeight() - this.mYOffset - this.mMaxCircleRadius, this.mLeftCircleRadius, this.mPaint);
        canvas.drawCircle(this.mRightCircleX, (float)this.getHeight() - this.mYOffset - this.mMaxCircleRadius, this.mRightCircleRadius, this.mPaint);
        this.drawBezierCurve(canvas);
    }

    private void drawBezierCurve(Canvas canvas) {
        this.mPath.reset();
        float y = (float)this.getHeight() - this.mYOffset - this.mMaxCircleRadius;
        this.mPath.moveTo(this.mRightCircleX, y);
        this.mPath.lineTo(this.mRightCircleX, y - this.mRightCircleRadius);
        this.mPath.quadTo(this.mRightCircleX + (this.mLeftCircleX - this.mRightCircleX) / 2.0f, y, this.mLeftCircleX, y - this.mLeftCircleRadius);
        this.mPath.lineTo(this.mLeftCircleX, y + this.mLeftCircleRadius);
        this.mPath.quadTo(this.mRightCircleX + (this.mLeftCircleX - this.mRightCircleX) / 2.0f, y, this.mRightCircleX, y + this.mRightCircleRadius);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaint);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mPositionDataList == null || this.mPositionDataList.isEmpty()) {
            return;
        }
        if (this.mColors != null && this.mColors.size() > 0) {
            int currentColor = this.mColors.get(position % this.mColors.size());
            int nextColor = this.mColors.get((position + 1) % this.mColors.size());
            int color = ArgbEvaluatorHolder.eval(positionOffset, currentColor, nextColor);
            this.mPaint.setColor(color);
        }
        int currentPosition = Math.min(this.mPositionDataList.size() - 1, position);
        int nextPosition = Math.min(this.mPositionDataList.size() - 1, position + 1);
        PositionData current = this.mPositionDataList.get(currentPosition);
        PositionData next = this.mPositionDataList.get(nextPosition);
        float leftX = current.mLeft + (current.mRight - current.mLeft) / 2;
        float rightX = next.mLeft + (next.mRight - next.mLeft) / 2;
        this.mLeftCircleX = leftX + (rightX - leftX) * this.mStartInterpolator.getInterpolation(positionOffset);
        this.mRightCircleX = leftX + (rightX - leftX) * this.mEndInterpolator.getInterpolation(positionOffset);
        this.mLeftCircleRadius = this.mMaxCircleRadius + (this.mMinCircleRadius - this.mMaxCircleRadius) * this.mEndInterpolator.getInterpolation(positionOffset);
        this.mRightCircleRadius = this.mMinCircleRadius + (this.mMaxCircleRadius - this.mMinCircleRadius) * this.mStartInterpolator.getInterpolation(positionOffset);
        this.invalidate();
    }

    @Override
    public void onPageSelected(int position) {
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void onPositionDataProvide(List<PositionData> dataList) {
        this.mPositionDataList = dataList;
    }

    public float getMaxCircleRadius() {
        return this.mMaxCircleRadius;
    }

    public void setMaxCircleRadius(float maxCircleRadius) {
        this.mMaxCircleRadius = maxCircleRadius;
    }

    public float getMinCircleRadius() {
        return this.mMinCircleRadius;
    }

    public void setMinCircleRadius(float minCircleRadius) {
        this.mMinCircleRadius = minCircleRadius;
    }

    public float getYOffset() {
        return this.mYOffset;
    }

    public void setYOffset(float yOffset) {
        this.mYOffset = yOffset;
    }

    public void setColors(Integer ... colors) {
        this.mColors = Arrays.asList(colors);
    }

    public void setStartInterpolator(Interpolator startInterpolator) {
        this.mStartInterpolator = startInterpolator;
        if (this.mStartInterpolator == null) {
            this.mStartInterpolator = new AccelerateInterpolator();
        }
    }

    public void setEndInterpolator(Interpolator endInterpolator) {
        this.mEndInterpolator = endInterpolator;
        if (this.mEndInterpolator == null) {
            this.mEndInterpolator = new DecelerateInterpolator();
        }
    }
}

