/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import net.lucode.hackware.magicindicator.abs.IPagerNavigator;

public class MagicIndicator
extends FrameLayout {
    private IPagerNavigator mNavigator;

    public MagicIndicator(Context context) {
        super(context);
    }

    public MagicIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mNavigator != null) {
            this.mNavigator.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mNavigator != null) {
            this.mNavigator.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mNavigator != null) {
            this.mNavigator.onPageScrollStateChanged(state);
        }
    }

    public IPagerNavigator getNavigator() {
        return this.mNavigator;
    }

    public void setNavigator(IPagerNavigator navigator) {
        if (this.mNavigator == navigator) {
            return;
        }
        if (this.mNavigator != null) {
            this.mNavigator.onDetachFromMagicIndicator();
        }
        this.mNavigator = navigator;
        this.removeAllViews();
        if (this.mNavigator instanceof View) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mNavigator, (ViewGroup.LayoutParams)lp);
            this.mNavigator.onAttachToMagicIndicator();
        }
    }
}

