/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.IOException;
import java.io.InputStream;

public final class AssetsUtils {
    public static byte[] readByteArray(Context context, String assetPath) {
        LogUtils.verbose("read assets file as byte array: " + assetPath);
        try {
            return ConvertUtils.toByteArray(context.getAssets().open(assetPath));
        }
        catch (IOException e) {
            LogUtils.error(e);
            return null;
        }
    }

    public static String readText(Context context, String assetPath) {
        LogUtils.verbose("read assets file as text: " + assetPath);
        try {
            return ConvertUtils.toString(context.getAssets().open(assetPath)).trim();
        }
        catch (IOException e) {
            LogUtils.error(e);
            return "";
        }
    }

    public static Bitmap readBitmap(Context context, String assetPath) {
        LogUtils.verbose("read assets file as bitmap: " + assetPath);
        Bitmap bitmap = null;
        try {
            InputStream is = context.getAssets().open(assetPath);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
            bitmap.setDensity(96);
            is.close();
        }
        catch (IOException e) {
            LogUtils.error(e);
        }
        return bitmap;
    }
}

