/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.qqtheme.framework.popup.BasicPopup;
import cn.qqtheme.framework.util.ConvertUtils;

public abstract class ConfirmPopup<V extends View>
extends BasicPopup<View> {
    protected boolean topLineVisible = true;
    protected int topLineColor = -2236963;
    protected int topLineHeight = 1;
    protected int topBackgroundColor = -1;
    protected int topHeight = 40;
    protected int topPadding = 8;
    protected boolean cancelVisible = true;
    protected CharSequence cancelText = "";
    protected CharSequence submitText = "";
    protected CharSequence titleText = "";
    protected int cancelTextColor = -16777216;
    protected int submitTextColor = -16777216;
    protected int titleTextColor = -16777216;
    protected int pressedTextColor = -16611122;
    protected int cancelTextSize = 0;
    protected int submitTextSize = 0;
    protected int titleTextSize = 0;
    protected int backgroundColor = -1;
    private Button cancelButton;
    private Button submitButton;
    private TextView titleView;

    public ConfirmPopup(Activity activity) {
        super(activity);
        this.cancelText = activity.getString(0x1040000);
        this.submitText = activity.getString(17039370);
    }

    public void setTopLineColor(@ColorInt int topLineColor) {
        this.topLineColor = topLineColor;
    }

    public void setTopLineHeight(int topLineHeight) {
        this.topLineHeight = topLineHeight;
    }

    public void setTopBackgroundColor(@ColorInt int topBackgroundColor) {
        this.topBackgroundColor = topBackgroundColor;
    }

    public void setTopHeight(@IntRange(from=10L, to=80L) int topHeight) {
        this.topHeight = topHeight;
    }

    public void setTopPadding(int topPadding) {
        this.topPadding = topPadding;
    }

    public void setTopLineVisible(boolean topLineVisible) {
        this.topLineVisible = topLineVisible;
    }

    public void setCancelVisible(boolean cancelVisible) {
        if (null != this.cancelButton) {
            this.cancelButton.setVisibility(cancelVisible ? 0 : 8);
        } else {
            this.cancelVisible = cancelVisible;
        }
    }

    public void setCancelText(CharSequence cancelText) {
        if (null != this.cancelButton) {
            this.cancelButton.setText(cancelText);
        } else {
            this.cancelText = cancelText;
        }
    }

    public void setCancelText(@StringRes int textRes) {
        this.setCancelText(this.activity.getString(textRes));
    }

    public void setSubmitText(CharSequence submitText) {
        if (null != this.submitButton) {
            this.submitButton.setText(submitText);
        } else {
            this.submitText = submitText;
        }
    }

    public void setSubmitText(@StringRes int textRes) {
        this.setSubmitText(this.activity.getString(textRes));
    }

    public void setTitleText(CharSequence titleText) {
        if (this.titleView != null) {
            this.titleView.setText(titleText);
        } else {
            this.titleText = titleText;
        }
    }

    public void setTitleText(@StringRes int textRes) {
        this.setTitleText(this.activity.getString(textRes));
    }

    public void setCancelTextColor(@ColorInt int cancelTextColor) {
        if (null != this.cancelButton) {
            this.cancelButton.setTextColor(cancelTextColor);
        } else {
            this.cancelTextColor = cancelTextColor;
        }
    }

    public void setSubmitTextColor(@ColorInt int submitTextColor) {
        if (null != this.submitButton) {
            this.submitButton.setTextColor(submitTextColor);
        } else {
            this.submitTextColor = submitTextColor;
        }
    }

    public void setTitleTextColor(@ColorInt int titleTextColor) {
        if (null != this.titleView) {
            this.titleView.setTextColor(titleTextColor);
        } else {
            this.titleTextColor = titleTextColor;
        }
    }

    public void setPressedTextColor(int pressedTextColor) {
        this.pressedTextColor = pressedTextColor;
    }

    public void setCancelTextSize(@IntRange(from=10L, to=40L) int cancelTextSize) {
        this.cancelTextSize = cancelTextSize;
    }

    public void setSubmitTextSize(@IntRange(from=10L, to=40L) int submitTextSize) {
        this.submitTextSize = submitTextSize;
    }

    public void setTitleTextSize(@IntRange(from=10L, to=40L) int titleTextSize) {
        this.titleTextSize = titleTextSize;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public TextView getTitleView() {
        return this.titleView;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    @Override
    protected final View makeContentView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setBackgroundColor(this.backgroundColor);
        rootLayout.setOrientation(1);
        rootLayout.setGravity(17);
        rootLayout.setPadding(0, 0, 0, 0);
        rootLayout.setClipToPadding(false);
        View headerView = this.makeHeaderView();
        if (headerView != null) {
            rootLayout.addView(headerView);
        }
        if (this.topLineVisible) {
            View lineView = new View((Context)this.activity);
            int height = ConvertUtils.toPx((Context)this.activity, this.topLineHeight);
            lineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, height));
            lineView.setBackgroundColor(this.topLineColor);
            rootLayout.addView(lineView);
        }
        rootLayout.addView(this.makeCenterView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        View footerView = this.makeFooterView();
        if (footerView != null) {
            rootLayout.addView(footerView);
        }
        return rootLayout;
    }

    @Nullable
    protected View makeHeaderView() {
        int margin;
        RelativeLayout topButtonLayout = new RelativeLayout((Context)this.activity);
        int height = ConvertUtils.toPx((Context)this.activity, this.topHeight);
        topButtonLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
        topButtonLayout.setBackgroundColor(this.topBackgroundColor);
        topButtonLayout.setGravity(16);
        this.cancelButton = new Button((Context)this.activity);
        this.cancelButton.setVisibility(this.cancelVisible ? 0 : 8);
        RelativeLayout.LayoutParams cancelParams = new RelativeLayout.LayoutParams(-2, -1);
        cancelParams.addRule(9, -1);
        cancelParams.addRule(15, -1);
        this.cancelButton.setLayoutParams((ViewGroup.LayoutParams)cancelParams);
        this.cancelButton.setBackgroundColor(0);
        this.cancelButton.setGravity(17);
        int padding = ConvertUtils.toPx((Context)this.activity, this.topPadding);
        this.cancelButton.setPadding(padding, 0, padding, 0);
        if (!TextUtils.isEmpty((CharSequence)this.cancelText)) {
            this.cancelButton.setText(this.cancelText);
        }
        this.cancelButton.setTextColor(ConvertUtils.toColorStateList(this.cancelTextColor, this.pressedTextColor));
        if (this.cancelTextSize != 0) {
            this.cancelButton.setTextSize((float)this.cancelTextSize);
        }
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmPopup.this.dismiss();
                ConfirmPopup.this.onCancel();
            }
        });
        topButtonLayout.addView((View)this.cancelButton);
        this.titleView = new TextView((Context)this.activity);
        RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
        titleParams.leftMargin = margin = ConvertUtils.toPx((Context)this.activity, this.topPadding);
        titleParams.rightMargin = margin;
        titleParams.addRule(14, -1);
        titleParams.addRule(15, -1);
        this.titleView.setLayoutParams((ViewGroup.LayoutParams)titleParams);
        this.titleView.setGravity(17);
        if (!TextUtils.isEmpty((CharSequence)this.titleText)) {
            this.titleView.setText(this.titleText);
        }
        this.titleView.setTextColor(this.titleTextColor);
        if (this.titleTextSize != 0) {
            this.titleView.setTextSize((float)this.titleTextSize);
        }
        topButtonLayout.addView((View)this.titleView);
        this.submitButton = new Button((Context)this.activity);
        RelativeLayout.LayoutParams submitParams = new RelativeLayout.LayoutParams(-2, -1);
        submitParams.addRule(11, -1);
        submitParams.addRule(15, -1);
        this.submitButton.setLayoutParams((ViewGroup.LayoutParams)submitParams);
        this.submitButton.setBackgroundColor(0);
        this.submitButton.setGravity(17);
        this.submitButton.setPadding(padding, 0, padding, 0);
        if (!TextUtils.isEmpty((CharSequence)this.submitText)) {
            this.submitButton.setText(this.submitText);
        }
        this.submitButton.setTextColor(ConvertUtils.toColorStateList(this.submitTextColor, this.pressedTextColor));
        if (this.submitTextSize != 0) {
            this.submitButton.setTextSize((float)this.submitTextSize);
        }
        this.submitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmPopup.this.dismiss();
                ConfirmPopup.this.onSubmit();
            }
        });
        topButtonLayout.addView((View)this.submitButton);
        return topButtonLayout;
    }

    @NonNull
    protected abstract V makeCenterView();

    @Nullable
    protected View makeFooterView() {
        return null;
    }

    protected void onSubmit() {
    }

    protected void onCancel() {
    }
}

