/*
 * Decompiled with CFR 0.152.
 */
package com.github.guanpy.library.inner;

import com.github.guanpy.library.inner.AnnBuilder;
import com.github.guanpy.library.inner.base.MethodSpec;
import com.github.guanpy.library.inner.base.ReflectionUtils;
import com.github.guanpy.library.inner.bus.ReceiveEventsAnn;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassSpecRegistry {
    private static final ConcurrentHashMap<Class<?>, MethodSpec<ReceiveEventsAnn>[]> RECEIVE_EVENTS_SPECS = new ConcurrentHashMap();

    public static MethodSpec<ReceiveEventsAnn>[] getReceiveEventsSpecs(Class<?> cls) {
        MethodSpec<ReceiveEventsAnn>[] specs = RECEIVE_EVENTS_SPECS.get(cls);
        if (specs == null) {
            ArrayList<MethodSpec<ReceiveEventsAnn>> list = new ArrayList<MethodSpec<ReceiveEventsAnn>>();
            for (Class<?> cl : ReflectionUtils.buildClassHierarchy(cls)) {
                for (Method method : cl.getDeclaredMethods()) {
                    ReceiveEventsAnn ann = AnnBuilder.getReceiveEventsAnn(method);
                    if (ann == null) continue;
                    list.add(new MethodSpec<ReceiveEventsAnn>(method, ann));
                }
            }
            specs = list.toArray(new MethodSpec[list.size()]);
            RECEIVE_EVENTS_SPECS.put(cls, specs);
        }
        return specs;
    }
}

