/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.sandbox;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingManager {
    private static final Logger log = LoggerFactory.getLogger(CachingManager.class);
    private final File cacheDir;

    public CachingManager(String filePath) {
        boolean created;
        this.cacheDir = new File(filePath);
        if (!this.cacheDir.exists() && !(created = this.cacheDir.mkdirs())) {
            throw new RuntimeException("Failed to create cache directory at " + filePath);
        }
    }

    public void saveContent(String fileName, String content) {
        File file = new File(this.cacheDir, fileName);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
        catch (IOException e) {
            log.error("Error occur while writing data to file with name: {} error message was {}", (Object)fileName, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public String loadCache(String fileName) {
        String string;
        File file = new File(this.cacheDir, fileName);
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append(System.lineSeparator());
            }
            string = builder.toString().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                log.error("Error was occur because of file isn't exist, error message was - {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                log.error("Error was occur during reading data from file, error message was - {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return string;
    }
}

