/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.multiusermode.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.util.DecryptionUtils;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationUtil {
    private static final Logger log = LoggerFactory.getLogger(TransformationUtil.class);

    public static JsonObject transformFeatures(String featuresJsonString) {
        try {
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(featuresJsonString, JsonObject.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static JsonObject transformSavedGroups(String savedGroupsJsonString) {
        try {
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(savedGroupsJsonString, JsonObject.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static JsonObject transformEncryptedFeatures(@Nullable String featuresJson, @Nullable String encryptionKey) {
        JsonObject jsonObject = new JsonObject();
        if (encryptionKey != null && featuresJson != null) {
            try {
                String decrypted = DecryptionUtils.decrypt(featuresJson, encryptionKey);
                String featuresJsonDecrypted = decrypted.trim();
                jsonObject = TransformationUtil.transformFeatures(featuresJsonDecrypted);
            }
            catch (DecryptionUtils.DecryptionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (featuresJson != null) {
            jsonObject = TransformationUtil.transformFeatures(featuresJson);
        }
        return jsonObject;
    }

    public static JsonObject transformAttributes(@Nullable String attributesJsonString) {
        try {
            if (attributesJsonString == null) {
                return new JsonObject();
            }
            JsonElement element = (JsonElement)GrowthBookJsonUtils.getInstance().gson.fromJson(attributesJsonString, JsonElement.class);
            if (element == null || element.isJsonNull()) {
                return new JsonObject();
            }
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(attributesJsonString, JsonObject.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonObject();
        }
    }
}

