/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.evaluators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.evaluators.ConditionEvaluator;
import growthbook.sdk.java.evaluators.ExperimentEvaluator;
import growthbook.sdk.java.evaluators.IFeatureEvaluator;
import growthbook.sdk.java.model.Experiment;
import growthbook.sdk.java.model.ExperimentResult;
import growthbook.sdk.java.model.Feature;
import growthbook.sdk.java.model.FeatureResult;
import growthbook.sdk.java.model.FeatureResultSource;
import growthbook.sdk.java.model.FeatureRule;
import growthbook.sdk.java.model.Filter;
import growthbook.sdk.java.model.ParentCondition;
import growthbook.sdk.java.multiusermode.configurations.EvaluationContext;
import growthbook.sdk.java.multiusermode.usage.FeatureUsageCallbackWithUser;
import growthbook.sdk.java.multiusermode.usage.TrackingCallbackWithUser;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import growthbook.sdk.java.util.GrowthBookUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureEvaluator
implements IFeatureEvaluator {
    private static final Logger log = LoggerFactory.getLogger(FeatureEvaluator.class);
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private final ExperimentEvaluator experimentEvaluator = new ExperimentEvaluator();

    @Override
    public <ValueType> FeatureResult<ValueType> evaluateFeature(String key, EvaluationContext context, Class<ValueType> valueTypeClass) throws ClassCastException {
        FeatureUsageCallbackWithUser featureUsageCallbackWithUser = context.getOptions().getFeatureUsageCallbackWithUser();
        FeatureResult unknownFeatureResult = FeatureResult.builder().value(null).source(FeatureResultSource.UNKNOWN_FEATURE).build();
        try {
            ValueType forcedValue;
            Map<String, Object> forcedFeatureValues = this.getForcedFeatureValues(context);
            if (forcedFeatureValues.containsKey(key)) {
                Object unwrapForceFeatureValue = GrowthBookJsonUtils.unwrap(forcedFeatureValues.get(key));
                log.info("Global override for forced feature with key: {} and value {}", (Object)key, (Object)forcedFeatureValues.get(key).toString());
                return FeatureResult.builder().value(unwrapForceFeatureValue).source(FeatureResultSource.OVERRIDE).build();
            }
            if (context.getStack().getEvaluatedFeatures().contains(key)) {
                log.info("evaluateFeature: circular dependency detected: {} -> {}. { from: {}, to: {} }", new Object[]{context.getStack().getId(), key, context.getStack().getId(), key});
                FeatureResult featureResultWhenCircularDependencyDetected = FeatureResult.builder().value(null).source(FeatureResultSource.CYCLIC_PREREQUISITE).build();
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, featureResultWhenCircularDependencyDetected, context.getUser());
                }
                this.leaveCircularLoop(context);
                return featureResultWhenCircularDependencyDetected;
            }
            this.addFeatureToEvalStack(key, context);
            if (context.getOptions().getAllowUrlOverrides().booleanValue() && (forcedValue = this.evaluateForcedFeatureValueFromUrl(key, context.getOptions().getUrl(), valueTypeClass)) != null) {
                FeatureResult urlFeatureResult = FeatureResult.builder().value(forcedValue).source(FeatureResultSource.URL_OVERRIDE).build();
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, urlFeatureResult, context.getUser());
                }
                return urlFeatureResult;
            }
            JsonObject features = context.getGlobal().getFeatures();
            if (features == null || !features.has(key)) {
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, unknownFeatureResult, context.getUser());
                }
                return unknownFeatureResult;
            }
            JsonElement featureJson = features.get(key);
            FeatureResult defaultValueFeature = FeatureResult.builder().value(null).source(FeatureResultSource.DEFAULT_VALUE).build();
            if (featureJson == null) {
                log.info("featureJson is null");
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, defaultValueFeature, context.getUser());
                }
                return defaultValueFeature;
            }
            Feature feature = (Feature)this.jsonUtils.gson.fromJson(featureJson, Feature.class);
            if (feature == null) {
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, defaultValueFeature, context.getUser());
                }
                return defaultValueFeature;
            }
            if (feature.getRules() == null || feature.getRules().isEmpty()) {
                Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
                FeatureResult defaultValueFeatureForRules = FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, defaultValueFeatureForRules, context.getUser());
                }
                return defaultValueFeatureForRules;
            }
            ArrayList featureRules = feature.getRules();
            for (FeatureRule featureRule : featureRules) {
                Experiment experiment;
                ExperimentResult result;
                ArrayList<Filter> filters;
                if (featureRule.getParentConditions() != null) {
                    for (ParentCondition parentCondition : featureRule.getParentConditions()) {
                        JsonObject parentAttributesJson;
                        boolean evalCondition;
                        FeatureResult<ValueType> parentResult = this.evaluateFeature(parentCondition.getId(), context, valueTypeClass);
                        if (FeatureResultSource.CYCLIC_PREREQUISITE.equals((Object)parentResult.getSource())) {
                            FeatureResult featureResultWhenCircularDependencyDetected = FeatureResult.builder().value(null).source(FeatureResultSource.CYCLIC_PREREQUISITE).build();
                            if (featureUsageCallbackWithUser != null) {
                                featureUsageCallbackWithUser.onFeatureUsage(key, featureResultWhenCircularDependencyDetected, context.getUser());
                            }
                            return featureResultWhenCircularDependencyDetected;
                        }
                        HashMap<String, Object> evalObj = new HashMap<String, Object>();
                        if (parentResult.getValue() != null) {
                            evalObj.put("value", parentResult.getValue());
                        }
                        if ((evalCondition = this.conditionEvaluator.evaluateCondition(parentAttributesJson = GrowthBookJsonUtils.getInstance().gson.toJsonTree(evalObj).getAsJsonObject(), parentCondition.getCondition(), context.getGlobal().getSavedGroups()).booleanValue()) || !Boolean.TRUE.equals(parentCondition.getGate())) continue;
                        log.info("Feature blocked by prerequisite");
                        FeatureResult featureResultWhenBlockedByPrerequisite = FeatureResult.builder().value(null).source(FeatureResultSource.PREREQUISITE).build();
                        if (featureUsageCallbackWithUser != null) {
                            featureUsageCallbackWithUser.onFeatureUsage(key, featureResultWhenBlockedByPrerequisite, context.getUser());
                        }
                        return featureResultWhenBlockedByPrerequisite;
                    }
                }
                if (GrowthBookUtils.isFilteredOut(filters = featureRule.getFilters(), context.getUser().getAttributes()).booleanValue()) continue;
                if (featureRule.getForce() != null && featureRule.getForce().isPresent()) {
                    String seed;
                    if (featureRule.getCondition() != null && !this.conditionEvaluator.evaluateCondition(context.getUser().getAttributes(), featureRule.getCondition(), context.getGlobal().getSavedGroups()).booleanValue()) continue;
                    boolean gate1 = context.getOptions().getStickyBucketService() != null;
                    boolean gate2 = !Boolean.TRUE.equals(featureRule.getDisableStickyBucketing());
                    boolean shouldFallbackAttributeBePassed = gate1 && gate2;
                    String fallback = shouldFallbackAttributeBePassed ? featureRule.getFallbackAttribute() : null;
                    String ruleKey = featureRule.getHashAttribute();
                    if (ruleKey == null) {
                        ruleKey = "id";
                    }
                    if ((seed = featureRule.getSeed()) == null) {
                        seed = key;
                    }
                    if (!GrowthBookUtils.isIncludedInRollout(context.getUser().getAttributes(), seed, ruleKey, fallback, featureRule.getRange(), featureRule.getCoverage(), featureRule.getHashVersion()).booleanValue()) continue;
                    ArrayList trackData = featureRule.getTracks();
                    TrackingCallbackWithUser trackingCallBackWithUser = context.getOptions().getTrackingCallBackWithUser();
                    if (trackData != null && trackingCallBackWithUser != null) {
                        trackData.forEach(t -> trackingCallBackWithUser.onTrack(t.getExperiment(), t.getResult().getExperimentResult(), context.getUser()));
                    }
                    if (featureRule.getRange() == null && featureRule.getCoverage() != null) {
                        String attributeValue = context.getUser().getAttributes().get(ruleKey) == null ? null : context.getUser().getAttributes().get(ruleKey).getAsString();
                        if (attributeValue == null || attributeValue.isEmpty()) continue;
                        Float hashFNV = GrowthBookUtils.hash(attributeValue, 1, key);
                        if (hashFNV == null) {
                            hashFNV = Float.valueOf(0.0f);
                        }
                        if (hashFNV.floatValue() > featureRule.getCoverage().floatValue()) continue;
                    }
                    Object value = GrowthBookJsonUtils.unwrap(featureRule.getForce().getValue());
                    FeatureResult forcedRuleFeatureValue = FeatureResult.builder().value(value).source(FeatureResultSource.FORCE).build();
                    if (featureUsageCallbackWithUser != null) {
                        featureUsageCallbackWithUser.onFeatureUsage(key, forcedRuleFeatureValue, context.getUser());
                    }
                    return forcedRuleFeatureValue;
                }
                ArrayList variations = featureRule.getVariations();
                if (variations == null) continue;
                String experimentKey = featureRule.getKey();
                if (experimentKey == null) {
                    experimentKey = key;
                }
                if (!(result = this.experimentEvaluator.evaluateExperiment(experiment = Experiment.builder().key(experimentKey).variations(variations).coverage(featureRule.getCoverage()).weights(featureRule.getWeights()).hashAttribute(featureRule.getHashAttribute()).fallbackAttribute(featureRule.getFallbackAttribute()).disableStickyBucketing(featureRule.getDisableStickyBucketing()).bucketVersion(featureRule.getBucketVersion()).minBucketVersion(featureRule.getMinBucketVersion()).namespace(featureRule.getNamespace()).meta(featureRule.getMeta()).ranges(featureRule.getRanges()).name(featureRule.getName()).phase(featureRule.getPhase()).seed(featureRule.getSeed()).hashVersion(featureRule.getHashVersion()).filters(featureRule.getFilters()).conditionJson(featureRule.getCondition()).parentConditions(featureRule.getParentConditions()).build(), context, key)).getInExperiment().booleanValue() || result.getPassThrough() != null && result.getPassThrough().booleanValue()) continue;
                Object value = GrowthBookJsonUtils.unwrap(result.getValue());
                FeatureResult experimentFeatureResult = FeatureResult.builder().value(value).source(FeatureResultSource.EXPERIMENT).experiment(experiment).experimentResult(result).build();
                if (featureUsageCallbackWithUser != null) {
                    featureUsageCallbackWithUser.onFeatureUsage(key, experimentFeatureResult, context.getUser());
                }
                return experimentFeatureResult;
            }
            Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
            FeatureResult featureResult = FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
            if (featureUsageCallbackWithUser != null) {
                featureUsageCallbackWithUser.onFeatureUsage(key, featureResult, context.getUser());
            }
            return featureResult;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return unknownFeatureResult;
        }
    }

    @Nullable
    private <ValueType> ValueType evaluateForcedFeatureValueFromUrl(String key, @Nullable String urlString, Class<ValueType> valueTypeClass) {
        if (urlString == null) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            if (valueTypeClass.equals(Boolean.class)) {
                return (ValueType)GrowthBookUtils.getForcedBooleanValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(String.class)) {
                return (ValueType)GrowthBookUtils.getForcedStringValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Integer.class)) {
                return (ValueType)GrowthBookUtils.getForcedIntegerValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Float.class)) {
                return (ValueType)GrowthBookUtils.getForcedFloatValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Double.class)) {
                return (ValueType)GrowthBookUtils.getForcedDoubleValueFromUrl(key, url);
            }
            return GrowthBookUtils.getForcedSerializableValueFromUrl(key, url, valueTypeClass, this.jsonUtils.gson);
        }
        catch (ClassCastException | MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void leaveCircularLoop(EvaluationContext context) {
        context.getStack().setId(null);
        context.getStack().getEvaluatedFeatures().clear();
    }

    private void addFeatureToEvalStack(String featureKey, EvaluationContext context) {
        context.getStack().setId(featureKey);
        context.getStack().getEvaluatedFeatures().add(featureKey);
    }

    private Map<String, Object> getForcedFeatureValues(EvaluationContext evaluationContext) {
        Map globalFeatures = evaluationContext.getGlobal() != null ? evaluationContext.getGlobal().getForcedFeatureValues() : Collections.emptyMap();
        Map userFeatures = evaluationContext.getUser() != null ? evaluationContext.getUser().getForcedFeatureValues() : Collections.emptyMap();
        return GrowthBookUtils.mergeMaps(Arrays.asList(globalFeatures, userFeatures));
    }
}

