/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.ConditionEvaluator;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentEvaluator;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.ExperimentRunCallback;
import growthbook.sdk.java.FeatureEvaluator;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.GBContext;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.GrowthBookUtils;
import growthbook.sdk.java.IGrowthBook;
import growthbook.sdk.java.stickyBucketing.InMemoryStickyBucketServiceImpl;
import growthbook.sdk.java.stickyBucketing.StickyAssignmentsDocument;
import growthbook.sdk.java.stickyBucketing.StickyBucketService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowthBook
implements IGrowthBook {
    private static final Logger log = LoggerFactory.getLogger(GrowthBook.class);
    private final GBContext context;
    private final FeatureEvaluator featureEvaluator;
    private final ConditionEvaluator conditionEvaluator;
    private final ExperimentEvaluator experimentEvaluatorEvaluator;
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private ArrayList<ExperimentRunCallback> callbacks = new ArrayList();
    private JsonObject attributeOverrides = new JsonObject();
    private JsonObject savedGroups = new JsonObject();

    public GrowthBook(GBContext context) {
        this.context = context;
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
        this.attributeOverrides = context.getAttributes();
        this.savedGroups = context.getSavedGroups();
    }

    public GrowthBook() {
        this.context = GBContext.builder().build();
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
        this.attributeOverrides = this.context.getAttributes();
        this.savedGroups = this.context.getSavedGroups();
    }

    GrowthBook(GBContext context, FeatureEvaluator featureEvaluator, ConditionEvaluator conditionEvaluator, ExperimentEvaluator experimentEvaluator) {
        this.featureEvaluator = featureEvaluator;
        this.conditionEvaluator = conditionEvaluator;
        this.experimentEvaluatorEvaluator = experimentEvaluator;
        this.context = context;
    }

    @Override
    @Nullable
    public <ValueType> FeatureResult<ValueType> evalFeature(String key, Class<ValueType> valueTypeClass) {
        return this.featureEvaluator.evaluateFeature(key, this.context, valueTypeClass, this.attributeOverrides);
    }

    @Override
    public void setFeatures(String featuresJsonString) {
        this.context.setFeaturesJson(featuresJsonString);
    }

    @Override
    public void setSavedGroups(JsonObject savedGroups) {
        this.context.setSavedGroups(savedGroups);
    }

    @Override
    public void setAttributes(String attributesJsonString) {
        this.context.setAttributesJson(attributesJsonString);
    }

    @Override
    public <ValueType> ExperimentResult<ValueType> run(Experiment<ValueType> experiment) {
        ExperimentResult result = this.experimentEvaluatorEvaluator.evaluateExperiment(experiment, this.context, null, this.attributeOverrides);
        this.callbacks.forEach(callback -> callback.onRun(result));
        return result;
    }

    @Override
    public void setOwnStickyBucketService(@Nullable StickyBucketService stickyBucketService) {
        this.context.setStickyBucketService(stickyBucketService);
    }

    @Override
    public void setInMemoryStickyBucketService() {
        this.context.setStickyBucketService(new InMemoryStickyBucketServiceImpl(new HashMap<String, StickyAssignmentsDocument>()));
    }

    @Override
    public Boolean isOn(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class, this.attributeOverrides).isOn();
    }

    @Override
    public Boolean isOff(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class, this.attributeOverrides).isOff();
    }

    @Override
    public Boolean getFeatureValue(String featureKey, Boolean defaultValue) {
        try {
            Boolean maybeValue = (Boolean)this.featureEvaluator.evaluateFeature(featureKey, this.context, Boolean.class, this.attributeOverrides).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public String getFeatureValue(String featureKey, String defaultValue) {
        try {
            String maybeValue = (String)this.featureEvaluator.evaluateFeature(featureKey, this.context, String.class, this.attributeOverrides).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Float getFeatureValue(String featureKey, Float defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class, this.attributeOverrides).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            if (maybeValue instanceof Double) {
                return Float.valueOf(((Double)maybeValue).floatValue());
            }
            if (maybeValue instanceof Long) {
                return Float.valueOf(((Long)maybeValue).floatValue());
            }
            return defaultValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Integer getFeatureValue(String featureKey, Integer defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class, this.attributeOverrides).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            if (maybeValue instanceof Double) {
                return ((Double)maybeValue).intValue();
            }
            if (maybeValue instanceof Long) {
                return ((Long)maybeValue).intValue();
            }
            return defaultValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Object getFeatureValue(String featureKey, Object defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, defaultValue.getClass(), this.attributeOverrides).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public <ValueType> ValueType getFeatureValue(String featureKey, ValueType defaultValue, Class<ValueType> gsonDeserializableClass) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, gsonDeserializableClass, this.attributeOverrides).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            String stringValue = this.jsonUtils.gson.toJson(maybeValue);
            return (ValueType)this.jsonUtils.gson.fromJson(stringValue, gsonDeserializableClass);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Boolean evaluateCondition(String attributesJsonString, String conditionJsonString) {
        try {
            JsonObject attributesJson = (JsonObject)this.jsonUtils.gson.fromJson(attributesJsonString, JsonObject.class);
            JsonObject conditionJson = (JsonObject)this.jsonUtils.gson.fromJson(conditionJsonString, JsonObject.class);
            JsonObject savedGroupsJson = (JsonObject)this.jsonUtils.gson.fromJson((JsonElement)this.savedGroups, JsonObject.class);
            return this.conditionEvaluator.evaluateCondition(attributesJson, conditionJson, savedGroupsJson);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public Double getFeatureValue(String featureKey, Double defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class, this.attributeOverrides).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            if (maybeValue instanceof Double) {
                return (Double)maybeValue;
            }
            if (maybeValue instanceof Long) {
                return ((Long)maybeValue).doubleValue();
            }
            return defaultValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public void destroy() {
        this.callbacks = new ArrayList();
    }

    @Override
    public void subscribe(ExperimentRunCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void featuresAPIModelSuccessfully(String featuresDataModel) {
        this.refreshStickyBucketService(featuresDataModel);
    }

    @Override
    public Boolean isFeatureEnabled(String featureKey) {
        if (this.context.getFeatures() != null) {
            return this.context.getFeatures().keySet().contains(featureKey);
        }
        return false;
    }

    private void refreshStickyBucketService(@Nullable String featuresDataModel) {
        if (this.context.getStickyBucketService() != null) {
            GrowthBookUtils.refreshStickyBuckets(this.context, featuresDataModel, this.attributeOverrides);
        }
    }
}

